/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeQueryUtil;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MkTreeRKNNQuery;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import java.util.ArrayList;

public class MkMaxTreeIndex<O>
extends MkMaxTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
RKNNIndex<O>,
DynamicIndex {
    private Relation<O> relation;

    public MkMaxTreeIndex(Relation<O> relation, PageFile<MkMaxTreeNode<O>> pageFile, MkTreeSettings<O, MkMaxTreeNode<O>, MkMaxEntry> mkTreeSettings) {
        super(relation, pageFile, mkTreeSettings);
        this.relation = relation;
    }

    protected MkMaxLeafEntry createNewLeafEntry(DBID dBID, O o, double d) {
        KNNList kNNList = this.knnq.getKNNForObject(o, this.getKmax() - 1);
        double d2 = kNNList.getKNNDistance();
        return new MkMaxLeafEntry(dBID, d, d2);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public void insert(DBIDRef dBIDRef) {
        this.insert(this.createNewLeafEntry(DBIDUtil.deref(dBIDRef), this.relation.get(dBIDRef), Double.NaN), false);
    }

    @Override
    public void insertAll(DBIDs dBIDs) {
        ArrayList<MkMaxLeafEntry> arrayList = new ArrayList<MkMaxLeafEntry>(dBIDs.size());
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDIter);
            O o = this.relation.get(dBID);
            arrayList.add(this.createNewLeafEntry(dBID, o, Double.NaN));
            dBIDIter.advance();
        }
        this.insertAll(arrayList);
    }

    @Override
    public final boolean delete(DBIDRef dBIDRef) {
        throw new NotImplementedException("Not yet supported.");
    }

    @Override
    public void deleteAll(DBIDs dBIDs) {
        throw new NotImplementedException("Not yet supported.");
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return MTreeQueryUtil.getKNNQuery(this, distanceQuery, objectArray);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return MTreeQueryUtil.getRangeQuery(this, distanceQuery, new Object[0]);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        return new MkTreeRKNNQuery<O>(this, distanceQuery);
    }

    @Override
    public String getLongName() {
        return "MkMax-Tree";
    }

    @Override
    public String getShortName() {
        return "mkmaxtree";
    }
}

