/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Antonin Guttman", title="R-Trees: A Dynamic Index Structure For Spatial Searching", booktitle="Proceedings of the 1984 ACM SIGMOD international conference on Management of data", url="http://dx.doi.org/10.1145/971697.602266")
public class RTreeQuadraticSplit
implements SplitStrategy {
    public static final RTreeQuadraticSplit STATIC = new RTreeQuadraticSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A a, ArrayAdapter<E, A> arrayAdapter, int n) {
        int n2;
        SpatialComparable spatialComparable;
        int n3;
        int n4 = arrayAdapter.size(a);
        long[] lArray = BitsUtil.zero(n4);
        long[] lArray2 = BitsUtil.zero(n4);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.NEGATIVE_INFINITY;
        int n5 = 0;
        int n6 = 0;
        double[] dArray = new double[n4];
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            spatialComparable = (SpatialComparable)arrayAdapter.get(a, n3);
            dArray[n3] = SpatialUtil.volume(spatialComparable);
        }
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            spatialComparable = (SpatialComparable)arrayAdapter.get(a, n3);
            for (n2 = n3 + 1; n2 < n4; ++n2) {
                SpatialComparable spatialComparable2 = (SpatialComparable)arrayAdapter.get(a, n2);
                double d4 = SpatialUtil.volumeUnion(spatialComparable, spatialComparable2);
                double d5 = d4 - dArray[n3] - dArray[n2];
                if (!(d5 > d3)) continue;
                d3 = d5;
                n5 = n3;
                n6 = n2;
            }
        }
        BitsUtil.setI(lArray2, n5);
        BitsUtil.setI(lArray2, n6);
        BitsUtil.setI(lArray, n6);
        d = dArray[n5];
        d2 = dArray[n6];
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox((SpatialComparable)arrayAdapter.get(a, n5));
        ModifiableHyperBoundingBox modifiableHyperBoundingBox2 = new ModifiableHyperBoundingBox((SpatialComparable)arrayAdapter.get(a, n6));
        int n7 = 1;
        int n8 = 1;
        n5 = n4 - 2;
        while (n5 > 0 && n7 + n5 > n) {
            if (n8 + n5 <= n) {
                n6 = BitsUtil.nextClearBit(lArray2, 0);
                while (n6 < n4) {
                    BitsUtil.setI(lArray, n6);
                    n6 = BitsUtil.nextClearBit(lArray2, n6 + 1);
                }
                break;
            }
            double d6 = Double.NEGATIVE_INFINITY;
            n3 = -1;
            spatialComparable = null;
            n2 = 0;
            int n9 = BitsUtil.nextClearBit(lArray2, 0);
            while (n9 < n4) {
                double d7;
                SpatialComparable spatialComparable3 = (SpatialComparable)arrayAdapter.get(a, n9);
                double d8 = SpatialUtil.volumeUnion(modifiableHyperBoundingBox, spatialComparable3) - d;
                double d9 = Math.abs(d8 - (d7 = SpatialUtil.volumeUnion(modifiableHyperBoundingBox2, spatialComparable3) - d2));
                if (d9 > d6) {
                    d6 = d9;
                    n3 = n9;
                    spatialComparable = spatialComparable3;
                    n2 = d7 < d8 ? 1 : 0;
                }
                n9 = BitsUtil.nextClearBit(lArray2, n9 + 1);
            }
            if (d6 == 0.0) {
                n2 = d != d2 ? (d2 < d ? 1 : 0) : (n8 < n7 ? 1 : 0);
            }
            BitsUtil.setI(lArray2, n3);
            --n5;
            if (n2 == 0) {
                ++n7;
                modifiableHyperBoundingBox.extend(spatialComparable);
                d = SpatialUtil.volume(modifiableHyperBoundingBox);
                continue;
            }
            ++n8;
            BitsUtil.setI(lArray, n3);
            modifiableHyperBoundingBox2.extend(spatialComparable);
            d2 = SpatialUtil.volume(modifiableHyperBoundingBox2);
        }
        return lArray;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RTreeQuadraticSplit makeInstance() {
            return STATIC;
        }
    }
}

