/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.dimensionsimilarity;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarity;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarityMatrix;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. of the 2013 ACM International Conference on Management of Data (SIGMOD)", url="http://dx.doi.org/10.1145/2463676.2463696")
public class SURFINGDimensionSimilarity
implements DimensionSimilarity<NumberVector> {
    public static final SURFINGDimensionSimilarity STATIC = new SURFINGDimensionSimilarity();

    protected SURFINGDimensionSimilarity() {
    }

    @Override
    @Reference(authors="Christian Baumgartner, Claudia Plant, Karin Kailing, Hans-Peter Kriegel, and Peer Kr\u00f6ger", title="Subspace Selection for Clustering High-Dimensional Data", booktitle="IEEE International Conference on Data Mining, 2004", url="http://dx.doi.org/10.1109/ICDM.2004.10112")
    public void computeDimensionSimilarites(Relation<? extends NumberVector> relation, DBIDs dBIDs, DimensionSimilarityMatrix dimensionSimilarityMatrix) {
        int n = dimensionSimilarityMatrix.size();
        Mean mean = new Mean();
        int n2 = Math.max(1, dBIDs.size() / 10);
        double[] dArray = new double[dBIDs.size()];
        for (int i = 0; i < n; ++i) {
            int n3 = dimensionSimilarityMatrix.dim(i);
            for (int j = i + 1; j < n; ++j) {
                int n4 = dimensionSimilarityMatrix.dim(j);
                long[] lArray = BitsUtil.zero(n);
                BitsUtil.setI(lArray, n3);
                BitsUtil.setI(lArray, n4);
                SubspaceEuclideanDistanceFunction subspaceEuclideanDistanceFunction = new SubspaceEuclideanDistanceFunction(lArray);
                KNNQuery<? extends NumberVector> kNNQuery = relation.getKNNQuery(subspaceEuclideanDistanceFunction, n2);
                mean.reset();
                int n5 = 0;
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    double d = kNNQuery.getKNNForDBID(dBIDIter, n2).getKNNDistance();
                    mean.put(d);
                    dArray[n5] = d;
                    dBIDIter.advance();
                    ++n5;
                }
                double d = mean.getMean();
                double d2 = 0.0;
                int n6 = 0;
                for (int k = 0; k < dArray.length; ++k) {
                    d2 += Math.abs(d - dArray[k]);
                    if (!(dArray[k] < d)) continue;
                    ++n6;
                }
                dimensionSimilarityMatrix.set(i, j, n6 > 0 ? d2 / (2.0 * d * (double)n6) : 0.0);
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SURFINGDimensionSimilarity makeInstance() {
            return STATIC;
        }
    }
}

