/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.dimensionsimilarity;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarity;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarityMatrix;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. of the 2013 ACM International Conference on Management of Data (SIGMOD)", url="http://dx.doi.org/10.1145/2463676.2463696")
public class SlopeDimensionSimilarity
implements DimensionSimilarity<NumberVector> {
    public static final SlopeDimensionSimilarity STATIC = new SlopeDimensionSimilarity();
    protected static final int PRECISION = 40;
    protected static final double LOG_PRECISION = Math.log(40.0);
    protected static final double RESCALE = 20.0;

    protected SlopeDimensionSimilarity() {
    }

    @Override
    public void computeDimensionSimilarites(Relation<? extends NumberVector> relation, DBIDs dBIDs, DimensionSimilarityMatrix dimensionSimilarityMatrix) {
        int n = dimensionSimilarityMatrix.size();
        int n2 = dBIDs.size();
        Object object = RelationUtil.computeMinMax(relation);
        double[] dArray = object[0];
        double[] dArray2 = object[1];
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            dArray2[n3] = dArray2[n3] - dArray[i];
            dArray2[i] = dArray2[i] > 0.0 ? 1.0 / dArray2[i] : 1.0;
        }
        object = new int[n][n][40];
        double[] dArray3 = new double[n];
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            int n4;
            NumberVector numberVector = relation.get(dBIDIter);
            for (n4 = 0; n4 < n; ++n4) {
                dArray3[n4] = (numberVector.doubleValue(dimensionSimilarityMatrix.dim(n4)) - dArray[n4]) * dArray2[n4];
            }
            for (n4 = 0; n4 < n - 1; ++n4) {
                for (int i = n4 + 1; i < n; ++i) {
                    double d = dArray3[i] - dArray3[n4] + 1.0;
                    int n5 = (int)Math.round(d * 20.0);
                    n5 = n5 < 0 ? 0 : (n5 >= 40 ? 39 : n5);
                    double d2 = object[n4][i];
                    int n6 = n5;
                    d2[n6] = d2[n6] + true;
                }
            }
            dBIDIter.advance();
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double d = 0.0;
                double d3 = object[i][j];
                for (int k = 0; k < 40; ++k) {
                    if (d3[k] <= 0) continue;
                    double d4 = (double)d3[k] / (double)n2;
                    d += d4 * Math.log(d4);
                }
                dimensionSimilarityMatrix.set(i, j, 1.0 + (d /= LOG_PRECISION));
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SlopeDimensionSimilarity makeInstance() {
            return STATIC;
        }
    }
}

