/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.result.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class XYPlot
implements Result,
Iterable<Curve> {
    protected static final double THRESHOLD = 1.0E-13;
    protected ArrayList<Curve> curves = new ArrayList();
    protected String labelx;
    protected String labely;
    protected double minx = Double.POSITIVE_INFINITY;
    protected double maxx = Double.NEGATIVE_INFINITY;
    protected double miny = Double.POSITIVE_INFINITY;
    protected double maxy = Double.NEGATIVE_INFINITY;

    public XYPlot(String string, String string2) {
        this.labelx = string;
        this.labely = string2;
    }

    public XYPlot() {
        this("X", "Y");
    }

    public Curve makeCurve() {
        Curve curve = new Curve(this.curves.size());
        this.curves.add(curve);
        return curve;
    }

    public Curve makeCurve(int n) {
        Curve curve = new Curve(n);
        this.curves.add(curve);
        return curve;
    }

    public Curve makeCurve(int n, int n2) {
        Curve curve = new Curve(n, n2);
        this.curves.add(curve);
        return curve;
    }

    public String getLabelx() {
        return this.labelx;
    }

    public String getLabely() {
        return this.labely;
    }

    public double getMinx() {
        return this.minx;
    }

    public double getMaxx() {
        return this.maxx;
    }

    public double getMiny() {
        return this.miny;
    }

    public double getMaxy() {
        return this.maxy;
    }

    @Override
    public Iterator<Curve> iterator() {
        return this.curves.iterator();
    }

    @Override
    public String getLongName() {
        return this.labelx + "-" + this.labely + "-Curve";
    }

    @Override
    public String getShortName() {
        return (this.labelx + "-" + this.labely + "-curve").toLowerCase();
    }

    public class Curve {
        protected double[] data;
        protected int len = 0;
        protected int color;

        public Curve(int n) {
            this.color = n;
            this.data = new double[32];
        }

        public Curve(int n, int n2) {
            this.color = n;
            this.data = new double[n2 << 1];
        }

        public int getColor() {
            return this.color;
        }

        public void add(double d, double d2) {
            if (this.len == this.data.length) {
                this.data = Arrays.copyOf(this.data, this.len << 1);
            }
            this.data[this.len++] = d;
            this.data[this.len++] = d2;
            XYPlot.this.minx = Math.min(XYPlot.this.minx, d);
            XYPlot.this.maxx = Math.max(XYPlot.this.maxx, d);
            XYPlot.this.miny = Math.min(XYPlot.this.miny, d2);
            XYPlot.this.maxy = Math.max(XYPlot.this.maxy, d2);
        }

        public double getX(int n) {
            return this.data[n << 1];
        }

        public double getY(int n) {
            return this.data[(n << 1) + 1];
        }

        public int size() {
            return this.len >> 1;
        }

        public Itr iterator() {
            return new Itr();
        }

        public class Itr {
            protected int pos = 0;

            public double getX() {
                return Curve.this.data[this.pos];
            }

            public double getY() {
                return Curve.this.data[this.pos + 1];
            }

            public void advance() {
                this.pos += 2;
            }

            public boolean valid() {
                return this.pos < Curve.this.len;
            }
        }
    }
}

