/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.ArrayList;

@Title(value="Relative EigenPair Filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and returns those eigenpairs, whose eigenvalue is above the average ('expected') eigenvalue of the remaining eigenvectors.")
public class RelativeEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_RALPHA = 1.1;
    private double ralpha;

    public RelativeEigenPairFilter(double d) {
        this.ralpha = d;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        EigenPair eigenPair;
        int n;
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        int n2 = sortedEigenPairs.size() - 1;
        double d = sortedEigenPairs.getEigenPair(sortedEigenPairs.size() - 1).getEigenvalue();
        for (n = sortedEigenPairs.size() - 2; n >= 0; --n) {
            eigenPair = sortedEigenPairs.getEigenPair(n);
            double d2 = (d += eigenPair.getEigenvalue()) / (double)(sortedEigenPairs.size() - n) * this.ralpha;
            if (!(eigenPair.getEigenvalue() >= d2)) continue;
            n2 = n;
            break;
        }
        for (n = 0; n <= n2; ++n) {
            eigenPair = sortedEigenPairs.getEigenPair(n);
            arrayList.add(eigenPair);
        }
        for (n = n2 + 1; n < sortedEigenPairs.size(); ++n) {
            eigenPair = sortedEigenPairs.getEigenPair(n);
            arrayList2.add(eigenPair);
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID EIGENPAIR_FILTER_RALPHA = new OptionID("pca.filter.relativealpha", "The sensitivity niveau for weak eigenvectors: An eigenvector which is at less than the given share of the statistical average variance is considered weak.");
        protected double ralpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(EIGENPAIR_FILTER_RALPHA, 1.1);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.ralpha = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected RelativeEigenPairFilter makeInstance() {
            return new RelativeEigenPairFilter(this.ralpha);
        }
    }
}

