/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.randomprojections.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Arrays;
import java.util.Random;

public abstract class AbstractRandomProjectionFamily
implements RandomProjectionFamily {
    protected Random random;

    public AbstractRandomProjectionFamily(RandomFactory randomFactory) {
        this.random = randomFactory.getSingleThreadedRandom();
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("randomproj.random", "Random generator seed.");
        protected RandomFactory random;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            RandomParameter randomParameter = new RandomParameter(RANDOM_ID);
            if (parameterization.grab(randomParameter)) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
        }
    }

    public static class MatrixProjection
    implements RandomProjectionFamily.Projection {
        double[][] matrix;
        private double[] buf;

        public MatrixProjection(double[][] dArray) {
            this.matrix = dArray;
            this.buf = new double[dArray.length];
        }

        @Override
        public double[] project(NumberVector numberVector) {
            return this.project(numberVector, new double[this.matrix.length]);
        }

        @Override
        public double[] project(NumberVector numberVector, double[] dArray) {
            int n;
            if (numberVector instanceof SparseNumberVector) {
                return this.projectSparse((SparseNumberVector)numberVector, dArray);
            }
            int n2 = MathUtil.min(this.buf.length, numberVector.getDimensionality());
            assert (dArray.length >= this.matrix.length) : "Output buffer too small!";
            for (n = 0; n < n2; ++n) {
                this.buf[n] = numberVector.doubleValue(n);
            }
            for (n = 0; n < this.matrix.length; ++n) {
                double[] dArray2 = this.matrix[n];
                double d = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d += dArray2[i] * this.buf[i];
                }
                dArray[n] = d;
            }
            for (n = this.matrix.length; n < dArray.length; ++n) {
                dArray[n] = 0.0;
            }
            return dArray;
        }

        private double[] projectSparse(SparseNumberVector sparseNumberVector, double[] dArray) {
            Arrays.fill(dArray, 0.0);
            int n = sparseNumberVector.iter();
            while (sparseNumberVector.iterValid(n)) {
                int n2 = sparseNumberVector.iterDim(n);
                double d = sparseNumberVector.iterDoubleValue(n);
                for (int i = 0; i < dArray.length; ++i) {
                    int n3 = i;
                    dArray[n3] = dArray[n3] + d * this.matrix[i][n2];
                }
                n = sparseNumberVector.iterAdvance(n);
            }
            return dArray;
        }

        @Override
        public int getOutputDimensionality() {
            return this.matrix.length;
        }
    }
}

