/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.random;

import de.lmu.ifi.dbs.elki.math.random.FastNonThreadsafeRandom;
import java.util.Random;

public class RandomFactory {
    public static RandomFactory DEFAULT = new RandomFactory(RandomFactory.getGlobalSeed()){

        @Override
        public String toString() {
            return "GlobalRandom[" + Long.toString(this.seed) + "]";
        }
    };
    protected long seed;

    private static long getGlobalSeed() {
        String string = System.getProperty("elki.seed");
        return string != null ? Long.parseLong(string) : System.nanoTime();
    }

    public static RandomFactory get(Long l) {
        if (l == null) {
            return DEFAULT;
        }
        return new RandomFactory(l);
    }

    public RandomFactory(long l) {
        this.seed = l;
    }

    public Random getRandom() {
        return new Random(this.seed++);
    }

    public Random getSingleThreadedRandom() {
        return new FastNonThreadsafeRandom(this.seed++);
    }

    public String toString() {
        return "Random[" + Long.toString(this.seed) + "]";
    }
}

