/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class CauchyDistribution
extends AbstractDistribution {
    final double location;
    final double shape;

    public CauchyDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    public CauchyDistribution(double d, double d2, Random random) {
        super(random);
        this.location = d;
        this.shape = d2;
    }

    public CauchyDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.location = d;
        this.shape = d2;
    }

    @Override
    public double pdf(double d) {
        return CauchyDistribution.pdf(d, this.location, this.shape);
    }

    @Override
    public double cdf(double d) {
        return CauchyDistribution.cdf(d, this.location, this.shape);
    }

    @Override
    public double quantile(double d) {
        return CauchyDistribution.quantile(d, this.location, this.shape);
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextDouble() - 0.5;
        return Math.tan(Math.PI * d);
    }

    public static double pdf(double d, double d2, double d3) {
        double d4 = (d - d2) / d3;
        return 0.3183098861837907 * d3 * (1.0 + d4 * d4);
    }

    public static double cdf(double d, double d2, double d3) {
        return Math.atan2(d - d2, d3) / Math.PI + 0.5;
    }

    public static double quantile(double d, double d2, double d3) {
        return d2 + d3 * Math.tan(Math.PI * (d - 0.5));
    }

    @Override
    public String toString() {
        return "CauchyDistribution(location=" + this.location + ", shape=" + this.shape + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SHAPE_ID = new OptionID("distribution.cauchy.shape", "Cauchy distribution gamma/shape parameter.");
        double location;
        double shape;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.location = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.shape = doubleParameter.doubleValue();
            }
        }

        @Override
        protected CauchyDistribution makeInstance() {
            return new CauchyDistribution(this.location, this.shape, this.rnd);
        }
    }
}

