/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Primes;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Reference(title="Randomized halton sequences", authors="Wang, X. and Hickernell, F.J.", booktitle="Mathematical and Computer Modelling Vol. 32 (7)", url="http://dx.doi.org/10.1016/S0895-7177(00)00178-3")
public class HaltonUniformDistribution
implements Distribution {
    private double min;
    private double max;
    private double len;
    private static final int MAXFAST = 1000;
    private static final double ALMOST_ONE = 0.9999999999;
    final short base;
    final double invbase;
    final double logbase;
    final int maxi;
    int counter = 0;
    double current;
    long inverse;

    public HaltonUniformDistribution(double d, double d2, int n, double d3) {
        if (d > d2) {
            double d4 = d;
            d = d2;
            d2 = d4;
        }
        this.min = d;
        this.max = d2;
        this.len = d2 - d;
        this.base = (short)n;
        this.invbase = 1.0 / (double)n;
        this.logbase = Math.log(n);
        this.maxi = (int)(32.0 * MathUtil.LOG2 / this.logbase);
        this.current = d3;
        this.inverse = this.inverse(d3);
    }

    public HaltonUniformDistribution(double d, double d2) {
        this(d, d2, new Random());
    }

    public HaltonUniformDistribution(double d, double d2, Random random) {
        this(d, d2, HaltonUniformDistribution.choosePrime(random), random.nextDouble());
    }

    public HaltonUniformDistribution(double d, double d2, RandomFactory randomFactory) {
        this(d, d2, randomFactory.getRandom());
    }

    private static int choosePrime(Random random) {
        return Primes.FIRST_PRIMES[random.nextInt(10)];
    }

    @Override
    public double pdf(double d) {
        if (d < this.min || d >= this.max) {
            return 0.0;
        }
        return 1.0 / this.len;
    }

    @Override
    public double cdf(double d) {
        if (d < this.min) {
            return 0.0;
        }
        if (d > this.max) {
            return 1.0;
        }
        return (d - this.min) / this.len;
    }

    @Override
    public double quantile(double d) {
        return this.min + this.len * d;
    }

    private long inverse(double d) {
        int n;
        short[] sArray = new short[this.maxi];
        for (n = 0; n < this.maxi; ++n) {
            sArray[n] = (short)(d *= (double)this.base);
            if ((d -= (double)sArray[n]) <= 1.0E-10) break;
        }
        long l = 0L;
        for (n = this.maxi - 1; n >= 0; --n) {
            l = l * (long)this.base + (long)sArray[n];
        }
        return l;
    }

    private double radicalInverse(long l) {
        double d;
        double d2 = d = 1.0 / (double)this.base;
        double d3 = 0.0;
        while (l > 0L) {
            d3 += d * (double)(l % (long)this.base);
            d *= d2;
            l /= (long)this.base;
        }
        return d3;
    }

    private double nextRadicalInverse() {
        ++this.counter;
        if (this.counter >= 1000) {
            this.counter = 0;
            this.inverse += 1000L;
            this.current = this.radicalInverse(this.inverse);
            return this.current;
        }
        double d = this.current + this.invbase;
        if (d < 0.9999999999) {
            this.current = d;
            return this.current;
        }
        double d2 = this.invbase;
        double d3 = this.invbase * this.invbase;
        while (this.current + d3 >= 0.9999999999) {
            d2 = d3;
            d3 *= this.invbase;
        }
        this.current += d2 - 1.0 + d3;
        return this.current;
    }

    @Override
    public double nextRandom() {
        return this.min + this.nextRadicalInverse() * this.len;
    }

    @Override
    public String toString() {
        return "HaltonUniformDistribution(min=" + this.min + ", max=" + this.max + ")";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double min;
        double max;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(UniformDistribution.Parameterizer.MIN_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.min = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(UniformDistribution.Parameterizer.MAX_ID))) {
                this.max = doubleParameter.doubleValue();
            }
        }

        @Override
        protected HaltonUniformDistribution makeInstance() {
            return new HaltonUniformDistribution(this.min, this.max, this.rnd);
        }
    }
}

