/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"fisk", "loglog"})
public class LogLogisticDistribution
extends AbstractDistribution {
    double scale;
    double shape;

    public LogLogisticDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    public LogLogisticDistribution(double d, double d2, Random random) {
        super(random);
        this.scale = d;
        this.shape = d2;
    }

    public LogLogisticDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.scale = d;
        this.shape = d2;
    }

    public static double pdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        d = Math.abs(d / d2);
        double d4 = d3 / d2 * Math.pow(d, d3 - 1.0);
        double d5 = 1.0 + Math.pow(d, d3);
        return d4 / (d5 * d5);
    }

    @Override
    public double pdf(double d) {
        return LogLogisticDistribution.pdf(d, this.scale, this.shape);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d < 0.0) {
            return 0.0;
        }
        return 1.0 / (1.0 + Math.pow(d / d2, -d3));
    }

    @Override
    public double cdf(double d) {
        return LogLogisticDistribution.cdf(d, this.scale, this.shape);
    }

    public static double quantile(double d, double d2, double d3) {
        return d2 * Math.pow(d / (1.0 - d), 1.0 / d3);
    }

    @Override
    public double quantile(double d) {
        return LogLogisticDistribution.quantile(d, this.scale, this.shape);
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextDouble();
        return this.scale * Math.pow(d / (1.0 - d), 1.0 / this.shape);
    }

    @Override
    public String toString() {
        return "LogLogisticDistribution(scale=" + this.scale + ", shape=" + this.shape + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double scale;
        double shape;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(SCALE_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.scale = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.shape = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LogLogisticDistribution makeInstance() {
            return new LogLogisticDistribution(this.scale, this.shape, this.rnd);
        }
    }
}

