/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GeneralizedLogisticAlternateDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report")
public class GeneralizedLogisticAlternateLMMEstimator
extends AbstractLMMEstimator<GeneralizedLogisticAlternateDistribution> {
    public static final GeneralizedLogisticAlternateLMMEstimator STATIC = new GeneralizedLogisticAlternateLMMEstimator();

    private GeneralizedLogisticAlternateLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public GeneralizedLogisticAlternateDistribution estimateFromLMoments(double[] dArray) {
        double d = -dArray[2];
        if (!(d >= -1.0) || !(d <= 1.0)) {
            throw new ArithmeticException("Invalid moment estimation.");
        }
        if (Math.abs(d) < 1.0E-6) {
            return new GeneralizedLogisticAlternateDistribution(dArray[0], dArray[1], 0.0);
        }
        double d2 = d * Math.PI / Math.sin(d * Math.PI);
        double d3 = dArray[1] / d2;
        double d4 = dArray[0] - d3 * (1.0 - d2) / d;
        return new GeneralizedLogisticAlternateDistribution(d4, d3, d);
    }

    @Override
    public Class<? super GeneralizedLogisticAlternateDistribution> getDistributionClass() {
        return GeneralizedLogisticAlternateDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GeneralizedLogisticAlternateLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

