/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.ProbabilityWeightedMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.UniformDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.CauchyMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.EMGOlivierNorbergEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExponentialLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExponentialMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExponentialMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExponentialMedianEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GammaLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GammaMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GammaMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GeneralizedExtremeValueLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GeneralizedLogisticAlternateLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GeneralizedParetoLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GumbelLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.GumbelMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LMMDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LaplaceLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LaplaceMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogGammaLogMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogGammaLogMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogLogisticMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMADDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogNormalBilkovaLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogNormalLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogNormalLogMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogNormalLogMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogisticLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogisticMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MOMDistributionEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.NormalLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.NormalMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.NormalMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.RayleighLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.RayleighMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.SkewGNormalLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.UniformEnhancedMinMaxEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.UniformLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.UniformMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.UniformMinMaxEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.WaldMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.WeibullLMMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.WeibullLogMADEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.tests.KolmogorovSmirnovTest;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class BestFitEstimator
implements DistributionEstimator<Distribution> {
    private static final Logging LOG = Logging.getLogger(BestFitEstimator.class);
    public static final BestFitEstimator STATIC = new BestFitEstimator();
    private Collection<MOMDistributionEstimator<?>> momests = new ArrayList(5);
    private Collection<MADDistributionEstimator<?>> madests;
    private Collection<LMMDistributionEstimator<?>> lmmests;
    private Collection<LogMOMDistributionEstimator<?>> logmomests;
    private Collection<LogMADDistributionEstimator<?>> logmadests;

    protected BestFitEstimator() {
        this.momests.add(NormalMOMEstimator.STATIC);
        this.momests.add(GammaMOMEstimator.STATIC);
        this.momests.add(WaldMOMEstimator.STATIC);
        this.momests.add(ExponentialMOMEstimator.STATIC);
        this.momests.add(EMGOlivierNorbergEstimator.STATIC);
        this.madests = new ArrayList(11);
        this.madests.add(NormalMADEstimator.STATIC);
        this.madests.add(GammaMADEstimator.STATIC);
        this.madests.add(ExponentialMADEstimator.STATIC);
        this.madests.add(ExponentialMedianEstimator.STATIC);
        this.madests.add(LaplaceMADEstimator.STATIC);
        this.madests.add(GumbelMADEstimator.STATIC);
        this.madests.add(CauchyMADEstimator.STATIC);
        this.madests.add(LogisticMADEstimator.STATIC);
        this.madests.add(LogLogisticMADEstimator.STATIC);
        this.madests.add(RayleighMADEstimator.STATIC);
        this.madests.add(UniformMADEstimator.STATIC);
        this.lmmests = new ArrayList(15);
        this.lmmests.add(NormalLMMEstimator.STATIC);
        this.lmmests.add(GammaLMMEstimator.STATIC);
        this.lmmests.add(ExponentialLMMEstimator.STATIC);
        this.lmmests.add(LaplaceLMMEstimator.STATIC);
        this.lmmests.add(GumbelLMMEstimator.STATIC);
        this.lmmests.add(LogisticLMMEstimator.STATIC);
        this.lmmests.add(GeneralizedLogisticAlternateLMMEstimator.STATIC);
        this.lmmests.add(LogNormalLMMEstimator.STATIC);
        this.lmmests.add(LogNormalBilkovaLMMEstimator.STATIC);
        this.lmmests.add(SkewGNormalLMMEstimator.STATIC);
        this.lmmests.add(GeneralizedExtremeValueLMMEstimator.STATIC);
        this.lmmests.add(GeneralizedParetoLMMEstimator.STATIC);
        this.lmmests.add(RayleighLMMEstimator.STATIC);
        this.lmmests.add(WeibullLMMEstimator.STATIC);
        this.lmmests.add(UniformLMMEstimator.STATIC);
        this.logmomests = new ArrayList(2);
        this.logmomests.add(LogNormalLogMOMEstimator.STATIC);
        this.logmomests.add(LogGammaLogMOMEstimator.STATIC);
        this.logmadests = new ArrayList(3);
        this.logmadests.add(LogNormalLogMADEstimator.STATIC);
        this.logmadests.add(LogGammaLogMADEstimator.STATIC);
        this.logmadests.add(WeibullLogMADEstimator.STATIC);
    }

    @Override
    public <A> Distribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        FiniteProgress finiteProgress;
        Object object;
        double d;
        Object object2;
        block50: {
            Object object3;
            double d2;
            double d3;
            double[] dArray;
            double[] dArray2;
            int n;
            block49: {
                double d4;
                Object object4;
                double[] dArray3;
                int n2 = 0;
                for (LMMDistributionEstimator<?> object62 : this.lmmests) {
                    n2 = Math.max(n2, object62.getNumMoments());
                }
                n = numberArrayAdapter.size(a);
                StatisticalMoments statisticalMoments = new StatisticalMoments();
                StatisticalMoments statisticalMoments2 = new StatisticalMoments();
                dArray2 = new double[n];
                dArray = new double[n];
                double[] dArray4 = new double[n];
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine("Computing statistical moments and L-Moments.");
                }
                for (int dArray32 = 0; dArray32 < n; ++dArray32) {
                    double arithmeticException;
                    dArray2[dArray32] = arithmeticException = numberArrayAdapter.getDouble(a, dArray32);
                    statisticalMoments.put(arithmeticException);
                }
                if (statisticalMoments.getMax() <= statisticalMoments.getMin()) {
                    LOG.warning("Constant distribution detected. Cannot fit.");
                    return new UniformDistribution(statisticalMoments.getMin() - 1.0, statisticalMoments.getMax() + 1.0);
                }
                Arrays.sort(dArray2);
                try {
                    dArray3 = n2 > 0 ? ProbabilityWeightedMoments.samLMR(dArray2, ArrayLikeUtil.DOUBLEARRAYADAPTER, n2) : null;
                }
                catch (ArithmeticException d32) {
                    dArray3 = null;
                }
                d3 = dArray2[0];
                double d5 = 0.5 * (dArray2[n >> 1] + dArray2[n + 1 >> 1]);
                d2 = dArray2[n - 1];
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine("Computing statistical moments in logspace.");
                }
                double d6 = Math.min(0.0, d3 - (d2 - d3) * 1.0E-10);
                for (int d9 = 0; d9 < n; ++d9) {
                    double d7 = dArray2[d9] - d6;
                    dArray4[d9] = d7 = d7 > 0.0 ? Math.log(d7) : Double.NEGATIVE_INFINITY;
                    if (Double.isInfinite(d7) || Double.isNaN(d7)) continue;
                    statisticalMoments2.put(d7);
                }
                double d8 = 0.5 * (dArray4[n >> 1] + dArray4[n + 1 >> 1]);
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine("Computing MADs.");
                }
                double d9 = this.computeMAD(dArray2, d5, dArray, n);
                double d10 = this.computeMAD(dArray4, d8, dArray, n);
                object2 = null;
                d = Double.POSITIVE_INFINITY;
                object = null;
                int n3 = this.momests.size() + this.madests.size() + this.lmmests.size() + this.logmomests.size() + this.logmadests.size() + 2;
                finiteProgress = LOG.isDebuggingFine() ? new FiniteProgress("Finding best matching distribution", n3, LOG) : null;
                for (MOMDistributionEstimator<?> arithmeticException : this.momests) {
                    block44: {
                        try {
                            object4 = arithmeticException.estimateFromStatisticalMoments(statisticalMoments);
                            d4 = this.testFit(dArray2, dArray, (Distribution)object4);
                            if (LOG.isDebuggingFine()) {
                                LOG.debugFine(arithmeticException.getClass().getSimpleName() + ": " + d4 + " " + object4.toString());
                            }
                            if (d4 < d) {
                                object2 = object4;
                                d = d4;
                                object = arithmeticException;
                            }
                        }
                        catch (ArithmeticException arithmeticException2) {
                            if (!LOG.isDebuggingFine()) break block44;
                            LOG.debugFine("Fitting distribution " + arithmeticException.getClass().getSimpleName() + " failed: " + arithmeticException2.getMessage());
                        }
                    }
                    LOG.incrementProcessed(finiteProgress);
                }
                for (MADDistributionEstimator mADDistributionEstimator : this.madests) {
                    block45: {
                        try {
                            object4 = mADDistributionEstimator.estimateFromMedianMAD(d5, d9);
                            d4 = this.testFit(dArray2, dArray, (Distribution)object4);
                            if (LOG.isDebuggingFine()) {
                                LOG.debugFine(mADDistributionEstimator.getClass().getSimpleName() + ": " + d4 + " " + object4.toString());
                            }
                            if (d4 < d) {
                                object2 = object4;
                                d = d4;
                                object = mADDistributionEstimator;
                            }
                        }
                        catch (ArithmeticException arithmeticException) {
                            if (!LOG.isDebuggingFine()) break block45;
                            LOG.debugFine("Fitting distribution " + mADDistributionEstimator.getClass().getSimpleName() + " failed: " + arithmeticException.getMessage());
                        }
                    }
                    LOG.incrementProcessed(finiteProgress);
                }
                for (LMMDistributionEstimator lMMDistributionEstimator : this.lmmests) {
                    block46: {
                        if (dArray3 != null) {
                            try {
                                object4 = lMMDistributionEstimator.estimateFromLMoments(dArray3);
                                d4 = this.testFit(dArray2, dArray, (Distribution)object4);
                                if (LOG.isDebuggingFine()) {
                                    LOG.debugFine(lMMDistributionEstimator.getClass().getSimpleName() + ": " + d4 + " " + object4.toString());
                                }
                                if (d4 < d) {
                                    object2 = object4;
                                    d = d4;
                                    object = lMMDistributionEstimator;
                                }
                            }
                            catch (ArithmeticException arithmeticException) {
                                if (!LOG.isDebuggingFine()) break block46;
                                LOG.debugFine("Fitting distribution " + lMMDistributionEstimator.getClass().getSimpleName() + " failed: " + arithmeticException.getMessage());
                            }
                        }
                    }
                    LOG.incrementProcessed(finiteProgress);
                }
                for (LogMOMDistributionEstimator logMOMDistributionEstimator : this.logmomests) {
                    block47: {
                        try {
                            object4 = logMOMDistributionEstimator.estimateFromLogStatisticalMoments(statisticalMoments2, d6);
                            d4 = this.testFit(dArray2, dArray, (Distribution)object4);
                            if (LOG.isDebuggingFine()) {
                                LOG.debugFine(logMOMDistributionEstimator.getClass().getSimpleName() + ": " + d4 + " " + object4.toString());
                            }
                            if (d4 < d) {
                                object2 = object4;
                                d = d4;
                                object = logMOMDistributionEstimator;
                            }
                        }
                        catch (ArithmeticException arithmeticException) {
                            if (!LOG.isDebuggingFine()) break block47;
                            LOG.debugFine("Fitting distribution " + logMOMDistributionEstimator.getClass().getSimpleName() + " failed: " + arithmeticException.getMessage());
                        }
                    }
                    LOG.incrementProcessed(finiteProgress);
                }
                for (LogMADDistributionEstimator logMADDistributionEstimator : this.logmadests) {
                    block48: {
                        try {
                            object4 = logMADDistributionEstimator.estimateFromLogMedianMAD(d8, d10, d6);
                            d4 = this.testFit(dArray2, dArray, (Distribution)object4);
                            if (LOG.isDebuggingFine()) {
                                LOG.debugFine(logMADDistributionEstimator.getClass().getSimpleName() + ": " + d4 + " " + object4.toString());
                            }
                            if (d4 < d) {
                                object2 = object4;
                                d = d4;
                                object = logMADDistributionEstimator;
                            }
                        }
                        catch (ArithmeticException arithmeticException) {
                            if (!LOG.isDebuggingFine()) break block48;
                            LOG.debugFine("Fitting distribution " + logMADDistributionEstimator.getClass().getSimpleName() + " failed: " + arithmeticException.getMessage());
                        }
                    }
                    LOG.incrementProcessed(finiteProgress);
                }
                object3 = UniformMinMaxEstimator.STATIC;
                try {
                    Distribution distribution = ((UniformMinMaxEstimator)object3).estimate(d3, d2);
                    double d11 = this.testFit(dArray2, dArray, distribution);
                    if (LOG.isDebuggingFine()) {
                        LOG.debugFine(object3.getClass().getSimpleName() + ": " + d11 + " " + distribution.toString());
                    }
                    if (d11 < d) {
                        object2 = distribution;
                        d = d11;
                        object = object3;
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    if (!LOG.isDebuggingFine()) break block49;
                    LOG.debugFine("Fitting distribution " + object3.getClass().getSimpleName() + " failed: " + arithmeticException.getMessage());
                }
            }
            LOG.incrementProcessed(finiteProgress);
            object3 = UniformEnhancedMinMaxEstimator.STATIC;
            try {
                UniformDistribution uniformDistribution = ((UniformEnhancedMinMaxEstimator)object3).estimate(d3, d2, n);
                double d12 = this.testFit(dArray2, dArray, uniformDistribution);
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine(object3.getClass().getSimpleName() + ": " + d12 + " " + uniformDistribution.toString());
                }
                if (d12 < d) {
                    object2 = uniformDistribution;
                    d = d12;
                    object = object3;
                }
            }
            catch (ArithmeticException arithmeticException) {
                if (!LOG.isDebuggingFine()) break block50;
                LOG.debugFine("Fitting distribution " + object3.getClass().getSimpleName() + " failed: " + arithmeticException.getMessage());
            }
        }
        LOG.incrementProcessed(finiteProgress);
        LOG.ensureCompleted(finiteProgress);
        if (LOG.isVeryVerbose()) {
            LOG.veryverbose("Best distribution fit: " + d + " " + object2.toString() + " via " + object);
        }
        return object2;
    }

    public double computeMAD(double[] dArray, double d, double[] dArray2, int n) {
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.abs(dArray[i] - d);
        }
        double d2 = QuickSelect.median(dArray2);
        if (!(d2 > 0.0)) {
            double d3 = Double.POSITIVE_INFINITY;
            for (int i = n >> 1; i < n; ++i) {
                if (!(dArray2[i] > 0.0) || !(dArray2[i] < d3)) continue;
                d3 = dArray2[i];
            }
            if (!Double.isInfinite(d3)) {
                d2 = d3;
            }
        }
        return d2;
    }

    private double testFit(double[] dArray, double[] dArray2, Distribution distribution) throws ArithmeticException {
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = distribution.cdf(dArray[i]);
            if (dArray2[i] > 1.0) {
                dArray2[i] = 1.0;
            }
            if (dArray2[i] < 0.0) {
                dArray2[i] = 0.0;
            }
            if (!Double.isNaN(dArray2[i])) continue;
            throw new ArithmeticException("Got NaN after fitting " + distribution.toString());
        }
        Arrays.sort(dArray2);
        return KolmogorovSmirnovTest.simpleTest(dArray2);
    }

    @Override
    public Class<? super Distribution> getDistributionClass() {
        return Distribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected BestFitEstimator makeInstance() {
            return STATIC;
        }
    }
}

