/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import java.util.Comparator;
import java.util.List;

public class QuickSelect {
    private static final int SMALL = 47;
    public static Adapter<double[]> DOUBLE_ADAPTER = new Adapter<double[]>(){

        @Override
        public void swap(double[] dArray, int n, int n2) {
            double d = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = d;
        }

        @Override
        public boolean compareGreater(double[] dArray, int n, int n2) {
            return dArray[n] > dArray[n2];
        }
    };
    public static Adapter<int[]> INTEGER_ADAPTER = new Adapter<int[]>(){

        @Override
        public void swap(int[] nArray, int n, int n2) {
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }

        @Override
        public boolean compareGreater(int[] nArray, int n, int n2) {
            return nArray[n] > nArray[n2];
        }
    };
    public static Adapter<float[]> FLOAT_ADAPTER = new Adapter<float[]>(){

        @Override
        public void swap(float[] fArray, int n, int n2) {
            float f = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f;
        }

        @Override
        public boolean compareGreater(float[] fArray, int n, int n2) {
            return fArray[n] > fArray[n2];
        }
    };
    public static Adapter<short[]> SHORT_ADAPTER = new Adapter<short[]>(){

        @Override
        public void swap(short[] sArray, int n, int n2) {
            short s = sArray[n];
            sArray[n] = sArray[n2];
            sArray[n2] = s;
        }

        @Override
        public boolean compareGreater(short[] sArray, int n, int n2) {
            return sArray[n] > sArray[n2];
        }
    };
    public static Adapter<long[]> LONG_ADAPTER = new Adapter<long[]>(){

        @Override
        public void swap(long[] lArray, int n, int n2) {
            long l = lArray[n];
            lArray[n] = lArray[n2];
            lArray[n2] = l;
        }

        @Override
        public boolean compareGreater(long[] lArray, int n, int n2) {
            return lArray[n] > lArray[n2];
        }
    };
    public static Adapter<byte[]> BYTE_ADAPTER = new Adapter<byte[]>(){

        @Override
        public void swap(byte[] byArray, int n, int n2) {
            byte by = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by;
        }

        @Override
        public boolean compareGreater(byte[] byArray, int n, int n2) {
            return byArray[n] > byArray[n2];
        }
    };
    public static Adapter<char[]> CHAR_ADAPTER = new Adapter<char[]>(){

        @Override
        public void swap(char[] cArray, int n, int n2) {
            char c = cArray[n];
            cArray[n] = cArray[n2];
            cArray[n2] = c;
        }

        @Override
        public boolean compareGreater(char[] cArray, int n, int n2) {
            return cArray[n] > cArray[n2];
        }
    };

    private static final int bestPivot(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n2) {
            return n2;
        }
        if (n > n6) {
            return n6;
        }
        if (n < n3) {
            return n3;
        }
        if (n > n5) {
            return n5;
        }
        return n4;
    }

    public static <T> void quickSelect(T t, Adapter<T> adapter, int n, int n2, int n3) {
        while (true) {
            if (n + 47 > n2) {
                QuickSelect.insertionSort(t, adapter, n, n2);
                return;
            }
            int n4 = n2 - n;
            int n5 = (n4 >> 3) + (n4 >> 6) + 1;
            int n6 = n + n2 >> 1;
            int n7 = n6 - n5;
            int n8 = n7 - n5;
            int n9 = n6 + n5;
            int n10 = n9 + n5;
            if (adapter.compareGreater(t, n8, n7)) {
                adapter.swap(t, n8, n7);
            }
            if (adapter.compareGreater(t, n8, n6)) {
                adapter.swap(t, n8, n6);
            }
            if (adapter.compareGreater(t, n7, n6)) {
                adapter.swap(t, n7, n6);
            }
            if (adapter.compareGreater(t, n9, n10)) {
                adapter.swap(t, n9, n10);
            }
            if (adapter.compareGreater(t, n8, n9)) {
                adapter.swap(t, n8, n9);
            }
            if (adapter.compareGreater(t, n6, n9)) {
                adapter.swap(t, n6, n9);
            }
            if (adapter.compareGreater(t, n7, n10)) {
                adapter.swap(t, n7, n10);
            }
            if (adapter.compareGreater(t, n7, n6)) {
                adapter.swap(t, n7, n6);
            }
            if (adapter.compareGreater(t, n9, n10)) {
                adapter.swap(t, n9, n10);
            }
            int n11 = QuickSelect.bestPivot(n3, n8, n7, n6, n9, n10);
            adapter.swap(t, n11, n2 - 1);
            int n12 = n;
            int n13 = n2 - 2;
            while (true) {
                if (n12 <= n13 && adapter.compareGreater(t, n2 - 1, n12)) {
                    ++n12;
                    continue;
                }
                while (n13 >= n12 && !adapter.compareGreater(t, n2 - 1, n13)) {
                    --n13;
                }
                if (n12 >= n13) break;
                adapter.swap(t, n12, n13);
            }
            adapter.swap(t, n12, n2 - 1);
            if (n3 < n12) {
                n2 = n12;
                continue;
            }
            if (n3 <= n12) break;
            n = n12 + 1;
        }
    }

    private static <T> void insertionSort(T t, Adapter<T> adapter, int n, int n2) {
        for (int i = n + 1; i < n2; ++i) {
            for (int j = i; j > n && adapter.compareGreater(t, j - 1, j); --j) {
                adapter.swap(t, j, j - 1);
            }
        }
    }

    public static double quickSelect(double[] dArray, int n) {
        QuickSelect.quickSelect(dArray, 0, dArray.length, n);
        return dArray[n];
    }

    public static double median(double[] dArray) {
        return QuickSelect.median(dArray, 0, dArray.length);
    }

    public static double median(double[] dArray, int n, int n2) {
        int n3 = n2 - n;
        assert (n3 > 0);
        int n4 = n + (n3 - 1 >> 1);
        QuickSelect.quickSelect(dArray, n, n2, n4);
        if (n3 % 2 == 1) {
            return dArray[n4];
        }
        QuickSelect.quickSelect(dArray, n4 + 1, n2, n4 + 1);
        return dArray[n4] + 0.5 * (dArray[n4 + 1] - dArray[n4]);
    }

    public static double quantile(double[] dArray, double d) {
        return QuickSelect.quantile(dArray, 0, dArray.length, d);
    }

    public static double quantile(double[] dArray, int n, int n2, double d) {
        int n3 = n2 - n;
        assert (n3 > 0) : "Quantile on empty set?";
        double d2 = (double)n + (double)(n3 - 1) * d;
        int n4 = (int)Math.floor(d2);
        double d3 = d2 - (double)n4;
        QuickSelect.quickSelect(dArray, n, n2, n4);
        if (d3 <= Double.MIN_NORMAL) {
            return dArray[n4];
        }
        QuickSelect.quickSelect(dArray, n4 + 1, n2, n4 + 1);
        double d4 = dArray[n4] + (dArray[n4 + 1] - dArray[n4]) * d3;
        return d4;
    }

    public static double quickSelect(double[] dArray, int n, int n2, int n3) {
        while (true) {
            if (n + 47 > n2) {
                QuickSelect.insertionSort(dArray, n, n2);
                return dArray[n3];
            }
            int n4 = n2 - n;
            int n5 = (n4 >> 3) + (n4 >> 6) + 1;
            int n6 = n + n2 >> 1;
            int n7 = n6 - n5;
            int n8 = n7 - n5;
            int n9 = n6 + n5;
            int n10 = n9 + n5;
            if (dArray[n8] > dArray[n7]) {
                QuickSelect.swap(dArray, n8, n7);
            }
            if (dArray[n8] > dArray[n6]) {
                QuickSelect.swap(dArray, n8, n6);
            }
            if (dArray[n7] > dArray[n6]) {
                QuickSelect.swap(dArray, n7, n6);
            }
            if (dArray[n9] > dArray[n10]) {
                QuickSelect.swap(dArray, n9, n10);
            }
            if (dArray[n8] > dArray[n9]) {
                QuickSelect.swap(dArray, n8, n9);
            }
            if (dArray[n6] > dArray[n9]) {
                QuickSelect.swap(dArray, n6, n9);
            }
            if (dArray[n7] > dArray[n10]) {
                QuickSelect.swap(dArray, n7, n10);
            }
            if (dArray[n7] > dArray[n6]) {
                QuickSelect.swap(dArray, n7, n6);
            }
            if (dArray[n9] > dArray[n10]) {
                QuickSelect.swap(dArray, n9, n10);
            }
            int n11 = QuickSelect.bestPivot(n3, n8, n7, n6, n9, n10);
            double d = dArray[n11];
            QuickSelect.swap(dArray, n11, n2 - 1);
            int n12 = n;
            int n13 = n2 - 2;
            while (true) {
                if (n12 <= n13 && dArray[n12] <= d) {
                    ++n12;
                    continue;
                }
                while (n13 >= n12 && dArray[n13] >= d) {
                    --n13;
                }
                if (n12 >= n13) break;
                QuickSelect.swap(dArray, n12, n13);
                ++n12;
                --n13;
            }
            QuickSelect.swap(dArray, n12, n2 - 1);
            while (n3 < n12 && dArray[n12 - 1] == d) {
                --n12;
            }
            while (n3 > n12 && dArray[n12 + 1] == d) {
                ++n12;
            }
            if (n3 < n12) {
                n2 = n12;
                continue;
            }
            if (n3 <= n12) break;
            n = n12 + 1;
        }
        return dArray[n3];
    }

    private static void insertionSort(double[] dArray, int n, int n2) {
        for (int i = n + 1; i < n2; ++i) {
            for (int j = i; j > n && dArray[j - 1] > dArray[j]; --j) {
                QuickSelect.swap(dArray, j, j - 1);
            }
        }
    }

    private static final void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    public static <T extends Comparable<? super T>> T quickSelect(T[] TArray, int n) {
        QuickSelect.quickSelect(TArray, (int)0, (int)TArray.length, (int)n);
        return TArray[n];
    }

    public static <T extends Comparable<? super T>> T median(T[] TArray) {
        return (T)QuickSelect.median(TArray, (int)0, (int)TArray.length);
    }

    public static <T extends Comparable<? super T>> T median(T[] TArray, int n, int n2) {
        int n3 = n2 - n;
        assert (n3 > 0);
        int n4 = n + (n3 - 1 >> 1);
        QuickSelect.quickSelect(TArray, (int)n, (int)n2, (int)n4);
        return TArray[n4];
    }

    public static <T extends Comparable<? super T>> T quantile(T[] TArray, double d) {
        return (T)QuickSelect.quantile(TArray, (int)0, (int)TArray.length, (double)d);
    }

    public static <T extends Comparable<? super T>> T quantile(T[] TArray, int n, int n2, double d) {
        int n3 = n2 - n;
        assert (n3 > 0) : "Quantile on empty set?";
        double d2 = (double)n + (double)(n3 - 1) * d;
        int n4 = (int)Math.floor(d2);
        QuickSelect.quickSelect(TArray, (int)n, (int)n2, (int)n4);
        return TArray[n4];
    }

    public static <T extends Comparable<? super T>> void quickSelect(T[] TArray, int n, int n2, int n3) {
        while (true) {
            if (n + 47 > n2) {
                QuickSelect.insertionSort(TArray, (int)n, (int)n2);
                return;
            }
            int n4 = n2 - n;
            int n5 = (n4 >> 3) + (n4 >> 6) + 1;
            int n6 = n + n2 >> 1;
            int n7 = n6 - n5;
            int n8 = n7 - n5;
            int n9 = n6 + n5;
            int n10 = n9 + n5;
            if (TArray[n8].compareTo(TArray[n7]) > 0) {
                QuickSelect.swap(TArray, (int)n8, (int)n7);
            }
            if (TArray[n8].compareTo(TArray[n6]) > 0) {
                QuickSelect.swap(TArray, (int)n8, (int)n6);
            }
            if (TArray[n7].compareTo(TArray[n6]) > 0) {
                QuickSelect.swap(TArray, (int)n7, (int)n6);
            }
            if (TArray[n9].compareTo(TArray[n10]) > 0) {
                QuickSelect.swap(TArray, (int)n9, (int)n10);
            }
            if (TArray[n8].compareTo(TArray[n9]) > 0) {
                QuickSelect.swap(TArray, (int)n8, (int)n9);
            }
            if (TArray[n6].compareTo(TArray[n9]) > 0) {
                QuickSelect.swap(TArray, (int)n6, (int)n9);
            }
            if (TArray[n7].compareTo(TArray[n10]) > 0) {
                QuickSelect.swap(TArray, (int)n7, (int)n10);
            }
            if (TArray[n7].compareTo(TArray[n6]) > 0) {
                QuickSelect.swap(TArray, (int)n7, (int)n6);
            }
            if (TArray[n9].compareTo(TArray[n10]) > 0) {
                QuickSelect.swap(TArray, (int)n9, (int)n10);
            }
            int n11 = QuickSelect.bestPivot(n3, n8, n7, n6, n9, n10);
            T t = TArray[n11];
            QuickSelect.swap(TArray, (int)n11, (int)(n2 - 1));
            int n12 = n;
            int n13 = n2 - 2;
            while (true) {
                if (n12 <= n13 && TArray[n12].compareTo(t) <= 0) {
                    ++n12;
                    continue;
                }
                while (n13 >= n12 && TArray[n13].compareTo(t) >= 0) {
                    --n13;
                }
                if (n12 >= n13) break;
                QuickSelect.swap(TArray, (int)n12, (int)n13);
            }
            QuickSelect.swap(TArray, (int)n12, (int)(n2 - 1));
            while (n3 < n12 && TArray[n12 - 1].compareTo(t) == 0) {
                --n12;
            }
            while (n3 > n12 && TArray[n12 + 1].compareTo(t) == 0) {
                ++n12;
            }
            if (n3 < n12) {
                n2 = n12;
                continue;
            }
            if (n3 <= n12) break;
            n = n12 + 1;
        }
    }

    private static <T extends Comparable<? super T>> void insertionSort(T[] TArray, int n, int n2) {
        for (int i = n + 1; i < n2; ++i) {
            for (int j = i; j > n && TArray[j - 1].compareTo(TArray[j]) > 0; --j) {
                QuickSelect.swap(TArray, (int)j, (int)(j - 1));
            }
        }
    }

    private static final <T extends Comparable<? super T>> void swap(T[] TArray, int n, int n2) {
        T t = TArray[n];
        TArray[n] = TArray[n2];
        TArray[n2] = t;
    }

    public static <T extends Comparable<? super T>> T quickSelect(List<? extends T> list, int n) {
        QuickSelect.quickSelect(list, 0, list.size(), n);
        return (T)((Comparable)list.get(n));
    }

    public static <T extends Comparable<? super T>> T median(List<? extends T> list) {
        return QuickSelect.median(list, 0, list.size());
    }

    public static <T extends Comparable<? super T>> T median(List<? extends T> list, int n, int n2) {
        int n3 = n2 - n;
        assert (n3 > 0);
        int n4 = n + (n3 - 1 >> 1);
        QuickSelect.quickSelect(list, n, n2, n4);
        return (T)((Comparable)list.get(n4));
    }

    public static <T extends Comparable<? super T>> T quantile(List<? extends T> list, double d) {
        return QuickSelect.quantile(list, 0, list.size(), d);
    }

    public static <T extends Comparable<? super T>> T quantile(List<? extends T> list, int n, int n2, double d) {
        int n3 = n2 - n;
        assert (n3 > 0) : "Quantile on empty set?";
        double d2 = (double)n + (double)(n3 - 1) * d;
        int n4 = (int)Math.floor(d2);
        QuickSelect.quickSelect(list, n, n2, n4);
        return (T)((Comparable)list.get(n4));
    }

    public static <T extends Comparable<? super T>> void quickSelect(List<? extends T> list, int n, int n2, int n3) {
        while (true) {
            if (n + 47 > n2) {
                QuickSelect.insertionSort(list, n, n2);
                return;
            }
            int n4 = n2 - n;
            int n5 = (n4 >> 3) + (n4 >> 6) + 1;
            int n6 = n + n2 >> 1;
            int n7 = n6 - n5;
            int n8 = n7 - n5;
            int n9 = n6 + n5;
            int n10 = n9 + n5;
            if (((Comparable)list.get(n8)).compareTo(list.get(n7)) > 0) {
                QuickSelect.swap(list, n8, n7);
            }
            if (((Comparable)list.get(n8)).compareTo(list.get(n6)) > 0) {
                QuickSelect.swap(list, n8, n6);
            }
            if (((Comparable)list.get(n7)).compareTo(list.get(n6)) > 0) {
                QuickSelect.swap(list, n7, n6);
            }
            if (((Comparable)list.get(n9)).compareTo(list.get(n10)) > 0) {
                QuickSelect.swap(list, n9, n10);
            }
            if (((Comparable)list.get(n8)).compareTo(list.get(n9)) > 0) {
                QuickSelect.swap(list, n8, n9);
            }
            if (((Comparable)list.get(n6)).compareTo(list.get(n9)) > 0) {
                QuickSelect.swap(list, n6, n9);
            }
            if (((Comparable)list.get(n7)).compareTo(list.get(n10)) > 0) {
                QuickSelect.swap(list, n7, n10);
            }
            if (((Comparable)list.get(n7)).compareTo(list.get(n6)) > 0) {
                QuickSelect.swap(list, n7, n6);
            }
            if (((Comparable)list.get(n9)).compareTo(list.get(n10)) > 0) {
                QuickSelect.swap(list, n9, n10);
            }
            int n11 = QuickSelect.bestPivot(n3, n8, n7, n6, n9, n10);
            Comparable comparable = (Comparable)list.get(n11);
            QuickSelect.swap(list, n11, n2 - 1);
            int n12 = n;
            int n13 = n2 - 2;
            while (true) {
                if (n12 <= n13 && ((Comparable)list.get(n12)).compareTo(comparable) <= 0) {
                    ++n12;
                    continue;
                }
                while (n13 >= n12 && ((Comparable)list.get(n13)).compareTo(comparable) >= 0) {
                    --n13;
                }
                if (n12 >= n13) break;
                QuickSelect.swap(list, n12, n13);
            }
            QuickSelect.swap(list, n12, n2 - 1);
            while (n3 < n12 && ((Comparable)list.get(n12 - 1)).compareTo(comparable) == 0) {
                --n12;
            }
            while (n3 > n12 && ((Comparable)list.get(n12 + 1)).compareTo(comparable) == 0) {
                ++n12;
            }
            if (n3 < n12) {
                n2 = n12;
                continue;
            }
            if (n3 <= n12) break;
            n = n12 + 1;
        }
    }

    private static <T extends Comparable<? super T>> void insertionSort(List<T> list, int n, int n2) {
        for (int i = n + 1; i < n2; ++i) {
            for (int j = i; j > n && ((Comparable)list.get(j - 1)).compareTo(list.get(j)) > 0; --j) {
                QuickSelect.swap(list, j, j - 1);
            }
        }
    }

    private static final <T> void swap(List<T> list, int n, int n2) {
        list.set(n2, list.set(n, list.get(n2)));
    }

    public static <T> T quickSelect(List<? extends T> list, Comparator<? super T> comparator, int n) {
        QuickSelect.quickSelect(list, comparator, 0, list.size(), n);
        return list.get(n);
    }

    public static <T> T median(List<? extends T> list, Comparator<? super T> comparator) {
        return QuickSelect.median(list, comparator, 0, list.size());
    }

    public static <T> T median(List<? extends T> list, Comparator<? super T> comparator, int n, int n2) {
        int n3 = n2 - n;
        assert (n3 > 0);
        int n4 = n + (n3 - 1 >> 1);
        QuickSelect.quickSelect(list, comparator, n, n2, n4);
        return list.get(n4);
    }

    public static <T> T quantile(List<? extends T> list, Comparator<? super T> comparator, double d) {
        return QuickSelect.quantile(list, comparator, 0, list.size(), d);
    }

    public static <T> T quantile(List<? extends T> list, Comparator<? super T> comparator, int n, int n2, double d) {
        int n3 = n2 - n;
        assert (n3 > 0) : "Quantile on empty set?";
        double d2 = (double)n + (double)(n3 - 1) * d;
        int n4 = (int)Math.floor(d2);
        QuickSelect.quickSelect(list, comparator, n, n2, n4);
        return list.get(n4);
    }

    public static <T> void quickSelect(List<? extends T> list, Comparator<? super T> comparator, int n, int n2, int n3) {
        while (true) {
            if (n + 47 > n2) {
                QuickSelect.insertionSort(list, comparator, n, n2);
                return;
            }
            int n4 = n2 - n;
            int n5 = (n4 >> 3) + (n4 >> 6) + 1;
            int n6 = n + n2 >> 1;
            int n7 = n6 - n5;
            int n8 = n7 - n5;
            int n9 = n6 + n5;
            int n10 = n9 + n5;
            if (comparator.compare(list.get(n8), list.get(n7)) > 0) {
                QuickSelect.swap(list, n8, n7);
            }
            if (comparator.compare(list.get(n8), list.get(n6)) > 0) {
                QuickSelect.swap(list, n8, n6);
            }
            if (comparator.compare(list.get(n7), list.get(n6)) > 0) {
                QuickSelect.swap(list, n7, n6);
            }
            if (comparator.compare(list.get(n9), list.get(n10)) > 0) {
                QuickSelect.swap(list, n9, n10);
            }
            if (comparator.compare(list.get(n8), list.get(n9)) > 0) {
                QuickSelect.swap(list, n8, n9);
            }
            if (comparator.compare(list.get(n6), list.get(n9)) > 0) {
                QuickSelect.swap(list, n6, n9);
            }
            if (comparator.compare(list.get(n7), list.get(n10)) > 0) {
                QuickSelect.swap(list, n7, n10);
            }
            if (comparator.compare(list.get(n7), list.get(n6)) > 0) {
                QuickSelect.swap(list, n7, n6);
            }
            if (comparator.compare(list.get(n9), list.get(n10)) > 0) {
                QuickSelect.swap(list, n9, n10);
            }
            int n11 = QuickSelect.bestPivot(n3, n8, n7, n6, n9, n10);
            T t = list.get(n11);
            QuickSelect.swap(list, n11, n2 - 1);
            int n12 = n;
            int n13 = n2 - 2;
            while (true) {
                if (n12 <= n13 && comparator.compare(list.get(n12), t) <= 0) {
                    ++n12;
                    continue;
                }
                while (n13 >= n12 && comparator.compare(list.get(n13), t) >= 0) {
                    --n13;
                }
                if (n12 >= n13) break;
                QuickSelect.swap(list, n12, n13);
            }
            QuickSelect.swap(list, n12, n2 - 1);
            while (n3 < n12 && comparator.compare(list.get(n12 - 1), t) == 0) {
                --n12;
            }
            while (n3 > n12 && comparator.compare(list.get(n12 + 1), t) == 0) {
                ++n12;
            }
            if (n3 < n12) {
                n2 = n12;
                continue;
            }
            if (n3 <= n12) break;
            n = n12 + 1;
        }
    }

    private static <T> void insertionSort(List<T> list, Comparator<? super T> comparator, int n, int n2) {
        for (int i = n + 1; i < n2; ++i) {
            for (int j = i; j > n && comparator.compare(list.get(j - 1), list.get(j)) > 0; --j) {
                QuickSelect.swap(list, j, j - 1);
            }
        }
    }

    public static void quickSelect(ArrayModifiableDBIDs arrayModifiableDBIDs, Comparator<? super DBIDRef> comparator, int n) {
        QuickSelect.quickSelect(arrayModifiableDBIDs, comparator, 0, arrayModifiableDBIDs.size(), n);
    }

    public static int median(ArrayModifiableDBIDs arrayModifiableDBIDs, Comparator<? super DBIDRef> comparator) {
        return QuickSelect.median(arrayModifiableDBIDs, comparator, 0, arrayModifiableDBIDs.size());
    }

    public static int median(ArrayModifiableDBIDs arrayModifiableDBIDs, Comparator<? super DBIDRef> comparator, int n, int n2) {
        int n3 = n2 - n;
        assert (n3 > 0);
        int n4 = n + (n3 - 1 >> 1);
        QuickSelect.quickSelect(arrayModifiableDBIDs, comparator, n, n2, n4);
        return n4;
    }

    public static int quantile(ArrayModifiableDBIDs arrayModifiableDBIDs, Comparator<? super DBIDRef> comparator, double d) {
        return QuickSelect.quantile(arrayModifiableDBIDs, comparator, 0, arrayModifiableDBIDs.size(), d);
    }

    public static int quantile(ArrayModifiableDBIDs arrayModifiableDBIDs, Comparator<? super DBIDRef> comparator, int n, int n2, double d) {
        int n3 = n2 - n;
        assert (n3 > 0) : "Quantile on empty set?";
        double d2 = (double)n + (double)(n3 - 1) * d;
        int n4 = (int)Math.floor(d2);
        QuickSelect.quickSelect(arrayModifiableDBIDs, comparator, n, n2, n4);
        return n4;
    }

    public static void quickSelect(ArrayModifiableDBIDs arrayModifiableDBIDs, Comparator<? super DBIDRef> comparator, int n, int n2, int n3) {
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        DBIDArrayMIter dBIDArrayMIter2 = arrayModifiableDBIDs.iter();
        DBIDArrayMIter dBIDArrayMIter3 = arrayModifiableDBIDs.iter();
        while (true) {
            if (n + 47 > n2) {
                QuickSelect.insertionSort(arrayModifiableDBIDs, comparator, n, n2, dBIDArrayMIter, dBIDArrayMIter2);
                return;
            }
            int n4 = n2 - n;
            int n5 = (n4 >> 3) + (n4 >> 6) + 1;
            int n6 = n + n2 >> 1;
            int n7 = n6 - n5;
            int n8 = n7 - n5;
            int n9 = n6 + n5;
            int n10 = n9 + n5;
            if (comparator.compare(dBIDArrayMIter.seek(n8), dBIDArrayMIter2.seek(n7)) > 0) {
                arrayModifiableDBIDs.swap(n8, n7);
            }
            if (comparator.compare(dBIDArrayMIter.seek(n8), dBIDArrayMIter2.seek(n6)) > 0) {
                arrayModifiableDBIDs.swap(n8, n6);
            }
            if (comparator.compare(dBIDArrayMIter.seek(n7), dBIDArrayMIter2.seek(n6)) > 0) {
                arrayModifiableDBIDs.swap(n7, n6);
            }
            if (comparator.compare(dBIDArrayMIter.seek(n9), dBIDArrayMIter2.seek(n10)) > 0) {
                arrayModifiableDBIDs.swap(n9, n10);
            }
            if (comparator.compare(dBIDArrayMIter.seek(n8), dBIDArrayMIter2.seek(n9)) > 0) {
                arrayModifiableDBIDs.swap(n8, n9);
            }
            if (comparator.compare(dBIDArrayMIter.seek(n6), dBIDArrayMIter2.seek(n9)) > 0) {
                arrayModifiableDBIDs.swap(n6, n9);
            }
            if (comparator.compare(dBIDArrayMIter.seek(n7), dBIDArrayMIter2.seek(n10)) > 0) {
                arrayModifiableDBIDs.swap(n7, n10);
            }
            if (comparator.compare(dBIDArrayMIter.seek(n7), dBIDArrayMIter2.seek(n6)) > 0) {
                arrayModifiableDBIDs.swap(n7, n6);
            }
            if (comparator.compare(dBIDArrayMIter.seek(n9), dBIDArrayMIter2.seek(n10)) > 0) {
                arrayModifiableDBIDs.swap(n9, n10);
            }
            int n11 = QuickSelect.bestPivot(n3, n8, n7, n6, n9, n10);
            arrayModifiableDBIDs.swap(n11, n2 - 1);
            dBIDArrayMIter3.seek(n2 - 1);
            int n12 = n;
            int n13 = n2 - 2;
            while (true) {
                if (n12 <= n13 && comparator.compare(dBIDArrayMIter.seek(n12), dBIDArrayMIter3) <= 0) {
                    ++n12;
                    continue;
                }
                while (n13 >= n12 && comparator.compare(dBIDArrayMIter2.seek(n13), dBIDArrayMIter3) >= 0) {
                    --n13;
                }
                if (n12 >= n13) break;
                arrayModifiableDBIDs.swap(n12, n13);
            }
            arrayModifiableDBIDs.swap(n12, n2 - 1);
            dBIDArrayMIter3.seek(n12);
            while (n3 < n12 && comparator.compare(dBIDArrayMIter.seek(n12 - 1), dBIDArrayMIter3) == 0) {
                --n12;
            }
            while (n3 > n12 && comparator.compare(dBIDArrayMIter.seek(n12 + 1), dBIDArrayMIter3) == 0) {
                ++n12;
            }
            if (n3 < n12) {
                n2 = n12;
                continue;
            }
            if (n3 <= n12) break;
            n = n12 + 1;
        }
    }

    private static void insertionSort(ArrayModifiableDBIDs arrayModifiableDBIDs, Comparator<? super DBIDRef> comparator, int n, int n2, DBIDArrayIter dBIDArrayIter, DBIDArrayIter dBIDArrayIter2) {
        for (int i = n + 1; i < n2; ++i) {
            for (int j = i; j > n && comparator.compare(dBIDArrayIter.seek(j - 1), dBIDArrayIter2.seek(j)) > 0; --j) {
                arrayModifiableDBIDs.swap(j, j - 1);
            }
        }
    }

    public static void quickSelect(ModifiableDoubleDBIDList modifiableDoubleDBIDList, int n) {
        QuickSelect.quickSelect(modifiableDoubleDBIDList, 0, modifiableDoubleDBIDList.size(), n);
    }

    public static int median(ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        return QuickSelect.median(modifiableDoubleDBIDList, 0, modifiableDoubleDBIDList.size());
    }

    public static int median(ModifiableDoubleDBIDList modifiableDoubleDBIDList, int n, int n2) {
        int n3 = n2 - n;
        assert (n3 > 0);
        int n4 = n + (n3 - 1 >> 1);
        QuickSelect.quickSelect(modifiableDoubleDBIDList, n, n2, n4);
        return n4;
    }

    public static int quantile(ModifiableDoubleDBIDList modifiableDoubleDBIDList, double d) {
        return QuickSelect.quantile(modifiableDoubleDBIDList, 0, modifiableDoubleDBIDList.size(), d);
    }

    public static int quantile(ModifiableDoubleDBIDList modifiableDoubleDBIDList, int n, int n2, double d) {
        int n3 = n2 - n;
        assert (n3 > 0) : "Quantile on empty set?";
        double d2 = (double)n + (double)(n3 - 1) * d;
        int n4 = (int)Math.floor(d2);
        QuickSelect.quickSelect(modifiableDoubleDBIDList, n, n2, n4);
        return n4;
    }

    public static void quickSelect(ModifiableDoubleDBIDList modifiableDoubleDBIDList, int n, int n2, int n3) {
        DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
        DoubleDBIDListMIter doubleDBIDListMIter2 = modifiableDoubleDBIDList.iter();
        DoubleDBIDListMIter doubleDBIDListMIter3 = modifiableDoubleDBIDList.iter();
        while (true) {
            if (n + 47 > n2) {
                QuickSelect.insertionSort(modifiableDoubleDBIDList, n, n2, doubleDBIDListMIter, doubleDBIDListMIter2);
                return;
            }
            int n4 = n2 - n;
            int n5 = (n4 >> 3) + (n4 >> 6) + 1;
            int n6 = n + n2 >> 1;
            int n7 = n6 - n5;
            int n8 = n7 - n5;
            int n9 = n6 + n5;
            int n10 = n9 + n5;
            if (doubleDBIDListMIter.seek(n8).doubleValue() > doubleDBIDListMIter2.seek(n7).doubleValue()) {
                modifiableDoubleDBIDList.swap(n8, n7);
            }
            if (doubleDBIDListMIter.seek(n8).doubleValue() > doubleDBIDListMIter2.seek(n6).doubleValue()) {
                modifiableDoubleDBIDList.swap(n8, n6);
            }
            if (doubleDBIDListMIter.seek(n7).doubleValue() > doubleDBIDListMIter2.seek(n6).doubleValue()) {
                modifiableDoubleDBIDList.swap(n7, n6);
            }
            if (doubleDBIDListMIter.seek(n9).doubleValue() > doubleDBIDListMIter2.seek(n10).doubleValue()) {
                modifiableDoubleDBIDList.swap(n9, n10);
            }
            if (doubleDBIDListMIter.seek(n8).doubleValue() > doubleDBIDListMIter2.seek(n9).doubleValue()) {
                modifiableDoubleDBIDList.swap(n8, n9);
            }
            if (doubleDBIDListMIter.seek(n6).doubleValue() > doubleDBIDListMIter2.seek(n9).doubleValue()) {
                modifiableDoubleDBIDList.swap(n6, n9);
            }
            if (doubleDBIDListMIter.seek(n7).doubleValue() > doubleDBIDListMIter2.seek(n10).doubleValue()) {
                modifiableDoubleDBIDList.swap(n7, n10);
            }
            if (doubleDBIDListMIter.seek(n7).doubleValue() > doubleDBIDListMIter2.seek(n6).doubleValue()) {
                modifiableDoubleDBIDList.swap(n7, n6);
            }
            if (doubleDBIDListMIter.seek(n9).doubleValue() > doubleDBIDListMIter2.seek(n10).doubleValue()) {
                modifiableDoubleDBIDList.swap(n9, n10);
            }
            int n11 = QuickSelect.bestPivot(n3, n8, n7, n6, n9, n10);
            modifiableDoubleDBIDList.swap(n11, n2 - 1);
            double d = doubleDBIDListMIter3.seek(n2 - 1).doubleValue();
            int n12 = n;
            int n13 = n2 - 2;
            while (true) {
                if (n12 <= n13 && doubleDBIDListMIter.seek(n12).doubleValue() <= d) {
                    ++n12;
                    continue;
                }
                while (n13 >= n12 && doubleDBIDListMIter2.seek(n13).doubleValue() >= d) {
                    --n13;
                }
                if (n12 >= n13) break;
                modifiableDoubleDBIDList.swap(n12, n13);
            }
            modifiableDoubleDBIDList.swap(n12, n2 - 1);
            doubleDBIDListMIter3.seek(n12);
            while (n3 < n12 && doubleDBIDListMIter.seek(n12 - 1).doubleValue() == d) {
                --n12;
            }
            while (n3 > n12 && doubleDBIDListMIter.seek(n12 + 1).doubleValue() == d) {
                ++n12;
            }
            if (n3 < n12) {
                n2 = n12;
                continue;
            }
            if (n3 <= n12) break;
            n = n12 + 1;
        }
    }

    private static void insertionSort(ModifiableDoubleDBIDList modifiableDoubleDBIDList, int n, int n2, DoubleDBIDListIter doubleDBIDListIter, DoubleDBIDListIter doubleDBIDListIter2) {
        for (int i = n + 1; i < n2; ++i) {
            for (int j = i; j > n && !(doubleDBIDListIter.seek(j - 1).doubleValue() < doubleDBIDListIter2.seek(j).doubleValue()); --j) {
                modifiableDoubleDBIDList.swap(j, j - 1);
            }
        }
    }

    public static interface Adapter<T> {
        public void swap(T var1, int var2, int var3);

        public boolean compareGreater(T var1, int var2, int var3);
    }
}

