/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike;

import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import java.util.Arrays;

public class DoubleArray
implements NumberArrayAdapter<Double, DoubleArray> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFFA;
    private static final int LAST_GROW_SIZE = 0x55555551;
    public double[] data;
    public int size;

    public DoubleArray() {
        this(11);
    }

    public DoubleArray(int n) {
        if (n < 0) {
            n = 11;
        } else if (n > 0x7FFFFFFA) {
            n = 0x7FFFFFFA;
        }
        this.data = new double[n];
        this.size = 0;
    }

    public DoubleArray(DoubleArray doubleArray) {
        this.data = Arrays.copyOf(doubleArray.data, doubleArray.size);
        this.size = doubleArray.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void add(double d) {
        if (this.data.length == this.size) {
            this.grow();
        }
        this.data[this.size++] = d;
    }

    private void grow() throws OutOfMemoryError {
        if (this.data.length == 0x7FFFFFFA) {
            throw new OutOfMemoryError("Array size has reached the Java maximum.");
        }
        int n = this.size >= 0x55555551 ? 0x7FFFFFFA : this.size + (this.size >> 1) + 1;
        this.data = Arrays.copyOf(this.data, n);
    }

    public double get(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public void set(int n, double d) {
        if (n < 0 || n > this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == this.size) {
            this.add(d);
            return;
        }
        this.data[n] = d;
    }

    public void remove(int n, int n2) {
        int n3 = n + n2;
        if (n3 > this.size) {
            throw new ArrayIndexOutOfBoundsException(this.size);
        }
        System.arraycopy(this.data, n3, this.data, n, this.size - n3);
        this.size -= n2;
    }

    public void insert(int n, double d) {
        if (this.size == this.data.length) {
            if (this.data.length == 0x7FFFFFFA) {
                throw new OutOfMemoryError("Array size has reached the Java maximum.");
            }
            int n2 = this.size >= 0x55555551 ? 0x7FFFFFFA : this.size + (this.size >> 1) + 1;
            double[] dArray = this.data;
            this.data = new double[n2];
            System.arraycopy(dArray, 0, this.data, 0, n);
            System.arraycopy(dArray, n, this.data, n + 1, this.size - n);
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.data[n] = d;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    @Override
    public int size(DoubleArray doubleArray) {
        return doubleArray.size;
    }

    @Override
    public Double get(DoubleArray doubleArray, int n) throws IndexOutOfBoundsException {
        return doubleArray.data[n];
    }

    @Override
    public double getDouble(DoubleArray doubleArray, int n) throws IndexOutOfBoundsException {
        return doubleArray.data[n];
    }

    @Override
    public float getFloat(DoubleArray doubleArray, int n) throws IndexOutOfBoundsException {
        return (float)doubleArray.data[n];
    }

    @Override
    public int getInteger(DoubleArray doubleArray, int n) throws IndexOutOfBoundsException {
        return (int)doubleArray.data[n];
    }

    @Override
    public short getShort(DoubleArray doubleArray, int n) throws IndexOutOfBoundsException {
        return (short)doubleArray.data[n];
    }

    @Override
    public long getLong(DoubleArray doubleArray, int n) throws IndexOutOfBoundsException {
        return (long)doubleArray.data[n];
    }

    @Override
    public byte getByte(DoubleArray doubleArray, int n) throws IndexOutOfBoundsException {
        return (byte)doubleArray.data[n];
    }

    public double[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }
}

