/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Comparator;

public class UpdatableHeap<O>
extends Heap<O> {
    protected static final int NO_VALUE = Integer.MIN_VALUE;
    protected static final int IN_TIES = -1;
    protected final TObjectIntMap<Object> index = new TObjectIntHashMap(100, 0.5f, Integer.MIN_VALUE);

    public UpdatableHeap() {
    }

    public UpdatableHeap(int n) {
        super(n);
    }

    public UpdatableHeap(Comparator<? super O> comparator) {
        super(comparator);
    }

    public UpdatableHeap(int n, Comparator<? super O> comparator) {
        super(n, comparator);
    }

    @Override
    public void clear() {
        super.clear();
        this.index.clear();
    }

    @Override
    public void add(O o) {
        int n = this.index.get(o);
        this.offerAt(n, o);
    }

    protected void offerAt(int n, O o) {
        Comparable comparable;
        if (n == Integer.MIN_VALUE) {
            if (this.size + 1 > this.queue.length) {
                this.resize(this.size + 1);
            }
            this.index.put(o, this.size);
            ++this.size;
            this.heapifyUp(this.size - 1, o);
            this.heapModified();
            return;
        }
        assert (n >= 0) : "Unexpected negative position.";
        assert (this.queue[n].equals(o));
        if (this.comparator == null ? (comparable = (Comparable)o).compareTo(this.queue[n]) >= 0 : this.comparator.compare(o, this.queue[n]) >= 0) {
            return;
        }
        this.heapifyUp(n, o);
        this.heapModified();
    }

    @Override
    protected O removeAt(int n) {
        if (n < 0 || n >= this.size) {
            return null;
        }
        Object object = this.queue[n];
        Object object2 = this.queue[this.size - 1];
        this.queue[this.size - 1] = null;
        --this.size;
        if (this.comparator != null) {
            if (this.comparator.compare(object, object2) > 0) {
                this.heapifyUpComparator(n, object2);
            } else {
                this.heapifyDownComparator(n, object2);
            }
        } else {
            Comparable comparable = (Comparable)object;
            if (comparable.compareTo(object2) > 0) {
                this.heapifyUpComparable(n, object2);
            } else {
                this.heapifyDownComparable(n, object2);
            }
        }
        this.heapModified();
        this.index.remove(object);
        return (O)object;
    }

    public O removeObject(O o) {
        int n = this.index.get(o);
        if (n >= 0) {
            return this.removeAt(n);
        }
        return null;
    }

    @Override
    public O poll() {
        Object e = super.poll();
        this.index.remove(e);
        return (O)e;
    }

    @Override
    public O replaceTopElement(O o) {
        O o2 = super.replaceTopElement(o);
        this.index.remove(o2);
        return o2;
    }

    @Override
    protected void heapifyUpComparable(int n, Object object) {
        int n2;
        Object object2;
        Comparable comparable = (Comparable)object;
        while (n > 0 && comparable.compareTo(object2 = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = object2;
            this.index.put(object2, n);
            n = n2;
        }
        this.queue[n] = comparable;
        this.index.put((Object)comparable, n);
    }

    @Override
    protected void heapifyUpComparator(int n, Object object) {
        int n2;
        Object object2;
        while (n > 0 && this.comparator.compare(object, object2 = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = object2;
            this.index.put(object2, n);
            n = n2;
        }
        this.queue[n] = object;
        this.index.put(object, n);
    }

    @Override
    protected boolean heapifyDownComparable(int n, Object object) {
        Comparable comparable = (Comparable)object;
        int n2 = n;
        int n3 = this.size >>> 1;
        while (n2 < n3) {
            Object object2;
            int n4 = (n2 << 1) + 1;
            Object object3 = this.queue[n4];
            int n5 = n4 + 1;
            if (n5 < this.size && ((Comparable)object3).compareTo(object2 = this.queue[n5]) > 0) {
                n4 = n5;
                object3 = object2;
            }
            if (comparable.compareTo(object3) <= 0) break;
            this.queue[n2] = object3;
            this.index.put(object3, n2);
            n2 = n4;
        }
        this.queue[n2] = comparable;
        this.index.put((Object)comparable, n2);
        return n2 != n;
    }

    @Override
    protected boolean heapifyDownComparator(int n, Object object) {
        int n2 = n;
        int n3 = this.size >>> 1;
        while (n2 < n3) {
            Object object2;
            int n4;
            int n5 = n2;
            Object object3 = object;
            int n6 = (n2 << 1) + 1;
            Object object4 = this.queue[n6];
            if (this.comparator.compare(object3, object4) > 0) {
                n5 = n6;
                object3 = object4;
            }
            if ((n4 = n6 + 1) < this.size && this.comparator.compare(object3, object2 = this.queue[n4]) > 0) {
                n5 = n4;
                object3 = object2;
            }
            if (n5 == n2) break;
            this.queue[n2] = object3;
            this.index.put(object3, n2);
            n2 = n5;
        }
        this.queue[n2] = object;
        this.index.put(object, n2);
        return n2 != n;
    }
}

