/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.FloatStaticHistogram;

public class FloatDynamicHistogram
extends FloatStaticHistogram {
    private double[] cachec;
    private float[] cachev;
    private int cachefill;
    private int destsize;

    public FloatDynamicHistogram(int n) {
        super(-1, 0.0, 1.0);
        this.destsize = n;
        this.cachec = new double[this.destsize << 2];
        this.cachev = new float[this.destsize << 2];
        this.cachefill = 0;
    }

    void materialize() {
        if (this.cachefill < 0) {
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < this.cachefill; ++i) {
            d = Math.min(d, this.cachec[i]);
            d2 = Math.max(d2, this.cachec[i]);
        }
        LinearScale linearScale = new LinearScale(d, d2);
        d = linearScale.getMin();
        d2 = linearScale.getMax();
        this.base = d;
        this.max = d2;
        this.binsize = (d2 - d) / (double)this.destsize;
        this.data = new float[this.destsize << 1];
        this.size = this.destsize;
        int n = this.cachefill;
        this.cachefill = -1;
        for (int i = 0; i < n; ++i) {
            this.increment(this.cachec[i], this.cachev[i]);
        }
        this.cachec = null;
        this.cachev = null;
    }

    @Override
    public float get(double d) {
        this.materialize();
        this.testResample(d);
        return super.get(d);
    }

    @Override
    public void increment(double d, float f) {
        if (this.cachefill >= 0) {
            if (this.cachefill < this.cachec.length) {
                this.cachec[this.cachefill] = d;
                this.cachev[this.cachefill] = f;
                ++this.cachefill;
                return;
            }
            this.materialize();
        }
        this.testResample(d);
        super.increment(d, f);
    }

    private void testResample(double d) {
        int n;
        int n2;
        int n3 = this.getBinNr(d);
        if (n3 < 0) {
            n2 = this.size - n3;
            n = -n3;
        } else if (n3 >= this.data.length) {
            n2 = n3 + 1;
            n = 0;
        } else {
            return;
        }
        if (n2 < this.data.length) {
            return;
        }
        int n4 = BitsUtil.magnitude(n2 / this.destsize) - 1;
        assert (n4 > 0) : "No resampling required?!? sizereq=" + n2 + " destsize=" + this.destsize + " array=" + this.data.length;
        int n5 = 1 << n4;
        int n6 = n / (n5 - 1);
        int n7 = n6 >= 0 ? n6 : 0;
        int n8 = (n7 << n4) - n;
        assert (-n5 < n8 && n8 <= n7 && n7 < n8 + n5) : n8 + " -> " + n7 + " s=" + n5 + " o=" + n + " l=" + n4;
        while (n8 < this.size) {
            assert (n7 < n8 + n5 && n7 < this.data.length);
            this.data[n7] = this.downsample(this.data, Math.max(0, n8), Math.min(this.size, n8 + n5), n5);
            n8 += n5;
            ++n7;
        }
        while (n7 < this.data.length) {
            this.data[n7] = 0.0f;
            ++n7;
        }
        if (n >= n5) {
            n7 = n6 - 1 < this.size ? n6 - 1 : this.size - 1;
            n8 = (n7 << n4) - n;
            assert (n7 > n8) : n8 + " -> " + n7 + " s=" + n5 + " o=" + n + " l=" + n4;
            while (n8 > -n5) {
                assert (n7 >= n8 && n7 >= 0);
                this.data[n7] = this.downsample(this.data, Math.max(0, n8), Math.min(this.size, n8 + n5), n5);
                n8 -= n5;
                --n7;
            }
            while (n7 >= 0) {
                this.data[n7] = 0.0f;
                --n7;
            }
        }
        this.base -= (double)(this.offset + n) * this.binsize;
        this.offset = 0;
        this.size = this.size + 1 >> n4;
        this.binsize *= (double)(1 << n4);
        this.max = this.base + this.binsize * (double)this.size;
    }

    @Override
    public FloatStaticHistogram.Iter iter() {
        this.materialize();
        return super.iter();
    }

    @Override
    public int getNumBins() {
        this.materialize();
        return super.getNumBins();
    }

    @Override
    public double getBinsize() {
        this.materialize();
        return super.getBinsize();
    }

    @Override
    public double getCoverMinimum() {
        this.materialize();
        return super.getCoverMinimum();
    }

    @Override
    public double getCoverMaximum() {
        this.materialize();
        return super.getCoverMaximum();
    }

    protected float downsample(float[] fArray, int n, int n2, int n3) {
        float f = 0.0f;
        for (int i = n; i < n2; ++i) {
            f += fArray[i];
        }
        return f;
    }
}

