/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParameter<THIS extends AbstractParameter<THIS, T>, T>
implements Parameter<T> {
    protected T defaultValue = null;
    private boolean defaultValueTaken = false;
    protected boolean optionalParameter = false;
    protected List<ParameterConstraint<? super T>> constraints;
    protected final OptionID optionid;
    protected String shortDescription;
    protected T givenValue = null;
    private T value;

    public AbstractParameter(OptionID optionID, T t) {
        this.optionid = optionID;
        this.shortDescription = optionID.getDescription();
        this.optionalParameter = true;
        this.defaultValue = t;
    }

    public AbstractParameter(OptionID optionID, boolean bl) {
        this.optionid = optionID;
        this.shortDescription = optionID.getDescription();
        this.optionalParameter = bl;
        this.defaultValue = null;
    }

    public AbstractParameter(OptionID optionID) {
        this(optionID, false);
    }

    public THIS setDefaultValue(T t) {
        this.defaultValue = t;
        this.optionalParameter = true;
        return (THIS)this;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public void useDefaultValue() {
        this.setValueInternal(this.defaultValue);
        this.defaultValueTaken = true;
    }

    @Override
    public boolean tryDefaultValue() throws UnspecifiedParameterException {
        if (this.hasDefaultValue()) {
            this.useDefaultValue();
            return true;
        }
        if (this.isOptional()) {
            return false;
        }
        throw new UnspecifiedParameterException(this);
    }

    public THIS setOptional(boolean bl) {
        this.optionalParameter = bl;
        return (THIS)this;
    }

    @Override
    public boolean isOptional() {
        return this.optionalParameter;
    }

    @Override
    public boolean tookDefaultValue() {
        return this.defaultValueTaken;
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean hasValuesDescription() {
        return false;
    }

    @Override
    public String getValuesDescription() {
        return "";
    }

    @Override
    public String getFullDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.shortDescription);
        stringBuilder.append(FormatUtil.NEWLINE);
        if (this.hasValuesDescription()) {
            String string = this.getValuesDescription();
            stringBuilder.append(string);
            if (!string.endsWith(FormatUtil.NEWLINE)) {
                stringBuilder.append(FormatUtil.NEWLINE);
            }
        }
        if (this.hasDefaultValue()) {
            stringBuilder.append("Default: ");
            stringBuilder.append(this.getDefaultValueAsString());
            stringBuilder.append(FormatUtil.NEWLINE);
        }
        if (this.constraints != null && !this.constraints.isEmpty()) {
            if (this.constraints.size() == 1) {
                stringBuilder.append("Constraint: ");
            } else if (this.constraints.size() > 1) {
                stringBuilder.append("Constraints: ");
            }
            for (int i = 0; i < this.constraints.size(); ++i) {
                ParameterConstraint<T> parameterConstraint = this.constraints.get(i);
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(parameterConstraint.getDescription(this.getName()));
                if (i != this.constraints.size() - 1) continue;
                stringBuilder.append('.');
            }
            stringBuilder.append(FormatUtil.NEWLINE);
        }
        return stringBuilder.toString();
    }

    protected boolean validate(T t) throws ParameterException {
        if (this.constraints != null) {
            for (ParameterConstraint<T> parameterConstraint : this.constraints) {
                parameterConstraint.test(t);
            }
        }
        return true;
    }

    @Override
    public OptionID getOptionID() {
        return this.optionid;
    }

    @Override
    public String getName() {
        return this.optionid.getName();
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    @Override
    public void setValue(Object object) throws ParameterException {
        T t = this.parseValue(object);
        if (!this.validate(t)) {
            throw new InvalidParameterException("Value for option \"" + this.getName() + "\" did not validate: " + object.toString());
        }
        this.setValueInternal(t);
    }

    protected final void setValueInternal(T t) {
        this.givenValue = t;
        this.value = this.givenValue;
    }

    @Override
    public final T getValue() {
        if (this.value == null) {
            LoggingUtil.warning("Programming error: Parameter#getValue() called for unset parameter \"" + this.optionid.getName() + "\"", new Throwable());
        }
        return this.value;
    }

    @Override
    public Object getGivenValue() {
        return this.givenValue;
    }

    @Override
    public final boolean isValid(Object object) throws ParameterException {
        T t = this.parseValue(object);
        return this.validate(t);
    }

    @Override
    public abstract String getSyntax();

    protected abstract T parseValue(Object var1) throws ParameterException;

    @Override
    public abstract String getValueAsString();

    @Override
    public String getDefaultValueAsString() {
        return this.getDefaultValue().toString();
    }

    public THIS addConstraint(ParameterConstraint<? super T> parameterConstraint) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ParameterConstraint<? super T>>(1);
        }
        this.constraints.add(parameterConstraint);
        return (THIS)this;
    }
}

