/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DoubleArrayListParameter
extends ListParameter<DoubleArrayListParameter, List<double[]>> {
    public DoubleArrayListParameter(OptionID optionID, ParameterConstraint<List<double[]>> parameterConstraint, List<double[]> list) {
        super(optionID, list);
        this.addConstraint(parameterConstraint);
    }

    public DoubleArrayListParameter(OptionID optionID, ParameterConstraint<List<double[]>> parameterConstraint, boolean bl) {
        super(optionID, bl);
        this.addConstraint(parameterConstraint);
    }

    public DoubleArrayListParameter(OptionID optionID, ParameterConstraint<List<double[]>> parameterConstraint) {
        super(optionID);
        this.addConstraint(parameterConstraint);
    }

    public DoubleArrayListParameter(OptionID optionID, List<double[]> list) {
        super(optionID, list);
    }

    public DoubleArrayListParameter(OptionID optionID, boolean bl) {
        super(optionID, bl);
    }

    public DoubleArrayListParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        List list = (List)this.getValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(FormatUtil.format((double[])iterator.next(), ","));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDefaultValueAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        List list = (List)this.getDefaultValue();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(FormatUtil.format((double[])iterator.next(), ","));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    @Override
    protected List<double[]> parseValue(Object object) throws ParameterException {
        if (object instanceof String) {
            String[] stringArray = VECTOR_SPLIT.split((String)object);
            if (stringArray.length == 0) {
                throw new WrongParameterValueException("Wrong parameter format! Given list of vectors for parameter \"" + this.getName() + "\" is empty!");
            }
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            double[] dArray = new double[11];
            int n = 0;
            for (String string : stringArray) {
                String[] stringArray2;
                n = 0;
                for (String string2 : stringArray2 = SPLIT.split(string)) {
                    try {
                        if (n == dArray.length) {
                            dArray = Arrays.copyOf(dArray, dArray.length << 1);
                        }
                        dArray[n++] = FormatUtil.parseDouble(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new WrongParameterValueException("Wrong parameter format! Coordinates of vector \"" + string + "\" are not valid!");
                    }
                }
                arrayList.add(Arrays.copyOf(dArray, n));
            }
            return arrayList;
        }
        throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a list of double values!");
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }

    @Override
    public String getSyntax() {
        return "<double_11,...,double_1n:...:double_m1,...,double_mn>";
    }
}

