/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.NumberParameter;

public class LongParameter
extends NumberParameter<LongParameter, Long> {
    public LongParameter(OptionID optionID, long l) {
        super(optionID, l);
    }

    public LongParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Long)this.getValue()).toString();
    }

    @Override
    protected Long parseValue(Object object) throws ParameterException {
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.valueOf(object.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a long value, read: " + object + "!\n");
        }
        catch (NumberFormatException numberFormatException) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getName() + "\" requires a long value, read: " + object + "!\n");
        }
    }

    @Override
    public String getSyntax() {
        return "<long>";
    }
}

