/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.StaticScalingFunction;

public class GammaScaling
implements StaticScalingFunction {
    public static final OptionID GAMMA_ID = new OptionID("scaling.gamma", "Gamma value for scaling.");
    private double gamma;

    public GammaScaling() {
        this(1.0);
    }

    public GammaScaling(double d) {
        this.gamma = d;
    }

    @Override
    public double getScaled(double d) {
        return Math.pow(d, this.gamma);
    }

    @Override
    public double getMin() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMax() {
        return Double.POSITIVE_INFINITY;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        double gamma = 1.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(GAMMA_ID);
            if (parameterization.grab(doubleParameter)) {
                this.gamma = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected GammaScaling makeInstance() {
            return new GammaScaling(this.gamma);
        }
    }
}

