/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta.BestFitEstimator;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import java.util.Arrays;

@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM), Mesa, AZ, 2011", url="http://siam.omnibooksonline.com/2011datamining/data/papers/018.pdf")
public class COPOutlierScaling
implements OutlierScalingFunction {
    private double phi = 0.0;
    private Distribution dist;
    private boolean inverted = false;

    public COPOutlierScaling(double d) {
        this.phi = d;
    }

    @Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Outlier Detection in Arbitrarily Oriented Subspaces", booktitle="Proc. IEEE International Conference on Data Mining (ICDM 2012)")
    public static final void secondReference() {
    }

    @Override
    public double getScaled(double d) {
        if (this.dist == null) {
            throw new AbortException("Programming error: outlier scaling not initialized.");
        }
        double d2 = this.inverted ? 1.0 - this.dist.cdf(d) : this.dist.cdf(d);
        return this.phi > 0.0 ? this.phi * d2 / (1.0 - d2 + this.phi) : d2;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        DoubleRelation doubleRelation = outlierResult.getScores();
        double[] dArray = new double[doubleRelation.size()];
        int n = 0;
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            dArray[n] = doubleRelation.doubleValue(dBIDIter);
            dBIDIter.advance();
            ++n;
        }
        Arrays.sort(dArray);
        this.dist = BestFitEstimator.STATIC.estimate(dArray, ArrayLikeUtil.DOUBLEARRAYADAPTER);
        this.inverted = outlierResult.getOutlierMeta() instanceof InvertedOutlierScoreMeta;
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        double[] dArray = ArrayLikeUtil.toPrimitiveDoubleArray(a, numberArrayAdapter);
        Arrays.sort(dArray);
        this.dist = BestFitEstimator.STATIC.estimate(dArray, ArrayLikeUtil.DOUBLEARRAYADAPTER);
        this.inverted = false;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PHI_ID = new OptionID("copscaling.phi", "Phi parameter, expected rate of outliers. Set to 0 to use raw CDF values.");
        private double phi = 0.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(PHI_ID);
            if (parameterization.grab(doubleParameter)) {
                this.phi = doubleParameter.doubleValue();
            }
        }

        @Override
        protected COPOutlierScaling makeInstance() {
            return new COPOutlierScaling(this.phi);
        }
    }
}

