/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM), Mesa, AZ, 2011", url="http://dx.doi.org/10.1137/1.9781611972818.2")
public class OutlierGammaScaling
implements OutlierScalingFunction {
    public static final OptionID NORMALIZE_ID = new OptionID("gammascale.normalize", "Regularize scores before using Gamma scaling.");
    double k;
    double theta;
    double atmean = 0.5;
    boolean normalize = false;
    OutlierScoreMeta meta = null;

    public OutlierGammaScaling(boolean bl) {
        this.normalize = bl;
    }

    @Override
    public double getScaled(double d) {
        assert (this.theta > 0.0) : "prepare() was not run prior to using the scaling function.";
        if (Double.isNaN(d = this.preScale(d)) || Double.isInfinite(d)) {
            return 1.0;
        }
        return Math.max(0.0, (GammaDistribution.regularizedGammaP(this.k, d / this.theta) - this.atmean) / (1.0 - this.atmean));
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        this.meta = outlierResult.getOutlierMeta();
        MeanVariance meanVariance = new MeanVariance();
        DoubleRelation doubleRelation = outlierResult.getScores();
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = doubleRelation.doubleValue(dBIDIter);
            if (!Double.isNaN(d = this.preScale(d)) && !Double.isInfinite(d)) {
                meanVariance.put(d);
            }
            dBIDIter.advance();
        }
        double d = meanVariance.getMean();
        double d2 = meanVariance.getSampleVariance();
        this.k = d * d / d2;
        this.theta = d2 / d;
        this.atmean = GammaDistribution.regularizedGammaP(this.k, d / this.theta);
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        MeanVariance meanVariance = new MeanVariance();
        int n = numberArrayAdapter.size(a);
        for (int i = 0; i < n; ++i) {
            double d = numberArrayAdapter.getDouble(a, i);
            if (Double.isNaN(d = this.preScale(d)) || Double.isInfinite(d)) continue;
            meanVariance.put(d);
        }
        double d = meanVariance.getMean();
        double d2 = meanVariance.getSampleVariance();
        this.k = d * d / d2;
        this.theta = d2 / d;
        this.atmean = GammaDistribution.regularizedGammaP(this.k, d / this.theta);
    }

    protected double preScale(double d) {
        if (this.normalize) {
            d = this.meta.normalizeScore(d);
        }
        return d;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected boolean normalize = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(NORMALIZE_ID);
            if (parameterization.grab(flag)) {
                this.normalize = (Boolean)flag.getValue();
            }
        }

        @Override
        protected OutlierGammaScaling makeInstance() {
            return new OutlierGammaScaling(this.normalize);
        }
    }
}

