/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

@Reference(authors="J. Gao, P.-N. Tan", title="Converting Output Scores from Outlier Detection Algorithms into Probability Estimates", booktitle="Proc. Sixth International Conference on Data Mining, 2006. ICDM'06.", url="http://dx.doi.org/10.1109/ICDM.2006.43")
public class SigmoidOutlierScalingFunction
implements OutlierScalingFunction {
    private static final Logging LOG = Logging.getLogger(SigmoidOutlierScalingFunction.class);
    double Afinal;
    double Bfinal;

    @Override
    public void prepare(OutlierResult outlierResult) {
        MeanVariance meanVariance = new MeanVariance();
        DoubleRelation doubleRelation = outlierResult.getScores();
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = doubleRelation.doubleValue(dBIDIter);
            meanVariance.put(d);
            dBIDIter.advance();
        }
        double d = 1.0;
        double d2 = -meanVariance.getMean();
        int n = 0;
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(outlierResult.getScores().getDBIDs());
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        long[] lArray = BitsUtil.zero(arrayDBIDs.size());
        boolean bl = true;
        while (bl) {
            bl = false;
            dBIDArrayIter.seek(0);
            for (int i = 0; i < arrayDBIDs.size(); ++i) {
                double d3 = outlierResult.getScores().doubleValue(dBIDArrayIter);
                double d4 = d * d3 + d2;
                if (d4 > 0.0) {
                    if (!BitsUtil.get(lArray, i)) {
                        BitsUtil.setI(lArray, i);
                        bl = true;
                    }
                } else if (BitsUtil.get(lArray, i)) {
                    BitsUtil.clearI(lArray, i);
                    bl = true;
                }
                dBIDArrayIter.advance();
            }
            if (!bl) break;
            double[] dArray = this.MStepLevenbergMarquardt(d, d2, arrayDBIDs, lArray, outlierResult.getScores());
            d = dArray[0];
            d2 = dArray[1];
            if (++n <= 100) continue;
            LOG.warning("Max iterations met in sigmoid fitting.");
            break;
        }
        this.Afinal = d;
        this.Bfinal = d2;
        LOG.debugFine("A = " + this.Afinal + " B = " + this.Bfinal);
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        MeanVariance meanVariance = new MeanVariance();
        int n = numberArrayAdapter.size(a);
        for (int i = 0; i < n; ++i) {
            double d = numberArrayAdapter.getDouble(a, i);
            if (Double.isInfinite(d)) continue;
            meanVariance.put(d);
        }
        double d = 1.0;
        double d2 = -meanVariance.getMean();
        int n2 = 0;
        long[] lArray = BitsUtil.zero(n);
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < n; ++i) {
                double d3 = numberArrayAdapter.getDouble(a, i);
                double d4 = d * d3 + d2;
                if (d4 > 0.0) {
                    if (BitsUtil.get(lArray, i)) continue;
                    BitsUtil.setI(lArray, i);
                    bl = true;
                    continue;
                }
                if (!BitsUtil.get(lArray, i)) continue;
                BitsUtil.clearI(lArray, i);
                bl = true;
            }
            if (!bl) break;
            double[] dArray = this.MStepLevenbergMarquardt(d, d2, lArray, a, numberArrayAdapter);
            d = dArray[0];
            d2 = dArray[1];
            if (++n2 <= 100) continue;
            LOG.warning("Max iterations met in sigmoid fitting.");
            break;
        }
        this.Afinal = d;
        this.Bfinal = d2;
        LOG.debugFine("A = " + this.Afinal + " B = " + this.Bfinal);
    }

    private final double[] MStepLevenbergMarquardt(double d, double d2, ArrayDBIDs arrayDBIDs, long[] lArray, DoubleRelation doubleRelation) {
        double d3;
        double d4;
        double d5;
        int n;
        int n2 = BitsUtil.cardinality(lArray);
        int n3 = arrayDBIDs.size() - n2;
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        double d6 = ((double)n2 + 1.0) / ((double)n2 + 2.0);
        double d7 = 1.0 / ((double)n3 + 2.0);
        double d8 = 0.0;
        dBIDArrayIter.seek(0);
        for (n = 0; n < arrayDBIDs.size(); ++n) {
            d5 = doubleRelation.doubleValue(dBIDArrayIter);
            d4 = d5 * d + d2;
            double d9 = d3 = BitsUtil.get(lArray, n) ? d7 : d6;
            d8 = d4 >= 0.0 ? (d8 += d3 * d4 + Math.log(1.0 + Math.exp(-d4))) : (d8 += (d3 - 1.0) * d4 + Math.log(1.0 + Math.exp(d4)));
            dBIDArrayIter.advance();
        }
        for (n = 0; n < 10; ++n) {
            d5 = 1.0E-12;
            d4 = 1.0E-12;
            d3 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            dBIDArrayIter.seek(0);
            for (int i = 0; i < arrayDBIDs.size(); ++i) {
                double d12;
                double d13;
                double d14 = doubleRelation.doubleValue(dBIDArrayIter);
                double d15 = d14 * d + d2;
                if (d15 >= 0.0) {
                    d13 = Math.exp(-d15) / (1.0 + Math.exp(-d15));
                    d12 = 1.0 / (1.0 + Math.exp(-d15));
                } else {
                    d13 = 1.0 / (1.0 + Math.exp(d15));
                    d12 = Math.exp(d15) / (1.0 + Math.exp(d15));
                }
                double d16 = d13 * d12;
                d5 += d14 * d14 * d16;
                d4 += d16;
                d3 += d14 * d16;
                double d17 = (BitsUtil.get(lArray, i) ? d7 : d6) - d13;
                d10 += d14 * d17;
                d11 += d17;
                dBIDArrayIter.advance();
            }
            if (Math.abs(d10) < 1.0E-5 && Math.abs(d11) < 1.0E-5) break;
            double d18 = d5 * d4 - d3 * d3;
            double d19 = -(d4 * d10 - d3 * d11) / d18;
            double d20 = -(-d3 * d10 + d5 * d11) / d18;
            double d21 = d10 * d19 + d11 * d20;
            double d22 = 1.0;
            while (d22 >= 1.0E-8) {
                double d23 = d + d22 * d19;
                double d24 = d2 + d22 * d20;
                double d25 = 0.0;
                dBIDArrayIter.seek(0);
                for (int i = 0; i < arrayDBIDs.size(); ++i) {
                    double d26;
                    double d27 = doubleRelation.doubleValue(dBIDArrayIter);
                    double d28 = d27 * d23 + d24;
                    double d29 = d26 = BitsUtil.get(lArray, i) ? d7 : d6;
                    d25 = d28 >= 0.0 ? (d25 += d26 * d28 + Math.log(1.0 + Math.exp(-d28))) : (d25 += (d26 - 1.0) * d28 + Math.log(1.0 + Math.exp(d28)));
                    dBIDArrayIter.advance();
                }
                if (d25 < d8 + 1.0E-4 * d22 * d21) {
                    d = d23;
                    d2 = d24;
                    d8 = d25;
                    break;
                }
                if (!((d22 /= 2.0) < 1.0E-8)) continue;
                LOG.debug("Minstep hit.");
                break;
            }
            if (n + 1 < 10) continue;
            LOG.debug("Maximum iterations hit.");
            break;
        }
        return new double[]{d, d2};
    }

    private final <A> double[] MStepLevenbergMarquardt(double d, double d2, long[] lArray, A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        double d3;
        double d4;
        double d5;
        int n;
        int n2 = numberArrayAdapter.size(a);
        int n3 = BitsUtil.cardinality(lArray);
        int n4 = n2 - n3;
        double d6 = ((double)n3 + 1.0) / ((double)n3 + 2.0);
        double d7 = 1.0 / ((double)n4 + 2.0);
        double d8 = 0.0;
        for (n = 0; n < n2; ++n) {
            d5 = numberArrayAdapter.getDouble(a, n);
            d4 = d5 * d + d2;
            double d9 = d3 = BitsUtil.get(lArray, n) ? d7 : d6;
            if (d4 >= 0.0) {
                d8 += d3 * d4 + Math.log(1.0 + Math.exp(-d4));
                continue;
            }
            d8 += (d3 - 1.0) * d4 + Math.log(1.0 + Math.exp(d4));
        }
        for (n = 0; n < 10; ++n) {
            d5 = 1.0E-12;
            d4 = 1.0E-12;
            d3 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d12;
                double d13;
                double d14 = numberArrayAdapter.getDouble(a, i);
                double d15 = d14 * d + d2;
                if (d15 >= 0.0) {
                    d13 = Math.exp(-d15) / (1.0 + Math.exp(-d15));
                    d12 = 1.0 / (1.0 + Math.exp(-d15));
                } else {
                    d13 = 1.0 / (1.0 + Math.exp(d15));
                    d12 = Math.exp(d15) / (1.0 + Math.exp(d15));
                }
                double d16 = d13 * d12;
                d5 += d14 * d14 * d16;
                d4 += d16;
                d3 += d14 * d16;
                double d17 = (BitsUtil.get(lArray, i) ? d7 : d6) - d13;
                d10 += d14 * d17;
                d11 += d17;
            }
            if (Math.abs(d10) < 1.0E-5 && Math.abs(d11) < 1.0E-5) break;
            double d18 = d5 * d4 - d3 * d3;
            double d19 = -(d4 * d10 - d3 * d11) / d18;
            double d20 = -(-d3 * d10 + d5 * d11) / d18;
            double d21 = d10 * d19 + d11 * d20;
            double d22 = 1.0;
            while (d22 >= 1.0E-8) {
                double d23 = d + d22 * d19;
                double d24 = d2 + d22 * d20;
                double d25 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    double d26;
                    double d27 = numberArrayAdapter.getDouble(a, i);
                    double d28 = d27 * d23 + d24;
                    double d29 = d26 = BitsUtil.get(lArray, i) ? d7 : d6;
                    if (d28 >= 0.0) {
                        d25 += d26 * d28 + Math.log(1.0 + Math.exp(-d28));
                        continue;
                    }
                    d25 += (d26 - 1.0) * d28 + Math.log(1.0 + Math.exp(d28));
                }
                if (d25 < d8 + 1.0E-4 * d22 * d21) {
                    d = d23;
                    d2 = d24;
                    d8 = d25;
                    break;
                }
                if (!((d22 /= 2.0) < 1.0E-8)) continue;
                LOG.debug("Minstep hit.");
                break;
            }
            if (n + 1 < 10) continue;
            LOG.debug("Maximum iterations hit.");
            break;
        }
        return new double[]{d, d2};
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getScaled(double d) {
        return 1.0 / (1.0 + Math.exp(-this.Afinal * d - this.Bfinal));
    }
}

