/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.forkjoin;

import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.impl.block.procedure.MultimapPutProcedure;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.forkjoin.FJBatchIterableProcedureRunner;
import org.eclipse.collections.impl.forkjoin.FJListObjectIntProcedureRunner;
import org.eclipse.collections.impl.forkjoin.FJListProcedureRunner;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.eclipse.collections.impl.multimap.list.SynchronizedPutFastListMultimap;
import org.eclipse.collections.impl.parallel.BatchIterable;
import org.eclipse.collections.impl.parallel.CollectIfProcedureCombiner;
import org.eclipse.collections.impl.parallel.CollectIfProcedureFactory;
import org.eclipse.collections.impl.parallel.Combiner;
import org.eclipse.collections.impl.parallel.Combiners;
import org.eclipse.collections.impl.parallel.CountCombiner;
import org.eclipse.collections.impl.parallel.CountProcedureFactory;
import org.eclipse.collections.impl.parallel.FastListCollectProcedureCombiner;
import org.eclipse.collections.impl.parallel.FastListCollectProcedureFactory;
import org.eclipse.collections.impl.parallel.FlatCollectProcedureCombiner;
import org.eclipse.collections.impl.parallel.FlatCollectProcedureFactory;
import org.eclipse.collections.impl.parallel.ObjectIntProcedureFactory;
import org.eclipse.collections.impl.parallel.ParallelArrayIterate;
import org.eclipse.collections.impl.parallel.ParallelIterate;
import org.eclipse.collections.impl.parallel.PassThruCombiner;
import org.eclipse.collections.impl.parallel.PassThruObjectIntProcedureFactory;
import org.eclipse.collections.impl.parallel.PassThruProcedureFactory;
import org.eclipse.collections.impl.parallel.ProcedureFactory;
import org.eclipse.collections.impl.parallel.RejectProcedureCombiner;
import org.eclipse.collections.impl.parallel.RejectProcedureFactory;
import org.eclipse.collections.impl.parallel.SelectProcedureCombiner;
import org.eclipse.collections.impl.parallel.SelectProcedureFactory;
import org.eclipse.collections.impl.utility.Iterate;

public final class FJIterate {
    public static final int DEFAULT_MIN_FORK_SIZE = 5000;
    private static final int DEFAULT_PARALLEL_TASK_COUNT = ParallelIterate.getDefaultTaskCount() * 4;
    private static final ForkJoinPool FORK_JOIN_POOL = new ForkJoinPool(ParallelIterate.getDefaultMaxThreadPoolSize());

    private FJIterate() {
    }

    public static <T> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedure<? super T> procedure) {
        FJIterate.forEachWithIndex(iterable, procedure, FORK_JOIN_POOL);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, PT procedure, ForkJoinPool executor) {
        PassThruObjectIntProcedureFactory procedureFactory = new PassThruObjectIntProcedureFactory(procedure);
        PassThruCombiner combiner = new PassThruCombiner();
        FJIterate.forEachWithIndex(iterable, procedureFactory, combiner, executor);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, PT procedure, int minForkSize, int taskCount) {
        PassThruObjectIntProcedureFactory procedureFactory = new PassThruObjectIntProcedureFactory(procedure);
        PassThruCombiner combiner = new PassThruCombiner();
        FJIterate.forEachWithIndex(iterable, procedureFactory, combiner, minForkSize, taskCount);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, ForkJoinPool executor) {
        int taskCount = Math.max(DEFAULT_PARALLEL_TASK_COUNT, Iterate.sizeOf(iterable) / 5000);
        FJIterate.forEachWithIndex(iterable, procedureFactory, combiner, 5000, taskCount, executor);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount) {
        FJIterate.forEachWithIndex(iterable, procedureFactory, combiner, minForkSize, taskCount, FORK_JOIN_POOL);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        if (Iterate.notEmpty(iterable)) {
            if ((iterable instanceof RandomAccess || iterable instanceof ListIterable) && iterable instanceof List) {
                FJIterate.forEachWithIndexInListOnExecutor((List)iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
            } else {
                FJIterate.forEachWithIndexInListOnExecutor(ArrayAdapter.adapt((Object[])Iterate.toArray(iterable)), procedureFactory, combiner, minForkSize, taskCount, executor);
            }
        }
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndexInListOnExecutor(List<T> list, ObjectIntProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        int size = list.size();
        if (size < minForkSize || FJIterate.executedInsideOfForEach()) {
            ObjectIntProcedure procedure = procedureFactory.create();
            Iterate.forEachWithIndex(list, (ObjectIntProcedure)procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne((Object)procedure);
            } else {
                combiner.combineAll((Iterable)Lists.immutable.of((Object)procedure));
            }
        } else {
            int threadCount = Math.min(size, taskCount);
            new FJListObjectIntProcedureRunner<T, PT>(combiner, threadCount).executeAndCombine(executor, procedureFactory, list);
        }
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure) {
        FJIterate.forEach(iterable, procedure, FORK_JOIN_POOL);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure, int batchSize) {
        FJIterate.forEach(iterable, procedure, batchSize, FORK_JOIN_POOL);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure, int batchSize, ForkJoinPool executor) {
        FJIterate.forEach(iterable, procedure, batchSize, FJIterate.calculateTaskCount(iterable, batchSize), executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, PT procedure, ForkJoinPool executor) {
        PassThruProcedureFactory procedureFactory = new PassThruProcedureFactory(procedure);
        PassThruCombiner combiner = new PassThruCombiner();
        FJIterate.forEach(iterable, procedureFactory, combiner, executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, PT procedure, int minForkSize, int taskCount) {
        FJIterate.forEach(iterable, procedure, minForkSize, taskCount, FORK_JOIN_POOL);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, PT procedure, int minForkSize, int taskCount, ForkJoinPool executor) {
        PassThruProcedureFactory procedureFactory = new PassThruProcedureFactory(procedure);
        PassThruCombiner combiner = new PassThruCombiner();
        FJIterate.forEach(iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, ForkJoinPool executor) {
        FJIterate.forEach(iterable, procedureFactory, combiner, 5000, executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner) {
        FJIterate.forEach(iterable, procedureFactory, combiner, FORK_JOIN_POOL);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int batchSize) {
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, FORK_JOIN_POOL);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> blockFactory, Combiner<PT> combiner, int batchSize, ForkJoinPool executor) {
        FJIterate.forEach(iterable, blockFactory, combiner, batchSize, FJIterate.calculateTaskCount(iterable, batchSize), executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount) {
        FJIterate.forEach(iterable, procedureFactory, combiner, minForkSize, taskCount, FORK_JOIN_POOL);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        if (Iterate.notEmpty(iterable)) {
            if ((iterable instanceof RandomAccess || iterable instanceof ListIterable) && iterable instanceof List) {
                FJIterate.forEachInListOnExecutor((List)iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
            } else if (iterable instanceof BatchIterable) {
                FJIterate.forEachInBatchWithExecutor((BatchIterable)iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
            } else {
                ParallelArrayIterate.forEachOn((Object[])Iterate.toArray(iterable), procedureFactory, combiner, (int)minForkSize, (int)taskCount, (Executor)executor);
            }
        }
    }

    public static <T, PT extends Procedure<? super T>> void forEachInListOnExecutor(List<T> list, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        int size = list.size();
        if (size < minForkSize || FJIterate.executedInsideOfForEach()) {
            Procedure procedure = procedureFactory.create();
            Iterate.forEach(list, (Procedure)procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne((Object)procedure);
            } else {
                combiner.combineAll((Iterable)Lists.immutable.of((Object)procedure));
            }
        } else {
            int newTaskCount = Math.min(size, taskCount);
            new FJListProcedureRunner<T, PT>(combiner, newTaskCount).executeAndCombine(executor, procedureFactory, list);
        }
    }

    public static <T, PT extends Procedure<? super T>> void forEachInBatchWithExecutor(BatchIterable<T> batchIterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        int size = batchIterable.size();
        if (size < minForkSize || FJIterate.executedInsideOfForEach()) {
            Procedure procedure = procedureFactory.create();
            batchIterable.forEach(procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne((Object)procedure);
            } else {
                combiner.combineAll((Iterable)Lists.immutable.of((Object)procedure));
            }
        } else {
            int newTaskCount = Math.min(size, Math.min(taskCount, batchIterable.getBatchCount((int)Math.ceil((double)size / (double)taskCount))));
            new FJBatchIterableProcedureRunner<T, PT>(combiner, newTaskCount).executeAndCombine(executor, procedureFactory, batchIterable);
        }
    }

    static boolean executedInsideOfForEach() {
        return Thread.currentThread().getName().startsWith("ForkJoinPool");
    }

    public static <T> Collection<T> select(Iterable<T> iterable, Predicate<? super T> predicate) {
        return FJIterate.select(iterable, predicate, false);
    }

    public static <T> Collection<T> select(Iterable<T> iterable, Predicate<? super T> predicate, boolean allowReorderedResult) {
        return FJIterate.select(iterable, predicate, null, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R select(Iterable<T> iterable, Predicate<? super T> predicate, R target, boolean allowReorderedResult) {
        return FJIterate.select(iterable, predicate, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R select(Iterable<T> iterable, Predicate<? super T> predicate, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        SelectProcedureCombiner combiner = new SelectProcedureCombiner(iterable, target, 10, allowReorderedResult);
        SelectProcedureFactory procedureFactory = new SelectProcedureFactory(predicate, batchSize);
        int taskCount = FJIterate.calculateTaskCount(iterable, batchSize);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    private static <T> int calculateTaskCount(Iterable<T> iterable, int batchSize) {
        if (iterable instanceof BatchIterable) {
            return FJIterate.calculateTaskCount((BatchIterable)iterable, batchSize);
        }
        return FJIterate.calculateTaskCount(Iterate.sizeOf(iterable), batchSize);
    }

    private static <T> int calculateTaskCount(BatchIterable<T> batchIterable, int batchSize) {
        return Math.max(2, batchIterable.getBatchCount(batchSize));
    }

    private static int calculateTaskCount(int size, int batchSize) {
        return Math.max(2, size / batchSize);
    }

    public static <T> Collection<T> reject(Iterable<T> iterable, Predicate<? super T> predicate) {
        return FJIterate.reject(iterable, predicate, false);
    }

    public static <T> Collection<T> reject(Iterable<T> iterable, Predicate<? super T> predicate, boolean allowReorderedResult) {
        return FJIterate.reject(iterable, predicate, null, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R reject(Iterable<T> iterable, Predicate<? super T> predicate, R target, boolean allowReorderedResult) {
        return FJIterate.reject(iterable, predicate, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R reject(Iterable<T> iterable, Predicate<? super T> predicate, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        RejectProcedureCombiner combiner = new RejectProcedureCombiner(iterable, target, 10, allowReorderedResult);
        RejectProcedureFactory procedureFactory = new RejectProcedureFactory(predicate, batchSize);
        int taskCount = FJIterate.calculateTaskCount(iterable, batchSize);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    public static <T> int count(Iterable<T> iterable, Predicate<? super T> predicate) {
        return FJIterate.count(iterable, predicate, 5000, FORK_JOIN_POOL);
    }

    public static <T> int count(Iterable<T> iterable, Predicate<? super T> predicate, int batchSize, ForkJoinPool executor) {
        CountCombiner combiner = new CountCombiner();
        CountProcedureFactory procedureFactory = new CountProcedureFactory(predicate);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, executor);
        return combiner.getCount();
    }

    public static <T, V> Collection<V> collect(Iterable<T> iterable, Function<? super T, V> function) {
        return FJIterate.collect(iterable, function, false);
    }

    public static <T, V> Collection<V> collect(Iterable<T> iterable, Function<? super T, V> function, boolean allowReorderedResult) {
        return FJIterate.collect(iterable, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collect(Iterable<T> iterable, Function<? super T, V> function, R target, boolean allowReorderedResult) {
        return FJIterate.collect(iterable, function, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collect(Iterable<T> iterable, Function<? super T, V> function, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        int size = Iterate.sizeOf(iterable);
        FastListCollectProcedureCombiner combiner = new FastListCollectProcedureCombiner(iterable, target, size, allowReorderedResult);
        int taskCount = FJIterate.calculateTaskCount(size, batchSize);
        FastListCollectProcedureFactory procedureFactory = new FastListCollectProcedureFactory(function, size / taskCount);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    public static <T, V> Collection<V> flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function) {
        return FJIterate.flatCollect(iterable, function, false);
    }

    public static <T, V> Collection<V> flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function, boolean allowReorderedResult) {
        return FJIterate.flatCollect(iterable, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function, R target, boolean allowReorderedResult) {
        return FJIterate.flatCollect(iterable, function, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        int size = Iterate.sizeOf(iterable);
        int taskSize = size / DEFAULT_PARALLEL_TASK_COUNT;
        FlatCollectProcedureCombiner combiner = new FlatCollectProcedureCombiner(iterable, target, size, allowReorderedResult);
        FlatCollectProcedureFactory procedureFactory = new FlatCollectProcedureFactory(function, taskSize);
        int taskCount = FJIterate.calculateTaskCount(size, batchSize);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    public static <T, V> Collection<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function) {
        return FJIterate.collectIf(iterable, predicate, function, false);
    }

    public static <T, V> Collection<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, boolean allowReorderedResult) {
        return FJIterate.collectIf(iterable, predicate, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, R target, boolean allowReorderedResult) {
        return FJIterate.collectIf(iterable, predicate, function, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        CollectIfProcedureCombiner combiner = new CollectIfProcedureCombiner(iterable, target, 10, allowReorderedResult);
        CollectIfProcedureFactory procedureFactory = new CollectIfProcedureFactory(function, predicate, batchSize);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, FJIterate.calculateTaskCount(iterable, batchSize), executor);
        return (R)combiner.getResult();
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, 5000);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, mutableMap, 5000);
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, int batchSize) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, batchSize, FORK_JOIN_POOL);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap, int batchSize) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, mutableMap, batchSize, FORK_JOIN_POOL);
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, int batchSize, ForkJoinPool executor) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, ConcurrentHashMap.newMap(), batchSize, executor);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap, int batchSize, ForkJoinPool executor) {
        NonMutatingAggregationProcedure nonMutatingAggregationProcedure = new NonMutatingAggregationProcedure(mutableMap, groupBy, zeroValueFactory, nonMutatingAggregator);
        FJIterate.forEach(iterable, new PassThruProcedureFactory((Procedure)nonMutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return mutableMap;
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        return FJIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, 5000);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap) {
        return FJIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, mutableMap, 5000);
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, int batchSize) {
        return FJIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, batchSize, FORK_JOIN_POOL);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap, int batchSize) {
        return FJIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, mutableMap, batchSize, FORK_JOIN_POOL);
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, int batchSize, ForkJoinPool executor) {
        ConcurrentHashMap map = ConcurrentHashMap.newMap();
        MutatingAggregationProcedure mutatingAggregationProcedure = new MutatingAggregationProcedure((MutableMap)map, groupBy, zeroValueFactory, mutatingAggregator);
        FJIterate.forEach(iterable, new PassThruProcedureFactory((Procedure)mutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return map;
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap, int batchSize, ForkJoinPool executor) {
        MutatingAggregationProcedure mutatingAggregationProcedure = new MutatingAggregationProcedure(mutableMap, groupBy, zeroValueFactory, mutatingAggregator);
        FJIterate.forEach(iterable, new PassThruProcedureFactory((Procedure)mutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return mutableMap;
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function) {
        return FJIterate.groupBy(iterable, function, 5000, FORK_JOIN_POOL);
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap) {
        return FJIterate.groupBy(iterable, function, concurrentMultimap, 5000);
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap, int batchSize) {
        return FJIterate.groupBy(iterable, function, concurrentMultimap, batchSize, FORK_JOIN_POOL);
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, int batchSize) {
        return FJIterate.groupBy(iterable, function, batchSize, FORK_JOIN_POOL);
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, int batchSize, ForkJoinPool executor) {
        return FJIterate.groupBy(iterable, function, SynchronizedPutFastListMultimap.newMultimap(), batchSize, executor);
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap, int batchSize, ForkJoinPool executor) {
        FJIterate.forEach(iterable, new PassThruProcedureFactory((Procedure)new MultimapPutProcedure(concurrentMultimap, function)), Combiners.passThru(), batchSize, executor);
        return concurrentMultimap;
    }
}

