/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.util;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLResource;
import com.jogamp.opencl.util.CLDeviceFilters;
import com.jogamp.opencl.util.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CLMultiContext
implements CLResource {
    private final List<CLContext> contexts = new ArrayList<CLContext>();
    private boolean released;

    private CLMultiContext() {
    }

    public static CLMultiContext create(CLPlatform ... cLPlatformArray) {
        return CLMultiContext.create(cLPlatformArray, CLDevice.Type.ALL);
    }

    public static CLMultiContext create(CLPlatform[] cLPlatformArray, CLDevice.Type ... typeArray) {
        return CLMultiContext.create(cLPlatformArray, CLDeviceFilters.type(typeArray));
    }

    public static CLMultiContext create(CLPlatform[] cLPlatformArray, Filter<CLDevice> ... filterArray) {
        if (cLPlatformArray == null) {
            throw new NullPointerException("platform list was null");
        }
        if (cLPlatformArray.length == 0) {
            throw new IllegalArgumentException("platform list was empty");
        }
        ArrayList<CLDevice> arrayList = new ArrayList<CLDevice>();
        for (CLPlatform cLPlatform : cLPlatformArray) {
            arrayList.addAll(Arrays.asList(cLPlatform.listCLDevices(filterArray)));
        }
        return CLMultiContext.create(arrayList);
    }

    public static CLMultiContext create(Collection<CLDevice> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("device list was empty");
        }
        Map<CLPlatform, List<CLDevice>> map = CLMultiContext.filterPlatformConflicts(collection);
        CLMultiContext cLMultiContext = new CLMultiContext();
        for (Map.Entry<CLPlatform, List<CLDevice>> entry : map.entrySet()) {
            List<CLDevice> list = entry.getValue();
            for (CLDevice cLDevice : list) {
                CLContext cLContext = CLContext.create(cLDevice);
                cLMultiContext.contexts.add(cLContext);
            }
        }
        return cLMultiContext;
    }

    public static CLMultiContext wrap(CLContext ... cLContextArray) {
        CLMultiContext cLMultiContext = new CLMultiContext();
        cLMultiContext.contexts.addAll(Arrays.asList(cLContextArray));
        return cLMultiContext;
    }

    private static Map<CLPlatform, List<CLDevice>> filterPlatformConflicts(Collection<CLDevice> collection) {
        HashMap<CLPlatform, List<CLDevice>> hashMap = new HashMap<CLPlatform, List<CLDevice>>();
        HashMap<String, CLPlatform> hashMap2 = new HashMap<String, CLPlatform>();
        for (CLDevice cLDevice : collection) {
            String string = cLDevice.getName();
            CLPlatform cLPlatform = cLDevice.getPlatform();
            CLPlatform cLPlatform2 = (CLPlatform)hashMap2.get(string);
            if (cLPlatform2 != null && !cLPlatform.equals(cLPlatform2)) continue;
            if (!hashMap.containsKey(cLPlatform)) {
                hashMap.put(cLPlatform, new ArrayList());
            }
            ((List)hashMap.get(cLPlatform)).add(cLDevice);
            hashMap2.put(string, cLPlatform);
        }
        return hashMap;
    }

    @Override
    public void release() {
        if (this.released) {
            throw new RuntimeException(this.getClass().getSimpleName() + " already released");
        }
        this.released = true;
        for (CLContext cLContext : this.contexts) {
            cLContext.release();
        }
        this.contexts.clear();
    }

    public List<CLContext> getContexts() {
        return Collections.unmodifiableList(this.contexts);
    }

    public List<CLDevice> getDevices() {
        ArrayList<CLDevice> arrayList = new ArrayList<CLDevice>();
        for (CLContext cLContext : this.contexts) {
            arrayList.addAll(Arrays.asList(cLContext.getDevices()));
        }
        return arrayList;
    }

    @Override
    public boolean isReleased() {
        return this.released;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.contexts.size() + " contexts, " + this.getDevices().size() + " devices]";
    }
}

