/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VK;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkSurfaceCapabilitiesKHR;
import org.lwjgl.vulkan.VkSurfaceFormatKHR;

public class KHRSurface {
    public static final int VK_KHR_SURFACE_SPEC_VERSION = 25;
    public static final String VK_KHR_SURFACE_EXTENSION_NAME = "VK_KHR_surface";
    public static final int VK_ERROR_SURFACE_LOST_KHR = -1000000000;
    public static final int VK_ERROR_NATIVE_WINDOW_IN_USE_KHR = -1000000001;
    public static final int VK_OBJECT_TYPE_SURFACE_KHR = 1000000000;
    public static final int VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR = 1;
    public static final int VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR = 2;
    public static final int VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR = 4;
    public static final int VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR = 8;
    public static final int VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR = 16;
    public static final int VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR = 32;
    public static final int VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR = 64;
    public static final int VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR = 128;
    public static final int VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR = 256;
    public static final int VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR = 1;
    public static final int VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR = 2;
    public static final int VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR = 4;
    public static final int VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR = 8;
    public static final int VK_COLOR_SPACE_SRGB_NONLINEAR_KHR = 0;
    public static final int VK_COLORSPACE_SRGB_NONLINEAR_KHR = 0;
    public static final int VK_PRESENT_MODE_IMMEDIATE_KHR = 0;
    public static final int VK_PRESENT_MODE_MAILBOX_KHR = 1;
    public static final int VK_PRESENT_MODE_FIFO_KHR = 2;
    public static final int VK_PRESENT_MODE_FIFO_RELAXED_KHR = 3;

    protected KHRSurface() {
        throw new UnsupportedOperationException();
    }

    static boolean checkCapsInstance(FunctionProvider provider, Map<String, Long> caps, Set<String> ext) {
        return ext.contains(VK_KHR_SURFACE_EXTENSION_NAME) && VK.checkExtension(VK_KHR_SURFACE_EXTENSION_NAME, VK.isSupported(provider, "vkDestroySurfaceKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceSurfaceSupportKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceSurfaceCapabilitiesKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceSurfaceFormatsKHR", caps) && VK.isSupported(provider, "vkGetPhysicalDeviceSurfacePresentModesKHR", caps));
    }

    public static void nvkDestroySurfaceKHR(VkInstance instance, long surface, long pAllocator) {
        long __functionAddress = instance.getCapabilities().vkDestroySurfaceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            if (pAllocator != 0L) {
                VkAllocationCallbacks.validate(pAllocator);
            }
        }
        JNI.callPJPV((long)instance.address(), (long)surface, (long)pAllocator, (long)__functionAddress);
    }

    public static void vkDestroySurfaceKHR(VkInstance instance, @NativeType(value="VkSurfaceKHR") long surface, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        KHRSurface.nvkDestroySurfaceKHR(instance, surface, MemoryUtil.memAddressSafe((Pointer)pAllocator));
    }

    public static int nvkGetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, int queueFamilyIndex, long surface, long pSupported) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceSupportKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)physicalDevice.address(), (int)queueFamilyIndex, (long)surface, (long)pSupported, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkBool32 *") IntBuffer pSupported) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSupported, (int)1);
        }
        return KHRSurface.nvkGetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, MemoryUtil.memAddress((IntBuffer)pSupported));
    }

    public static int nvkGetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, long surface, long pSurfaceCapabilities) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceCapabilitiesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)physicalDevice.address(), (long)surface, (long)pSurfaceCapabilities, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkSurfaceCapabilitiesKHR *") VkSurfaceCapabilitiesKHR pSurfaceCapabilities) {
        return KHRSurface.nvkGetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities.address());
    }

    public static int nvkGetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, long surface, long pSurfaceFormatCount, long pSurfaceFormats) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceFormatsKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)physicalDevice.address(), (long)surface, (long)pSurfaceFormatCount, (long)pSurfaceFormats, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") IntBuffer pSurfaceFormatCount, @Nullable @NativeType(value="VkSurfaceFormatKHR *") VkSurfaceFormatKHR.Buffer pSurfaceFormats) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurfaceFormatCount, (int)1);
            Checks.checkSafe((CustomBuffer)pSurfaceFormats, (int)pSurfaceFormatCount.get(pSurfaceFormatCount.position()));
        }
        return KHRSurface.nvkGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, MemoryUtil.memAddress((IntBuffer)pSurfaceFormatCount), MemoryUtil.memAddressSafe((Pointer)pSurfaceFormats));
    }

    public static int nvkGetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, long surface, long pPresentModeCount, long pPresentModes) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfacePresentModesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)physicalDevice.address(), (long)surface, (long)pPresentModeCount, (long)pPresentModes, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") IntBuffer pPresentModeCount, @Nullable @NativeType(value="VkPresentModeKHR *") IntBuffer pPresentModes) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPresentModeCount, (int)1);
            Checks.checkSafe((Buffer)pPresentModes, (int)pPresentModeCount.get(pPresentModeCount.position()));
        }
        return KHRSurface.nvkGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, MemoryUtil.memAddress((IntBuffer)pPresentModeCount), MemoryUtil.memAddressSafe((IntBuffer)pPresentModes));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t") int queueFamilyIndex, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkBool32 *") int[] pSupported) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceSupportKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pSupported, (int)1);
        }
        return JNI.callPJPI((long)physicalDevice.address(), (int)queueFamilyIndex, (long)surface, (int[])pSupported, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") int[] pSurfaceFormatCount, @Nullable @NativeType(value="VkSurfaceFormatKHR *") VkSurfaceFormatKHR.Buffer pSurfaceFormats) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfaceFormatsKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pSurfaceFormatCount, (int)1);
            Checks.checkSafe((CustomBuffer)pSurfaceFormats, (int)pSurfaceFormatCount[0]);
        }
        return JNI.callPJPPI((long)physicalDevice.address(), (long)surface, (int[])pSurfaceFormatCount, (long)MemoryUtil.memAddressSafe((Pointer)pSurfaceFormats), (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="uint32_t *") int[] pPresentModeCount, @Nullable @NativeType(value="VkPresentModeKHR *") int[] pPresentModes) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceSurfacePresentModesKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pPresentModeCount, (int)1);
            Checks.checkSafe((int[])pPresentModes, (int)pPresentModeCount[0]);
        }
        return JNI.callPJPPI((long)physicalDevice.address(), (long)surface, (int[])pPresentModeCount, (int[])pPresentModes, (long)__functionAddress);
    }
}

