/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSampleLocationsInfoEXT;

public class VkAttachmentSampleLocationsEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ATTACHMENTINDEX;
    public static final int SAMPLELOCATIONSINFO;

    public VkAttachmentSampleLocationsEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAttachmentSampleLocationsEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int attachmentIndex() {
        return VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address());
    }

    public VkSampleLocationsInfoEXT sampleLocationsInfo() {
        return VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address());
    }

    public VkAttachmentSampleLocationsEXT sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
        consumer.accept(this.sampleLocationsInfo());
        return this;
    }

    public VkAttachmentSampleLocationsEXT attachmentIndex(@NativeType(value="uint32_t") int value) {
        VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address(), value);
        return this;
    }

    public VkAttachmentSampleLocationsEXT sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
        VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
        return this;
    }

    public VkAttachmentSampleLocationsEXT set(int attachmentIndex, VkSampleLocationsInfoEXT sampleLocationsInfo) {
        this.attachmentIndex(attachmentIndex);
        this.sampleLocationsInfo(sampleLocationsInfo);
        return this;
    }

    public VkAttachmentSampleLocationsEXT set(VkAttachmentSampleLocationsEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAttachmentSampleLocationsEXT malloc() {
        return (VkAttachmentSampleLocationsEXT)VkAttachmentSampleLocationsEXT.wrap(VkAttachmentSampleLocationsEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkAttachmentSampleLocationsEXT calloc() {
        return (VkAttachmentSampleLocationsEXT)VkAttachmentSampleLocationsEXT.wrap(VkAttachmentSampleLocationsEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkAttachmentSampleLocationsEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkAttachmentSampleLocationsEXT)VkAttachmentSampleLocationsEXT.wrap(VkAttachmentSampleLocationsEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkAttachmentSampleLocationsEXT create(long address) {
        return (VkAttachmentSampleLocationsEXT)VkAttachmentSampleLocationsEXT.wrap(VkAttachmentSampleLocationsEXT.class, (long)address);
    }

    @Nullable
    public static VkAttachmentSampleLocationsEXT createSafe(long address) {
        return address == 0L ? null : (VkAttachmentSampleLocationsEXT)VkAttachmentSampleLocationsEXT.wrap(VkAttachmentSampleLocationsEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkAttachmentSampleLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkAttachmentSampleLocationsEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkAttachmentSampleLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentSampleLocationsEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkAttachmentSampleLocationsEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkAttachmentSampleLocationsEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkAttachmentSampleLocationsEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkAttachmentSampleLocationsEXT mallocStack() {
        return VkAttachmentSampleLocationsEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentSampleLocationsEXT callocStack() {
        return VkAttachmentSampleLocationsEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkAttachmentSampleLocationsEXT mallocStack(MemoryStack stack) {
        return (VkAttachmentSampleLocationsEXT)VkAttachmentSampleLocationsEXT.wrap(VkAttachmentSampleLocationsEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentSampleLocationsEXT callocStack(MemoryStack stack) {
        return (VkAttachmentSampleLocationsEXT)VkAttachmentSampleLocationsEXT.wrap(VkAttachmentSampleLocationsEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAttachmentSampleLocationsEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAttachmentSampleLocationsEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAttachmentSampleLocationsEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAttachmentSampleLocationsEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nattachmentIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTINDEX);
    }

    public static VkSampleLocationsInfoEXT nsampleLocationsInfo(long struct) {
        return VkSampleLocationsInfoEXT.create(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void nattachmentIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTINDEX, value);
    }

    public static void nsampleLocationsInfo(long struct, VkSampleLocationsInfoEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SAMPLELOCATIONSINFO), (long)VkSampleLocationsInfoEXT.SIZEOF);
    }

    public static void validate(long struct) {
        VkSampleLocationsInfoEXT.validate(struct + (long)SAMPLELOCATIONSINFO);
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkAttachmentSampleLocationsEXT.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkAttachmentSampleLocationsEXT.__struct((Struct.Member[])new Struct.Member[]{VkAttachmentSampleLocationsEXT.__member((int)4), VkAttachmentSampleLocationsEXT.__member((int)VkSampleLocationsInfoEXT.SIZEOF, (int)VkSampleLocationsInfoEXT.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ATTACHMENTINDEX = layout.offsetof(0);
        SAMPLELOCATIONSINFO = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentSampleLocationsEXT, Buffer>
    implements NativeResource {
        private static final VkAttachmentSampleLocationsEXT ELEMENT_FACTORY = VkAttachmentSampleLocationsEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAttachmentSampleLocationsEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int attachmentIndex() {
            return VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address());
        }

        public VkSampleLocationsInfoEXT sampleLocationsInfo() {
            return VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address());
        }

        public Buffer sampleLocationsInfo(Consumer<VkSampleLocationsInfoEXT> consumer) {
            consumer.accept(this.sampleLocationsInfo());
            return this;
        }

        public Buffer attachmentIndex(@NativeType(value="uint32_t") int value) {
            VkAttachmentSampleLocationsEXT.nattachmentIndex(this.address(), value);
            return this;
        }

        public Buffer sampleLocationsInfo(VkSampleLocationsInfoEXT value) {
            VkAttachmentSampleLocationsEXT.nsampleLocationsInfo(this.address(), value);
            return this;
        }
    }
}

