/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorSetLayoutSupport
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUPPORTED;

    public VkDescriptorSetLayoutSupport(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorSetLayoutSupport.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorSetLayoutSupport.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDescriptorSetLayoutSupport.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean supported() {
        return VkDescriptorSetLayoutSupport.nsupported(this.address()) != 0;
    }

    public VkDescriptorSetLayoutSupport sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetLayoutSupport.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutSupport pNext(@NativeType(value="void *") long value) {
        VkDescriptorSetLayoutSupport.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutSupport set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkDescriptorSetLayoutSupport set(VkDescriptorSetLayoutSupport src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutSupport malloc() {
        return (VkDescriptorSetLayoutSupport)VkDescriptorSetLayoutSupport.wrap(VkDescriptorSetLayoutSupport.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDescriptorSetLayoutSupport calloc() {
        return (VkDescriptorSetLayoutSupport)VkDescriptorSetLayoutSupport.wrap(VkDescriptorSetLayoutSupport.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDescriptorSetLayoutSupport create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDescriptorSetLayoutSupport)VkDescriptorSetLayoutSupport.wrap(VkDescriptorSetLayoutSupport.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDescriptorSetLayoutSupport create(long address) {
        return (VkDescriptorSetLayoutSupport)VkDescriptorSetLayoutSupport.wrap(VkDescriptorSetLayoutSupport.class, (long)address);
    }

    @Nullable
    public static VkDescriptorSetLayoutSupport createSafe(long address) {
        return address == 0L ? null : (VkDescriptorSetLayoutSupport)VkDescriptorSetLayoutSupport.wrap(VkDescriptorSetLayoutSupport.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDescriptorSetLayoutSupport.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDescriptorSetLayoutSupport.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDescriptorSetLayoutSupport.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorSetLayoutSupport.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDescriptorSetLayoutSupport.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDescriptorSetLayoutSupport.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDescriptorSetLayoutSupport.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDescriptorSetLayoutSupport mallocStack() {
        return VkDescriptorSetLayoutSupport.mallocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutSupport callocStack() {
        return VkDescriptorSetLayoutSupport.callocStack(MemoryStack.stackGet());
    }

    public static VkDescriptorSetLayoutSupport mallocStack(MemoryStack stack) {
        return (VkDescriptorSetLayoutSupport)VkDescriptorSetLayoutSupport.wrap(VkDescriptorSetLayoutSupport.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDescriptorSetLayoutSupport callocStack(MemoryStack stack) {
        return (VkDescriptorSetLayoutSupport)VkDescriptorSetLayoutSupport.wrap(VkDescriptorSetLayoutSupport.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutSupport.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutSupport.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDescriptorSetLayoutSupport.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDescriptorSetLayoutSupport.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsupported(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTED);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutSupport.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorSetLayoutSupport.__member((int)4), VkDescriptorSetLayoutSupport.__member((int)POINTER_SIZE), VkDescriptorSetLayoutSupport.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUPPORTED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutSupport, Buffer>
    implements NativeResource {
        private static final VkDescriptorSetLayoutSupport ELEMENT_FACTORY = VkDescriptorSetLayoutSupport.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDescriptorSetLayoutSupport getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorSetLayoutSupport.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDescriptorSetLayoutSupport.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean supported() {
            return VkDescriptorSetLayoutSupport.nsupported(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetLayoutSupport.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDescriptorSetLayoutSupport.npNext(this.address(), value);
            return this;
        }
    }
}

