/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageResolve
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCSUBRESOURCE;
    public static final int SRCOFFSET;
    public static final int DSTSUBRESOURCE;
    public static final int DSTOFFSET;
    public static final int EXTENT;

    public VkImageResolve(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageResolve.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkImageSubresourceLayers srcSubresource() {
        return VkImageResolve.nsrcSubresource(this.address());
    }

    public VkImageResolve srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.srcSubresource());
        return this;
    }

    public VkOffset3D srcOffset() {
        return VkImageResolve.nsrcOffset(this.address());
    }

    public VkImageResolve srcOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.srcOffset());
        return this;
    }

    public VkImageSubresourceLayers dstSubresource() {
        return VkImageResolve.ndstSubresource(this.address());
    }

    public VkImageResolve dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.dstSubresource());
        return this;
    }

    public VkOffset3D dstOffset() {
        return VkImageResolve.ndstOffset(this.address());
    }

    public VkImageResolve dstOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.dstOffset());
        return this;
    }

    public VkExtent3D extent() {
        return VkImageResolve.nextent(this.address());
    }

    public VkImageResolve extent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkImageResolve srcSubresource(VkImageSubresourceLayers value) {
        VkImageResolve.nsrcSubresource(this.address(), value);
        return this;
    }

    public VkImageResolve srcOffset(VkOffset3D value) {
        VkImageResolve.nsrcOffset(this.address(), value);
        return this;
    }

    public VkImageResolve dstSubresource(VkImageSubresourceLayers value) {
        VkImageResolve.ndstSubresource(this.address(), value);
        return this;
    }

    public VkImageResolve dstOffset(VkOffset3D value) {
        VkImageResolve.ndstOffset(this.address(), value);
        return this;
    }

    public VkImageResolve extent(VkExtent3D value) {
        VkImageResolve.nextent(this.address(), value);
        return this;
    }

    public VkImageResolve set(VkImageSubresourceLayers srcSubresource, VkOffset3D srcOffset, VkImageSubresourceLayers dstSubresource, VkOffset3D dstOffset, VkExtent3D extent) {
        this.srcSubresource(srcSubresource);
        this.srcOffset(srcOffset);
        this.dstSubresource(dstSubresource);
        this.dstOffset(dstOffset);
        this.extent(extent);
        return this;
    }

    public VkImageResolve set(VkImageResolve src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageResolve malloc() {
        return (VkImageResolve)VkImageResolve.wrap(VkImageResolve.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageResolve calloc() {
        return (VkImageResolve)VkImageResolve.wrap(VkImageResolve.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageResolve create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageResolve)VkImageResolve.wrap(VkImageResolve.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageResolve create(long address) {
        return (VkImageResolve)VkImageResolve.wrap(VkImageResolve.class, (long)address);
    }

    @Nullable
    public static VkImageResolve createSafe(long address) {
        return address == 0L ? null : (VkImageResolve)VkImageResolve.wrap(VkImageResolve.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageResolve.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageResolve.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageResolve.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageResolve.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageResolve.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageResolve.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageResolve.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageResolve mallocStack() {
        return VkImageResolve.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageResolve callocStack() {
        return VkImageResolve.callocStack(MemoryStack.stackGet());
    }

    public static VkImageResolve mallocStack(MemoryStack stack) {
        return (VkImageResolve)VkImageResolve.wrap(VkImageResolve.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageResolve callocStack(MemoryStack stack) {
        return (VkImageResolve)VkImageResolve.wrap(VkImageResolve.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageResolve.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageResolve.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageResolve.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageResolve.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkImageSubresourceLayers nsrcSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)SRCSUBRESOURCE);
    }

    public static VkOffset3D nsrcOffset(long struct) {
        return VkOffset3D.create(struct + (long)SRCOFFSET);
    }

    public static VkImageSubresourceLayers ndstSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)DSTSUBRESOURCE);
    }

    public static VkOffset3D ndstOffset(long struct) {
        return VkOffset3D.create(struct + (long)DSTOFFSET);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static void nsrcSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRCSUBRESOURCE), (long)VkImageSubresourceLayers.SIZEOF);
    }

    public static void nsrcOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRCOFFSET), (long)VkOffset3D.SIZEOF);
    }

    public static void ndstSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DSTSUBRESOURCE), (long)VkImageSubresourceLayers.SIZEOF);
    }

    public static void ndstOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DSTOFFSET), (long)VkOffset3D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageResolve.__struct((Struct.Member[])new Struct.Member[]{VkImageResolve.__member((int)VkImageSubresourceLayers.SIZEOF, (int)VkImageSubresourceLayers.ALIGNOF), VkImageResolve.__member((int)VkOffset3D.SIZEOF, (int)VkOffset3D.ALIGNOF), VkImageResolve.__member((int)VkImageSubresourceLayers.SIZEOF, (int)VkImageSubresourceLayers.ALIGNOF), VkImageResolve.__member((int)VkOffset3D.SIZEOF, (int)VkOffset3D.ALIGNOF), VkImageResolve.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCSUBRESOURCE = layout.offsetof(0);
        SRCOFFSET = layout.offsetof(1);
        DSTSUBRESOURCE = layout.offsetof(2);
        DSTOFFSET = layout.offsetof(3);
        EXTENT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageResolve, Buffer>
    implements NativeResource {
        private static final VkImageResolve ELEMENT_FACTORY = VkImageResolve.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageResolve getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkImageSubresourceLayers srcSubresource() {
            return VkImageResolve.nsrcSubresource(this.address());
        }

        public Buffer srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.srcSubresource());
            return this;
        }

        public VkOffset3D srcOffset() {
            return VkImageResolve.nsrcOffset(this.address());
        }

        public Buffer srcOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.srcOffset());
            return this;
        }

        public VkImageSubresourceLayers dstSubresource() {
            return VkImageResolve.ndstSubresource(this.address());
        }

        public Buffer dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.dstSubresource());
            return this;
        }

        public VkOffset3D dstOffset() {
            return VkImageResolve.ndstOffset(this.address());
        }

        public Buffer dstOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.dstOffset());
            return this;
        }

        public VkExtent3D extent() {
            return VkImageResolve.nextent(this.address());
        }

        public Buffer extent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        public Buffer srcSubresource(VkImageSubresourceLayers value) {
            VkImageResolve.nsrcSubresource(this.address(), value);
            return this;
        }

        public Buffer srcOffset(VkOffset3D value) {
            VkImageResolve.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstSubresource(VkImageSubresourceLayers value) {
            VkImageResolve.ndstSubresource(this.address(), value);
            return this;
        }

        public Buffer dstOffset(VkOffset3D value) {
            VkImageResolve.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageResolve.nextent(this.address(), value);
            return this;
        }
    }
}

