/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.features;

import io.ktor.application.ApplicationCall;
import io.ktor.features.CallId;
import io.ktor.features.CallIdKt;
import io.ktor.features.CallLogging;
import io.ktor.util.CharsetKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0001\u001a\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0001H\u0002\u001a\u001e\u0010\u0011\u001a\u00020\u000b*\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0001\u001a\u001c\u0010\u0016\u001a\u00020\u0001*\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005*D\u0010\u0018\"\u001f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\r\u0012\u0004\b\b(\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00192\u001f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001a\u0012\b\b\r\u0012\u0004\b\b(\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019*\"\u0010\u001c\"\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00192\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0019\u00a8\u0006\u001d"}, d2={"CALL_ID_DEFAULT_DICTIONARY", "", "callId", "Lio/ktor/application/ApplicationCall;", "getCallId", "(Lio/ktor/application/ApplicationCall;)Ljava/lang/String;", "verifyCallIdAgainstDictionary", "", "sortedDictionary", "", "callIdMdc", "", "Lio/ktor/features/CallLogging$Configuration;", "name", "duplicates", "", "", "generate", "Lio/ktor/features/CallId$Configuration;", "length", "", "dictionary", "nextString", "Lkotlin/random/Random;", "CallIdProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "call", "CallIdVerifier", "ktor-server-core"})
public final class CallIdKt {
    @NotNull
    public static final String CALL_ID_DEFAULT_DICTIONARY = "abcdefghijklmnopqrstuvwxyz0123456789+/=-";

    @Nullable
    public static final String getCallId(@NotNull ApplicationCall $this$callId) {
        Intrinsics.checkNotNullParameter((Object)$this$callId, (String)"<this>");
        return (String)$this$callId.getAttributes().getOrNull(CallId.Feature.getCallIdKey$ktor_server_core());
    }

    public static final void generate(@NotNull CallId.Configuration $this$generate, int length, @NotNull String dictionary) {
        Intrinsics.checkNotNullParameter((Object)$this$generate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        if (!(length >= 1)) {
            boolean $i$a$-require-CallIdKt$generate$42 = false;
            String $i$a$-require-CallIdKt$generate$42 = Intrinsics.stringPlus((String)"Call id should be at least one characters length: ", (Object)length);
            throw new IllegalArgumentException($i$a$-require-CallIdKt$generate$42.toString());
        }
        if (!(dictionary.length() > 1)) {
            boolean bl = false;
            String string = "Dictionary should consist of several different characters";
            throw new IllegalArgumentException(string.toString());
        }
        char[] dictionaryCharacters = CollectionsKt.toCharArray((Collection)ArraysKt.distinct((char[])CharsetKt.toCharArray((String)dictionary)));
        if (!(dictionaryCharacters.length == dictionary.length())) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Dictionary should not contain duplicates, found: ", CallIdKt.duplicates(dictionary));
            throw new IllegalArgumentException(string.toString());
        }
        $this$generate.generate((Function1<? super ApplicationCall, String>)((Function1)new Function1<ApplicationCall, String>(length, dictionaryCharacters){
            final /* synthetic */ int $length;
            final /* synthetic */ char[] $dictionaryCharacters;
            {
                this.$length = $length;
                this.$dictionaryCharacters = $dictionaryCharacters;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull ApplicationCall it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CallIdKt.access$nextString((Random)Random.Default, this.$length, this.$dictionaryCharacters);
            }
        }));
    }

    public static /* synthetic */ void generate$default(CallId.Configuration configuration, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        if ((n2 & 2) != 0) {
            string = CALL_ID_DEFAULT_DICTIONARY;
        }
        CallIdKt.generate(configuration, n, string);
    }

    public static final void callIdMdc(@NotNull CallLogging.Configuration $this$callIdMdc, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$callIdMdc, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        $this$callIdMdc.mdc(name, (Function1<? super ApplicationCall, String>)((Function1)callIdMdc.1.INSTANCE));
    }

    public static /* synthetic */ void callIdMdc$default(CallLogging.Configuration configuration, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "CallId";
        }
        CallIdKt.callIdMdc(configuration, string);
    }

    private static final boolean verifyCallIdAgainstDictionary(String callId, char[] sortedDictionary) {
        int n = 0;
        int n2 = callId.length();
        while (n < n2) {
            int index;
            if (ArraysKt.binarySearch((char[])sortedDictionary, (char)callId.charAt(index = n++), (int)0, (int)sortedDictionary.length) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Character> duplicates(String $this$duplicates) {
        void $this$groupByTo$iv$iv;
        char[] $this$groupBy$iv = CharsetKt.toCharArray((String)$this$duplicates);
        boolean $i$f$groupBy = false;
        char[] cArray = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        void var6_7 = $this$groupByTo$iv$iv;
        int n = 0;
        int n2 = ((void)var6_7).length;
        while (n < n2) {
            Object object;
            void element$iv$iv = var6_7[n];
            ++n;
            void it = element$iv$iv;
            boolean bl = false;
            Character key$iv$iv = Character.valueOf((char)it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(Character.valueOf((char)element$iv$iv));
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return CollectionsKt.sorted((Iterable)((Map)result$iv).keySet());
    }

    private static final String nextString(Random $this$nextString, int length, char[] dictionary) {
        char[] chars = new char[length];
        int dictionarySize = dictionary.length;
        int n = 0;
        while (n < length) {
            int index = n++;
            chars[index] = dictionary[$this$nextString.nextInt(dictionarySize)];
        }
        return new String(chars);
    }

    public static final /* synthetic */ boolean access$verifyCallIdAgainstDictionary(String callId, char[] sortedDictionary) {
        return CallIdKt.verifyCallIdAgainstDictionary(callId, sortedDictionary);
    }

    public static final /* synthetic */ String access$nextString(Random $receiver, int length, char[] dictionary) {
        return CallIdKt.nextString($receiver, length, dictionary);
    }
}

