/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.routing;

import io.ktor.application.ApplicationCall;
import io.ktor.features.BadRequestException;
import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.URLDecodeException;
import io.ktor.request.ApplicationRequestPropertiesKt;
import io.ktor.routing.IgnoreTrailingSlashKt;
import io.ktor.routing.Route;
import io.ktor.routing.RouteSelectorEvaluation;
import io.ktor.routing.RoutingResolveResult;
import io.ktor.routing.RoutingResolveTrace;
import io.ktor.util.StringValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00070\u0007H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u00072\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\u0006\u0010 \u001a\u00020\u001aJ:\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00032\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00070#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00072\u0006\u0010%\u001a\u00020&H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/ktor/routing/RoutingResolveContext;", "", "routing", "Lio/ktor/routing/Route;", "call", "Lio/ktor/application/ApplicationCall;", "tracers", "", "Lkotlin/Function1;", "Lio/ktor/routing/RoutingResolveTrace;", "", "(Lio/ktor/routing/Route;Lio/ktor/application/ApplicationCall;Ljava/util/List;)V", "getCall", "()Lio/ktor/application/ApplicationCall;", "hasTrailingSlash", "", "getHasTrailingSlash", "()Z", "getRouting", "()Lio/ktor/routing/Route;", "segments", "", "getSegments", "()Ljava/util/List;", "trace", "findBestRoute", "Lio/ktor/routing/RoutingResolveResult;", "root", "successResults", "Lio/ktor/routing/RoutingResolveResult$Success;", "parse", "path", "resolve", "resolveStep", "entry", "", "trait", "segmentIndex", "", "ktor-server-core"})
public final class RoutingResolveContext {
    @NotNull
    private final Route routing;
    @NotNull
    private final ApplicationCall call;
    @NotNull
    private final List<Function1<RoutingResolveTrace, Unit>> tracers;
    @NotNull
    private final List<String> segments;
    private final boolean hasTrailingSlash;
    @Nullable
    private final RoutingResolveTrace trace;

    public RoutingResolveContext(@NotNull Route routing, @NotNull ApplicationCall call, @NotNull List<? extends Function1<? super RoutingResolveTrace, Unit>> tracers) {
        Intrinsics.checkNotNullParameter((Object)((Object)routing), (String)"routing");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(tracers, (String)"tracers");
        this.routing = routing;
        this.call = call;
        this.tracers = tracers;
        this.hasTrailingSlash = StringsKt.endsWith$default((CharSequence)ApplicationRequestPropertiesKt.path(this.call.getRequest()), (char)'/', (boolean)false, (int)2, null);
        try {
            this.segments = this.parse(ApplicationRequestPropertiesKt.path(this.call.getRequest()));
            this.trace = this.tracers.isEmpty() ? null : new RoutingResolveTrace(this.call, this.segments);
        }
        catch (URLDecodeException cause) {
            throw new BadRequestException(Intrinsics.stringPlus((String)"Url decode failed for ", (Object)ApplicationRequestPropertiesKt.getUri(this.call.getRequest())), cause);
        }
    }

    @NotNull
    public final Route getRouting() {
        return this.routing;
    }

    @NotNull
    public final ApplicationCall getCall() {
        return this.call;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    public final boolean getHasTrailingSlash() {
        return this.hasTrailingSlash;
    }

    private final List<String> parse(String path) {
        if (((CharSequence)path).length() == 0 || Intrinsics.areEqual((Object)path, (Object)"/")) {
            return CollectionsKt.emptyList();
        }
        int length = path.length();
        int beginSegment = 0;
        int nextSegment = 0;
        CharSequence $this$count$iv = path;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv = charSequence.charAt(i);
            char it = element$iv;
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int segmentCount = count$iv;
        ArrayList<String> segments2 = new ArrayList<String>(segmentCount);
        while (nextSegment < length) {
            nextSegment = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)beginSegment, (boolean)false, (int)4, null);
            if (nextSegment == -1) {
                nextSegment = length;
            }
            if (nextSegment == beginSegment) {
                beginSegment = nextSegment + 1;
                continue;
            }
            String segment = CodecsKt.decodeURLPart$default((String)path, (int)beginSegment, (int)nextSegment, null, (int)4, null);
            segments2.add(segment);
            beginSegment = nextSegment + 1;
        }
        if (!IgnoreTrailingSlashKt.getIgnoreTrailingSlash(this.call) && StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            segments2.add("");
        }
        return segments2;
    }

    @NotNull
    public final RoutingResolveResult resolve() {
        Route root = this.routing;
        RouteSelectorEvaluation rootEvaluation = root.getSelector().evaluate(this, 0);
        if (!rootEvaluation.getSucceeded()) {
            RoutingResolveResult.Failure result = new RoutingResolveResult.Failure(root, "rootPath didn't match");
            RoutingResolveTrace routingResolveTrace = this.trace;
            if (routingResolveTrace != null) {
                routingResolveTrace.skip(root, 0, result);
            }
            return result;
        }
        List successResults = new ArrayList();
        RoutingResolveResult.Success rootResolveResult = new RoutingResolveResult.Success(root, rootEvaluation.getParameters(), rootEvaluation.getQuality());
        List rootTrait = CollectionsKt.listOf((Object)rootResolveResult);
        RoutingResolveTrace routingResolveTrace = this.trace;
        if (routingResolveTrace != null) {
            routingResolveTrace.begin(root, 0);
        }
        this.resolveStep(root, successResults, rootTrait, rootEvaluation.getSegmentIncrement());
        RoutingResolveTrace routingResolveTrace2 = this.trace;
        if (routingResolveTrace2 != null) {
            routingResolveTrace2.finish(root, 0, rootResolveResult);
        }
        RoutingResolveTrace routingResolveTrace3 = this.trace;
        if (routingResolveTrace3 != null) {
            routingResolveTrace3.registerSuccessResults(successResults);
        }
        RoutingResolveResult resolveResult = this.findBestRoute(root, successResults);
        RoutingResolveTrace routingResolveTrace4 = this.trace;
        if (routingResolveTrace4 != null) {
            routingResolveTrace4.registerFinalResult(resolveResult);
        }
        RoutingResolveTrace routingResolveTrace5 = this.trace;
        if (routingResolveTrace5 != null) {
            RoutingResolveTrace routingResolveTrace6;
            RoutingResolveTrace $this$resolve_u24lambda_u2d2 = routingResolveTrace6 = routingResolveTrace5;
            boolean bl = false;
            Iterable $this$forEach$iv = this.tracers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl2 = false;
                it.invoke((Object)$this$resolve_u24lambda_u2d2);
            }
        }
        return resolveResult;
    }

    private final boolean resolveStep(Route entry, List<List<RoutingResolveResult.Success>> successResults, List<RoutingResolveResult.Success> trait, int segmentIndex) {
        boolean matched = false;
        if (entry.getChildren().isEmpty() && segmentIndex != this.segments.size()) {
            RoutingResolveTrace routingResolveTrace = this.trace;
            if (routingResolveTrace != null) {
                routingResolveTrace.skip(entry, segmentIndex, new RoutingResolveResult.Failure(entry, "Not all segments matched"));
            }
            return false;
        }
        if (!((Collection)entry.getHandlers$ktor_server_core()).isEmpty() && segmentIndex == this.segments.size()) {
            successResults.add(trait);
            matched = true;
        }
        double bestSucceedChildQuality = -1.7976931348623157E308;
        int n = 0;
        int n2 = CollectionsKt.getLastIndex(entry.getChildren());
        if (n <= n2) {
            int childIndex;
            do {
                childIndex = n++;
                Route child = entry.getChildren().get(childIndex);
                RouteSelectorEvaluation childEvaluation = child.getSelector().evaluate(this, segmentIndex);
                if (!childEvaluation.getSucceeded()) {
                    RoutingResolveTrace routingResolveTrace = this.trace;
                    if (routingResolveTrace == null) continue;
                    routingResolveTrace.skip(child, segmentIndex, new RoutingResolveResult.Failure(child, "Selector didn't match"));
                    continue;
                }
                if (!(childEvaluation.getQuality() == -1.0) && childEvaluation.getQuality() < bestSucceedChildQuality) {
                    RoutingResolveTrace routingResolveTrace = this.trace;
                    if (routingResolveTrace == null) continue;
                    routingResolveTrace.skip(child, segmentIndex, new RoutingResolveResult.Failure(child, "Better match was already found"));
                    continue;
                }
                RoutingResolveResult.Success result = new RoutingResolveResult.Success(child, childEvaluation.getParameters(), childEvaluation.getQuality());
                int newIndex = segmentIndex + childEvaluation.getSegmentIncrement();
                RoutingResolveTrace routingResolveTrace = this.trace;
                if (routingResolveTrace != null) {
                    routingResolveTrace.begin(child, newIndex);
                }
                boolean success = this.resolveStep(child, successResults, CollectionsKt.plus((Collection)trait, (Object)result), newIndex);
                RoutingResolveTrace routingResolveTrace2 = this.trace;
                if (routingResolveTrace2 != null) {
                    routingResolveTrace2.finish(child, newIndex, result);
                }
                if (success && bestSucceedChildQuality < result.getQuality$ktor_server_core()) {
                    bestSucceedChildQuality = childEvaluation.getQuality();
                }
                boolean bl = matched = matched || success;
            } while (childIndex != n2);
        }
        return matched;
    }

    /*
     * WARNING - void declaration
     */
    private final RoutingResolveResult findBestRoute(Route root, List<? extends List<RoutingResolveResult.Success>> successResults) {
        double d;
        void $this$fold$iv;
        if (successResults.isEmpty()) {
            return new RoutingResolveResult.Failure(root, "No matched subtrees found");
        }
        Object object = CollectionsKt.maxWithOrNull((Iterable)successResults, RoutingResolveContext::findBestRoute$lambda-5);
        Intrinsics.checkNotNull((Object)object);
        List bestPath = (List)object;
        Iterable iterable = bestPath;
        ParametersBuilder initial$iv = new ParametersBuilder(0, null, 3, null);
        boolean $i$f$fold = false;
        ParametersBuilder accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void result;
            ParametersBuilder parametersBuilder;
            RoutingResolveResult.Success success = (RoutingResolveResult.Success)element$iv;
            ParametersBuilder builder = accumulator$iv;
            boolean bl = false;
            ParametersBuilder $this$findBestRoute_u24lambda_u2d7_u24lambda_u2d6 = parametersBuilder = builder;
            boolean bl2 = false;
            $this$findBestRoute_u24lambda_u2d7_u24lambda_u2d6.appendAll((StringValues)result.getParameters());
            accumulator$iv = parametersBuilder;
        }
        Parameters parameters2 = accumulator$iv.build();
        iterable = bestPath;
        Parameters parameters3 = parameters2;
        Route route = ((RoutingResolveResult.Success)CollectionsKt.last((List)bestPath)).getRoute();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        RoutingResolveResult.Success result = (RoutingResolveResult.Success)iterator.next();
        boolean bl = false;
        double d2 = result.getQuality$ktor_server_core() == -1.0 ? 1.0 : result.getQuality$ktor_server_core();
        while (iterator.hasNext()) {
            RoutingResolveResult.Success result2 = (RoutingResolveResult.Success)iterator.next();
            $i$a$-minOf-RoutingResolveContext$findBestRoute$1 = false;
            double d3 = result2.getQuality$ktor_server_core() == -1.0 ? 1.0 : result2.getQuality$ktor_server_core();
            d2 = Math.min(d2, d3);
        }
        double d4 = d = d2;
        Parameters parameters4 = parameters3;
        Route route2 = route;
        return new RoutingResolveResult.Success(route2, parameters4, d4);
    }

    private static final int findBestRoute$lambda-5(List result1, List result2) {
        int n;
        RoutingResolveResult.Success it;
        int n2;
        int index1 = 0;
        int index2 = 0;
        while (index1 < result1.size() && index2 < result2.size()) {
            int n3;
            double quality1 = ((RoutingResolveResult.Success)result1.get(index1)).getQuality$ktor_server_core();
            double quality2 = ((RoutingResolveResult.Success)result2.get(index2)).getQuality$ktor_server_core();
            if (quality1 == -1.0) {
                n3 = index1;
                index1 = n3 + 1;
                continue;
            }
            if (quality2 == -1.0) {
                n3 = index2;
                index2 = n3 + 1;
                continue;
            }
            if (!(quality1 == quality2)) {
                return ComparisonsKt.compareValues((Comparable)Double.valueOf(quality1), (Comparable)Double.valueOf(quality2));
            }
            n3 = index1;
            index1 = n3 + 1;
            n3 = index2;
            index2 = n3 + 1;
        }
        Intrinsics.checkNotNullExpressionValue((Object)result1, (String)"result1");
        Iterable $this$count$iv = result1;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (RoutingResolveResult.Success)element$iv;
                boolean bl = false;
                if (!(!(it.getQuality$ktor_server_core() == -1.0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        Comparable comparable = Integer.valueOf(n2);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result2");
        $this$count$iv = result2;
        Comparable comparable2 = comparable;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (RoutingResolveResult.Success)element$iv;
                boolean bl = false;
                if (!(!(it.getQuality$ktor_server_core() == -1.0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n4 = n;
        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(n4));
    }
}

