/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.algebra.MatrixRescaler;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_happly;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ipvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_pvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_qr;
import edu.emory.mathcs.csparsej.tdouble.Dcs_sqr;
import edu.emory.mathcs.csparsej.tdouble.Dcs_usolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_utsolve;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class QRSparseFactorization {
    private SparseDoubleMatrix2D A;
    private int order;
    private MatrixRescaler rescaler = null;
    private DoubleMatrix1D U;
    private DoubleMatrix1D V;
    private Dcs_common.Dcss S;
    private Dcs_common.Dcsn N;
    private DoubleMatrix2D R;
    private int m;
    private int n;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    private Algebra ALG = Algebra.DEFAULT;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public QRSparseFactorization(SparseDoubleMatrix2D A) throws Exception {
        this(A, 0, null);
    }

    public QRSparseFactorization(SparseDoubleMatrix2D A, int order) throws Exception {
        this(A, order, null);
    }

    public QRSparseFactorization(SparseDoubleMatrix2D A, MatrixRescaler rescaler) throws Exception {
        this(A, 0, rescaler);
    }

    public QRSparseFactorization(SparseDoubleMatrix2D A, int order, MatrixRescaler rescaler) throws Exception {
        if (order < 0 || order > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        this.A = A;
        this.order = order;
        this.rescaler = rescaler;
    }

    public void factorize() throws Exception {
        this.m = this.A.rows();
        this.n = this.A.columns();
        if (this.rescaler != null) {
            boolean checkOK;
            double[] cn_00_original = null;
            double[] cn_2_original = null;
            double[] cn_00_scaled = null;
            double[] cn_2_scaled = null;
            if (this.log.isDebugEnabled()) {
                cn_00_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(this.A.toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_original Q before scaling: " + ArrayUtils.toString((Object)cn_00_original)));
                cn_2_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(this.A.toArray()), 2);
                this.log.debug((Object)("cn_2_original Q before scaling : " + ArrayUtils.toString((Object)cn_2_original)));
            }
            DoubleMatrix1D[] UV = this.rescaler.getMatrixScalingFactors(this.A);
            this.U = UV[0];
            this.V = UV[1];
            if (this.log.isDebugEnabled() && !(checkOK = this.rescaler.checkScaling(this.A, this.U, this.V))) {
                this.log.warn((Object)"Scaling failed (checkScaling = false)");
            }
            this.A = (SparseDoubleMatrix2D)ColtUtils.diagonalMatrixMult(this.U, this.A, this.V);
            if (this.log.isDebugEnabled()) {
                cn_00_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(this.A.toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_scaled Q after scaling : " + ArrayUtils.toString((Object)cn_00_scaled)));
                cn_2_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(this.A.toArray()), 2);
                this.log.debug((Object)("cn_2_scaled Q after scaling  : " + ArrayUtils.toString((Object)cn_2_scaled)));
                if (cn_00_original[0] < cn_00_scaled[0] || cn_2_original[0] < cn_2_scaled[0]) {
                    this.log.warn((Object)"Problematic scaling");
                }
            }
        }
        Dcs_common.Dcs dcs = this.m >= this.n ? ColtUtils.matrixToDcs(this.A) : ColtUtils.matrixToDcs((SparseDoubleMatrix2D)this.ALG.transpose(this.A));
        this.S = Dcs_sqr.cs_sqr((int)this.order, (Dcs_common.Dcs)dcs, (boolean)true);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Dcs_qr.cs_qr((Dcs_common.Dcs)dcs, (Dcs_common.Dcss)this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_qr()");
        }
    }

    public DoubleMatrix2D getR() {
        if (this.rescaler == null) {
            if (this.R == null) {
                this.R = ColtUtils.dcsToMatrix(this.N.U);
            }
            return this.R;
        }
        throw new RuntimeException("not implemented");
    }

    public DoubleMatrix2D getQ() {
        if (this.rescaler == null) {
            throw new RuntimeException("Not yet implemented");
        }
        throw new RuntimeException("not implemented");
    }

    public boolean hasFullRank() {
        int mn = Math.min(this.m, this.n);
        double radqmxn = Math.sqrt(this.m * this.n);
        double threshold = Utils.getDoubleMachineEpsilon();
        Dcs_common.Dcs NU = this.N.U;
        for (int j = 0; j < mn; ++j) {
            double rjj = this.getQuick(NU, j, j);
            if (!(Math.abs(rjj) < threshold)) continue;
            this.log.debug((Object)("rjj: " + rjj));
            return false;
        }
        return true;
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b) {
        if (!this.hasFullRank()) {
            this.log.error((Object)("Matrix is rank deficient: " + ArrayUtils.toString((Object)this.A.toArray())));
            throw new IllegalArgumentException("Matrix is rank deficient");
        }
        if (this.rescaler != null) {
            b = ColtUtils.diagonalMatrixMult(this.U, b);
        }
        double[] bdata = b.toArray();
        double[] x = new double[this.n];
        System.arraycopy(bdata, 0, x, 0, bdata.length);
        if (this.m >= this.n) {
            double[] y = new double[this.S != null ? this.S.m2 : 1];
            Dcs_ipvec.cs_ipvec((int[])this.S.pinv, (double[])x, (double[])y, (int)this.m);
            for (int k = 0; k < this.n; ++k) {
                Dcs_happly.cs_happly((Dcs_common.Dcs)this.N.L, (int)k, (double)this.N.B[k], (double[])y);
            }
            Dcs_usolve.cs_usolve((Dcs_common.Dcs)this.N.U, (double[])y);
            Dcs_ipvec.cs_ipvec((int[])this.S.q, (double[])y, (double[])x, (int)this.n);
        } else {
            double[] y = new double[this.S != null ? this.S.m2 : 1];
            Dcs_pvec.cs_pvec((int[])this.S.q, (double[])x, (double[])y, (int)this.m);
            Dcs_utsolve.cs_utsolve((Dcs_common.Dcs)this.N.U, (double[])y);
            for (int k = this.m - 1; k >= 0; --k) {
                Dcs_happly.cs_happly((Dcs_common.Dcs)this.N.L, (int)k, (double)this.N.B[k], (double[])y);
            }
            Dcs_pvec.cs_pvec((int[])this.S.pinv, (double[])y, (double[])x, (int)this.n);
        }
        if (this.rescaler != null) {
            return ColtUtils.diagonalMatrixMult(this.V, this.F1.make(x));
        }
        return this.F1.make(x);
    }

    private double getQuick(Dcs_common.Dcs dcs, int row, int column) {
        int k = this.searchFromTo(dcs.i, row, dcs.p[column], dcs.p[column + 1] - 1);
        double v = 0.0;
        if (k >= 0) {
            v = dcs.x[k];
        }
        return v;
    }

    private int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }
}

