/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.functions;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.functions.BarrierFunction;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.FunctionsUtils;
import com.joptimizer.util.Utils;

public class LogarithmicBarrier
implements BarrierFunction {
    final Algebra ALG = Algebra.DEFAULT;
    final DoubleFactory1D F1 = DoubleFactory1D.dense;
    final DoubleFactory2D F2 = DoubleFactory2D.dense;
    private ConvexMultivariateRealFunction[] fi = null;
    private int dim = -1;

    public LogarithmicBarrier(ConvexMultivariateRealFunction[] fi, int dim) {
        this.fi = fi;
        this.dim = dim;
    }

    public double value(double[] X) {
        double psi = 0.0;
        for (int j = 0; j < this.fi.length; ++j) {
            double ineqValuejX = this.fi[j].value(X);
            if (ineqValuejX >= 0.0) {
                return Double.NaN;
            }
            psi -= Math.log(-ineqValuejX);
        }
        return psi;
    }

    public double[] gradient(double[] X) {
        DoubleMatrix1D gradFiSum = this.F1.make(this.getDim());
        for (int j = 0; j < this.fi.length; ++j) {
            double ineqValuejX = this.fi[j].value(X);
            DoubleMatrix1D ineqGradjX = this.F1.make(this.fi[j].gradient(X));
            gradFiSum.assign(ineqGradjX.assign(Mult.mult(-1.0 / ineqValuejX)), Functions.plus);
        }
        return gradFiSum.toArray();
    }

    public double[][] hessian(double[] X) {
        DoubleMatrix2D HessSum = this.F2.make(new double[this.getDim()][this.getDim()]);
        DoubleMatrix2D GradSum = this.F2.make(new double[this.getDim()][this.getDim()]);
        for (int j = 0; j < this.fi.length; ++j) {
            double ineqValuejX = this.fi[j].value(X);
            double[][] fijHessianX = this.fi[j].hessian(X);
            DoubleMatrix2D ineqHessjX = fijHessianX != FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER ? this.F2.make(fijHessianX) : FunctionsUtils.ZEROES_MATRIX_PLACEHOLDER;
            DoubleMatrix1D ineqGradjX = this.F1.make(this.fi[j].gradient(X));
            if (ineqHessjX != FunctionsUtils.ZEROES_MATRIX_PLACEHOLDER) {
                HessSum.assign(ineqHessjX.assign(Mult.mult(-1.0 / ineqValuejX)), Functions.plus);
            }
            GradSum.assign(this.ALG.multOuter(ineqGradjX, ineqGradjX, null).assign(Mult.mult(1.0 / Math.pow(ineqValuejX, 2.0))), Functions.plus);
        }
        return HessSum.assign(GradSum, Functions.plus).toArray();
    }

    public int getDim() {
        return this.dim;
    }

    public double getDualityGap(double t) {
        return (double)this.fi.length / t;
    }

    public BarrierFunction createPhase1BarrierFunction() {
        final int dimPh1 = this.dim + 1;
        ConvexMultivariateRealFunction[] inequalitiesPh1 = new ConvexMultivariateRealFunction[this.fi.length];
        for (int i = 0; i < inequalitiesPh1.length; ++i) {
            ConvexMultivariateRealFunction fi;
            final ConvexMultivariateRealFunction originalFi = this.fi[i];
            inequalitiesPh1[i] = fi = new ConvexMultivariateRealFunction(){

                public double value(double[] Y) {
                    DoubleMatrix1D y = DoubleFactory1D.dense.make(Y);
                    DoubleMatrix1D X = y.viewPart(0, LogarithmicBarrier.this.dim);
                    return originalFi.value(X.toArray()) - y.get(dimPh1 - 1);
                }

                public double[] gradient(double[] Y) {
                    DoubleMatrix1D y = DoubleFactory1D.dense.make(Y);
                    DoubleMatrix1D X = y.viewPart(0, LogarithmicBarrier.this.dim);
                    DoubleMatrix1D origGrad = LogarithmicBarrier.this.F1.make(originalFi.gradient(X.toArray()));
                    DoubleMatrix1D ret = LogarithmicBarrier.this.F1.make(1, -1.0);
                    ret = LogarithmicBarrier.this.F1.append(origGrad, ret);
                    return ret.toArray();
                }

                public double[][] hessian(double[] Y) {
                    DoubleMatrix1D y = DoubleFactory1D.dense.make(Y);
                    DoubleMatrix1D X = y.viewPart(0, LogarithmicBarrier.this.dim);
                    double[][] origFiHessX = originalFi.hessian(X.toArray());
                    if (origFiHessX == FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER) {
                        return FunctionsUtils.ZEROES_2D_ARRAY_PLACEHOLDER;
                    }
                    DoubleMatrix2D origHess = LogarithmicBarrier.this.F2.make(origFiHessX);
                    DoubleMatrix2D[][] parts = new DoubleMatrix2D[][]{{origHess, null}, {null, LogarithmicBarrier.this.F2.make(1, 1)}};
                    return LogarithmicBarrier.this.F2.compose(parts).toArray();
                }

                public int getDim() {
                    return dimPh1;
                }
            };
        }
        LogarithmicBarrier bfPh1 = new LogarithmicBarrier(inequalitiesPh1, dimPh1);
        return bfPh1;
    }

    public double calculatePhase1InitialFeasiblePoint(double[] originalNotFeasiblePoint, double tolerance) {
        DoubleMatrix1D fiX0NF = this.F1.make(this.fi.length);
        for (int i = 0; i < this.fi.length; ++i) {
            fiX0NF.set(i, this.fi[i].value(originalNotFeasiblePoint));
        }
        int maxIneqIndex = Utils.getMaxIndex(fiX0NF);
        if (fiX0NF.get(maxIneqIndex) < 0.0) {
            return -1.0;
        }
        double s = Math.pow(tolerance, -0.5);
        for (int i = 0; i < fiX0NF.size(); ++i) {
            s = Math.max(s, fiX0NF.get(i) * Math.pow(tolerance, -0.5));
        }
        return s;
    }
}

