/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.solvers;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.algebra.CholeskyFactorization;
import com.joptimizer.algebra.CholeskyUpperDiagonalFactorization;
import com.joptimizer.algebra.Matrix1NormRescaler;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpperDiagonalHKKTSolver
extends KKTSolver {
    private boolean avoidScaling = false;
    private int diagonalLength;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public UpperDiagonalHKKTSolver(int diagonalLength) {
        this(diagonalLength, false);
    }

    public UpperDiagonalHKKTSolver(int diagonalLength, boolean avoidScaling) {
        this.diagonalLength = diagonalLength;
        this.avoidScaling = avoidScaling;
    }

    public DoubleMatrix1D[] solve() throws Exception {
        DoubleMatrix1D v = null;
        DoubleMatrix1D w = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("H: " + ArrayUtils.toString((Object)ColtUtils.fillSubdiagonalSymmetricMatrix((SparseDoubleMatrix2D)this.H).toArray())));
            this.log.debug((Object)("g: " + ArrayUtils.toString((Object)this.g.toArray())));
            if (this.A != null) {
                this.log.debug((Object)("A: " + ArrayUtils.toString((Object)this.A.toArray())));
                this.log.debug((Object)("h: " + ArrayUtils.toString((Object)this.h.toArray())));
            }
        }
        Matrix1NormRescaler rescaler = this.avoidScaling ? null : new Matrix1NormRescaler();
        CholeskyUpperDiagonalFactorization HFact = new CholeskyUpperDiagonalFactorization((SparseDoubleMatrix2D)this.H, this.diagonalLength, rescaler);
        boolean isHReducible = true;
        try {
            HFact.factorize();
        }
        catch (Exception e) {
            this.log.warn((Object)"warn", (Throwable)e);
            isHReducible = false;
        }
        if (isHReducible) {
            DoubleMatrix1D HInvg = HFact.solve(this.g);
            if (this.A != null) {
                DoubleMatrix2D HInvAT = HFact.solve(this.AT);
                DoubleMatrix2D MenoSLower = ColtUtils.subdiagonalMultiply(this.A, HInvAT);
                this.log.debug((Object)("MenoS: " + ArrayUtils.toString((Object)ColtUtils.fillSubdiagonalSymmetricMatrix(MenoSLower).toArray())));
                DoubleMatrix1D AHInvg = this.ALG.mult(this.A, HInvg);
                CholeskyFactorization MSFact = new CholeskyFactorization(MenoSLower, new Matrix1NormRescaler());
                try {
                    MSFact.factorize();
                    if (this.h == null) {
                        w = MSFact.solve(ColtUtils.scalarMult(AHInvg, -1.0));
                    } else {
                        DoubleMatrix1D hmAHInvg = ColtUtils.add(this.h, AHInvg, -1.0);
                        w = MSFact.solve(hmAHInvg);
                    }
                    v = HInvg.assign(this.ALG.mult(HInvAT, w), Functions.plus).assign(Mult.mult(-1.0));
                }
                catch (Exception e) {
                    this.log.warn((Object)("warn: " + e.getMessage()));
                    this.log.debug((Object)("MenoS: " + ArrayUtils.toString((Object)ColtUtils.fillSubdiagonalSymmetricMatrix(MenoSLower).toArray())));
                    try {
                        DoubleMatrix1D[] fullSol = this.solveAugmentedKKT();
                        v = fullSol[0];
                        w = fullSol[1];
                    }
                    catch (Exception ex) {
                        this.log.error((Object)ex.getMessage());
                        throw new Exception("KKT solution failed");
                    }
                }
            } else {
                w = null;
                v = HInvg.assign(Mult.mult(-1.0));
            }
        } else {
            DoubleMatrix1D[] fullSol = this.solveAugmentedKKT();
            v = fullSol[0];
            w = fullSol[1];
        }
        if (this.checkKKTSolutionAccuracy && !this.checkKKTSolutionAccuracy(v, w)) {
            this.log.error((Object)"KKT solution failed");
            throw new Exception("KKT solution failed");
        }
        DoubleMatrix1D[] ret = new DoubleMatrix1D[]{v, w};
        return ret;
    }

    protected boolean checkKKTSolutionAccuracy(DoubleMatrix1D v, DoubleMatrix1D w) {
        this.log.debug((Object)"checkKKTSolutionAccuracy");
        DoubleMatrix2D KKT = null;
        DoubleMatrix1D x = null;
        DoubleMatrix1D b = null;
        DoubleMatrix2D HFull = ColtUtils.fillSubdiagonalSymmetricMatrix((SparseDoubleMatrix2D)this.H);
        if (this.A != null) {
            DoubleMatrix2D[][] parts;
            if (this.h != null) {
                parts = new DoubleMatrix2D[][]{{HFull, this.AT}, {this.A, null}};
                KKT = HFull instanceof SparseDoubleMatrix2D && this.A instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse.compose(parts) : DoubleFactory2D.dense.compose(parts);
                x = this.F1.append(v, w);
                b = this.F1.append(this.g, this.h).assign(Mult.mult(-1.0));
            } else {
                parts = new DoubleMatrix2D[][]{{HFull, this.AT}};
                KKT = HFull instanceof SparseDoubleMatrix2D && this.A instanceof SparseDoubleMatrix2D ? DoubleFactory2D.sparse.compose(parts) : DoubleFactory2D.dense.compose(parts);
                x = this.F1.append(v, w);
                b = ColtUtils.scalarMult(this.g, -1.0);
            }
        } else {
            KKT = HFull;
            x = v;
            b = ColtUtils.scalarMult(this.g, -1.0);
        }
        double scaledResidual = Utils.calculateScaledResidual(KKT, x, b);
        this.log.info((Object)("KKT inversion scaled residual: " + scaledResidual));
        return scaledResidual < this.toleranceKKT;
    }

    public void setDiagonalLength(int diagonalLength) {
        this.diagonalLength = diagonalLength;
    }

    public int getDiagonalLength() {
        return this.diagonalLength;
    }
}

