/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindImagePlaneMemoryInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PLANEASPECT;

    public VkBindImagePlaneMemoryInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindImagePlaneMemoryInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBindImagePlaneMemoryInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBindImagePlaneMemoryInfo.npNext(this.address());
    }

    @NativeType(value="VkImageAspectFlagBits")
    public int planeAspect() {
        return VkBindImagePlaneMemoryInfo.nplaneAspect(this.address());
    }

    public VkBindImagePlaneMemoryInfo sType(@NativeType(value="VkStructureType") int value) {
        VkBindImagePlaneMemoryInfo.nsType(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo pNext(@NativeType(value="void const *") long value) {
        VkBindImagePlaneMemoryInfo.npNext(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkBindImagePlaneMemoryInfo.nplaneAspect(this.address(), value);
        return this;
    }

    public VkBindImagePlaneMemoryInfo set(int sType, long pNext, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkBindImagePlaneMemoryInfo set(VkBindImagePlaneMemoryInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindImagePlaneMemoryInfo malloc() {
        return (VkBindImagePlaneMemoryInfo)VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo calloc() {
        return (VkBindImagePlaneMemoryInfo)VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkBindImagePlaneMemoryInfo)VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkBindImagePlaneMemoryInfo create(long address) {
        return (VkBindImagePlaneMemoryInfo)VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, (long)address);
    }

    @Nullable
    public static VkBindImagePlaneMemoryInfo createSafe(long address) {
        return address == 0L ? null : (VkBindImagePlaneMemoryInfo)VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkBindImagePlaneMemoryInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkBindImagePlaneMemoryInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkBindImagePlaneMemoryInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindImagePlaneMemoryInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkBindImagePlaneMemoryInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkBindImagePlaneMemoryInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkBindImagePlaneMemoryInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkBindImagePlaneMemoryInfo mallocStack() {
        return VkBindImagePlaneMemoryInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkBindImagePlaneMemoryInfo callocStack() {
        return VkBindImagePlaneMemoryInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkBindImagePlaneMemoryInfo mallocStack(MemoryStack stack) {
        return (VkBindImagePlaneMemoryInfo)VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBindImagePlaneMemoryInfo callocStack(MemoryStack stack) {
        return (VkBindImagePlaneMemoryInfo)VkBindImagePlaneMemoryInfo.wrap(VkBindImagePlaneMemoryInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkBindImagePlaneMemoryInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkBindImagePlaneMemoryInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBindImagePlaneMemoryInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkBindImagePlaneMemoryInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nplaneAspect(long struct) {
        return UNSAFE.getInt(null, struct + (long)PLANEASPECT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nplaneAspect(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PLANEASPECT, value);
    }

    static {
        Struct.Layout layout = VkBindImagePlaneMemoryInfo.__struct((Struct.Member[])new Struct.Member[]{VkBindImagePlaneMemoryInfo.__member((int)4), VkBindImagePlaneMemoryInfo.__member((int)POINTER_SIZE), VkBindImagePlaneMemoryInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PLANEASPECT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkBindImagePlaneMemoryInfo, Buffer>
    implements NativeResource {
        private static final VkBindImagePlaneMemoryInfo ELEMENT_FACTORY = VkBindImagePlaneMemoryInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBindImagePlaneMemoryInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBindImagePlaneMemoryInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBindImagePlaneMemoryInfo.npNext(this.address());
        }

        @NativeType(value="VkImageAspectFlagBits")
        public int planeAspect() {
            return VkBindImagePlaneMemoryInfo.nplaneAspect(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBindImagePlaneMemoryInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBindImagePlaneMemoryInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkBindImagePlaneMemoryInfo.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

