/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearValue;

public class VkClearAttachment
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int COLORATTACHMENT;
    public static final int CLEARVALUE;

    public VkClearAttachment(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkClearAttachment.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkClearAttachment.naspectMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachment() {
        return VkClearAttachment.ncolorAttachment(this.address());
    }

    public VkClearValue clearValue() {
        return VkClearAttachment.nclearValue(this.address());
    }

    public VkClearAttachment clearValue(Consumer<VkClearValue> consumer) {
        consumer.accept(this.clearValue());
        return this;
    }

    public VkClearAttachment aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkClearAttachment.naspectMask(this.address(), value);
        return this;
    }

    public VkClearAttachment colorAttachment(@NativeType(value="uint32_t") int value) {
        VkClearAttachment.ncolorAttachment(this.address(), value);
        return this;
    }

    public VkClearAttachment clearValue(VkClearValue value) {
        VkClearAttachment.nclearValue(this.address(), value);
        return this;
    }

    public VkClearAttachment set(int aspectMask, int colorAttachment, VkClearValue clearValue) {
        this.aspectMask(aspectMask);
        this.colorAttachment(colorAttachment);
        this.clearValue(clearValue);
        return this;
    }

    public VkClearAttachment set(VkClearAttachment src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkClearAttachment malloc() {
        return (VkClearAttachment)VkClearAttachment.wrap(VkClearAttachment.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkClearAttachment calloc() {
        return (VkClearAttachment)VkClearAttachment.wrap(VkClearAttachment.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkClearAttachment create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkClearAttachment)VkClearAttachment.wrap(VkClearAttachment.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkClearAttachment create(long address) {
        return (VkClearAttachment)VkClearAttachment.wrap(VkClearAttachment.class, (long)address);
    }

    @Nullable
    public static VkClearAttachment createSafe(long address) {
        return address == 0L ? null : (VkClearAttachment)VkClearAttachment.wrap(VkClearAttachment.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkClearAttachment.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkClearAttachment.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkClearAttachment.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearAttachment.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkClearAttachment.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkClearAttachment.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkClearAttachment.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkClearAttachment mallocStack() {
        return VkClearAttachment.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearAttachment callocStack() {
        return VkClearAttachment.callocStack(MemoryStack.stackGet());
    }

    public static VkClearAttachment mallocStack(MemoryStack stack) {
        return (VkClearAttachment)VkClearAttachment.wrap(VkClearAttachment.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearAttachment callocStack(MemoryStack stack) {
        return (VkClearAttachment)VkClearAttachment.wrap(VkClearAttachment.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearAttachment.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearAttachment.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearAttachment.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearAttachment.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static int ncolorAttachment(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORATTACHMENT);
    }

    public static VkClearValue nclearValue(long struct) {
        return VkClearValue.create(struct + (long)CLEARVALUE);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    public static void ncolorAttachment(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORATTACHMENT, value);
    }

    public static void nclearValue(long struct, VkClearValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CLEARVALUE), (long)VkClearValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkClearAttachment.__struct((Struct.Member[])new Struct.Member[]{VkClearAttachment.__member((int)4), VkClearAttachment.__member((int)4), VkClearAttachment.__member((int)VkClearValue.SIZEOF, (int)VkClearValue.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        COLORATTACHMENT = layout.offsetof(1);
        CLEARVALUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkClearAttachment, Buffer>
    implements NativeResource {
        private static final VkClearAttachment ELEMENT_FACTORY = VkClearAttachment.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkClearAttachment getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkClearAttachment.naspectMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachment() {
            return VkClearAttachment.ncolorAttachment(this.address());
        }

        public VkClearValue clearValue() {
            return VkClearAttachment.nclearValue(this.address());
        }

        public Buffer clearValue(Consumer<VkClearValue> consumer) {
            consumer.accept(this.clearValue());
            return this;
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkClearAttachment.naspectMask(this.address(), value);
            return this;
        }

        public Buffer colorAttachment(@NativeType(value="uint32_t") int value) {
            VkClearAttachment.ncolorAttachment(this.address(), value);
            return this;
        }

        public Buffer clearValue(VkClearValue value) {
            VkClearAttachment.nclearValue(this.address(), value);
            return this;
        }
    }
}

