/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkClearColorValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLOAT32;
    public static final int INT32;
    public static final int UINT32;

    public VkClearColorValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkClearColorValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[4]")
    public FloatBuffer float32() {
        return VkClearColorValue.nfloat32(this.address());
    }

    public float float32(int index) {
        return VkClearColorValue.nfloat32(this.address(), index);
    }

    @NativeType(value="int32_t[4]")
    public IntBuffer int32() {
        return VkClearColorValue.nint32(this.address());
    }

    @NativeType(value="int32_t")
    public int int32(int index) {
        return VkClearColorValue.nint32(this.address(), index);
    }

    @NativeType(value="uint32_t[4]")
    public IntBuffer uint32() {
        return VkClearColorValue.nuint32(this.address());
    }

    @NativeType(value="uint32_t")
    public int uint32(int index) {
        return VkClearColorValue.nuint32(this.address(), index);
    }

    public VkClearColorValue float32(@NativeType(value="float[4]") FloatBuffer value) {
        VkClearColorValue.nfloat32(this.address(), value);
        return this;
    }

    public VkClearColorValue float32(int index, float value) {
        VkClearColorValue.nfloat32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue int32(@NativeType(value="int32_t[4]") IntBuffer value) {
        VkClearColorValue.nint32(this.address(), value);
        return this;
    }

    public VkClearColorValue int32(int index, @NativeType(value="int32_t") int value) {
        VkClearColorValue.nint32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue uint32(@NativeType(value="uint32_t[4]") IntBuffer value) {
        VkClearColorValue.nuint32(this.address(), value);
        return this;
    }

    public VkClearColorValue uint32(int index, @NativeType(value="uint32_t") int value) {
        VkClearColorValue.nuint32(this.address(), index, value);
        return this;
    }

    public VkClearColorValue set(VkClearColorValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkClearColorValue malloc() {
        return (VkClearColorValue)VkClearColorValue.wrap(VkClearColorValue.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkClearColorValue calloc() {
        return (VkClearColorValue)VkClearColorValue.wrap(VkClearColorValue.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkClearColorValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkClearColorValue)VkClearColorValue.wrap(VkClearColorValue.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkClearColorValue create(long address) {
        return (VkClearColorValue)VkClearColorValue.wrap(VkClearColorValue.class, (long)address);
    }

    @Nullable
    public static VkClearColorValue createSafe(long address) {
        return address == 0L ? null : (VkClearColorValue)VkClearColorValue.wrap(VkClearColorValue.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkClearColorValue.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkClearColorValue.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkClearColorValue.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearColorValue.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkClearColorValue.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkClearColorValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkClearColorValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkClearColorValue mallocStack() {
        return VkClearColorValue.mallocStack(MemoryStack.stackGet());
    }

    public static VkClearColorValue callocStack() {
        return VkClearColorValue.callocStack(MemoryStack.stackGet());
    }

    public static VkClearColorValue mallocStack(MemoryStack stack) {
        return (VkClearColorValue)VkClearColorValue.wrap(VkClearColorValue.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearColorValue callocStack(MemoryStack stack) {
        return (VkClearColorValue)VkClearColorValue.wrap(VkClearColorValue.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkClearColorValue.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkClearColorValue.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearColorValue.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkClearColorValue.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static FloatBuffer nfloat32(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)FLOAT32), (int)4);
    }

    public static float nfloat32(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)FLOAT32 + Checks.check((int)index, (int)4) * 4L);
    }

    public static IntBuffer nint32(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)INT32), (int)4);
    }

    public static int nint32(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)INT32 + Checks.check((int)index, (int)4) * 4L);
    }

    public static IntBuffer nuint32(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)UINT32), (int)4);
    }

    public static int nuint32(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)UINT32 + Checks.check((int)index, (int)4) * 4L);
    }

    public static void nfloat32(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)FLOAT32), (long)(value.remaining() * 4));
    }

    public static void nfloat32(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)FLOAT32 + Checks.check((int)index, (int)4) * 4L, value);
    }

    public static void nint32(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)INT32), (long)(value.remaining() * 4));
    }

    public static void nint32(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)INT32 + Checks.check((int)index, (int)4) * 4L, value);
    }

    public static void nuint32(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)UINT32), (long)(value.remaining() * 4));
    }

    public static void nuint32(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)UINT32 + Checks.check((int)index, (int)4) * 4L, value);
    }

    static {
        Struct.Layout layout = VkClearColorValue.__union((Struct.Member[])new Struct.Member[]{VkClearColorValue.__array((int)4, (int)4), VkClearColorValue.__array((int)4, (int)4), VkClearColorValue.__array((int)4, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLOAT32 = layout.offsetof(0);
        INT32 = layout.offsetof(1);
        UINT32 = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkClearColorValue, Buffer>
    implements NativeResource {
        private static final VkClearColorValue ELEMENT_FACTORY = VkClearColorValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkClearColorValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[4]")
        public FloatBuffer float32() {
            return VkClearColorValue.nfloat32(this.address());
        }

        public float float32(int index) {
            return VkClearColorValue.nfloat32(this.address(), index);
        }

        @NativeType(value="int32_t[4]")
        public IntBuffer int32() {
            return VkClearColorValue.nint32(this.address());
        }

        @NativeType(value="int32_t")
        public int int32(int index) {
            return VkClearColorValue.nint32(this.address(), index);
        }

        @NativeType(value="uint32_t[4]")
        public IntBuffer uint32() {
            return VkClearColorValue.nuint32(this.address());
        }

        @NativeType(value="uint32_t")
        public int uint32(int index) {
            return VkClearColorValue.nuint32(this.address(), index);
        }

        public Buffer float32(@NativeType(value="float[4]") FloatBuffer value) {
            VkClearColorValue.nfloat32(this.address(), value);
            return this;
        }

        public Buffer float32(int index, float value) {
            VkClearColorValue.nfloat32(this.address(), index, value);
            return this;
        }

        public Buffer int32(@NativeType(value="int32_t[4]") IntBuffer value) {
            VkClearColorValue.nint32(this.address(), value);
            return this;
        }

        public Buffer int32(int index, @NativeType(value="int32_t") int value) {
            VkClearColorValue.nint32(this.address(), index, value);
            return this;
        }

        public Buffer uint32(@NativeType(value="uint32_t[4]") IntBuffer value) {
            VkClearColorValue.nuint32(this.address(), value);
            return this;
        }

        public Buffer uint32(int index, @NativeType(value="uint32_t") int value) {
            VkClearColorValue.nuint32(this.address(), index, value);
            return this;
        }
    }
}

