/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDeviceGroupBindSparseInfo;

public class VkDeviceGroupBindSparseInfoKHR
extends VkDeviceGroupBindSparseInfo {
    public VkDeviceGroupBindSparseInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceGroupBindSparseInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceGroupBindSparseInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfoKHR.nresourceDeviceIndex(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
        VkDeviceGroupBindSparseInfoKHR.nmemoryDeviceIndex(this.address(), value);
        return this;
    }

    @Override
    public VkDeviceGroupBindSparseInfoKHR set(int sType, long pNext, int resourceDeviceIndex, int memoryDeviceIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.resourceDeviceIndex(resourceDeviceIndex);
        this.memoryDeviceIndex(memoryDeviceIndex);
        return this;
    }

    public VkDeviceGroupBindSparseInfoKHR set(VkDeviceGroupBindSparseInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDeviceGroupBindSparseInfoKHR malloc() {
        return (VkDeviceGroupBindSparseInfoKHR)VkDeviceGroupBindSparseInfoKHR.wrap(VkDeviceGroupBindSparseInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHR calloc() {
        return (VkDeviceGroupBindSparseInfoKHR)VkDeviceGroupBindSparseInfoKHR.wrap(VkDeviceGroupBindSparseInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDeviceGroupBindSparseInfoKHR)VkDeviceGroupBindSparseInfoKHR.wrap(VkDeviceGroupBindSparseInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDeviceGroupBindSparseInfoKHR create(long address) {
        return (VkDeviceGroupBindSparseInfoKHR)VkDeviceGroupBindSparseInfoKHR.wrap(VkDeviceGroupBindSparseInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkDeviceGroupBindSparseInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkDeviceGroupBindSparseInfoKHR)VkDeviceGroupBindSparseInfoKHR.wrap(VkDeviceGroupBindSparseInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDeviceGroupBindSparseInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDeviceGroupBindSparseInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDeviceGroupBindSparseInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceGroupBindSparseInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDeviceGroupBindSparseInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDeviceGroupBindSparseInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDeviceGroupBindSparseInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkDeviceGroupBindSparseInfoKHR mallocStack() {
        return VkDeviceGroupBindSparseInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupBindSparseInfoKHR callocStack() {
        return VkDeviceGroupBindSparseInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDeviceGroupBindSparseInfoKHR mallocStack(MemoryStack stack) {
        return (VkDeviceGroupBindSparseInfoKHR)VkDeviceGroupBindSparseInfoKHR.wrap(VkDeviceGroupBindSparseInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceGroupBindSparseInfoKHR callocStack(MemoryStack stack) {
        return (VkDeviceGroupBindSparseInfoKHR)VkDeviceGroupBindSparseInfoKHR.wrap(VkDeviceGroupBindSparseInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDeviceGroupBindSparseInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDeviceGroupBindSparseInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceGroupBindSparseInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkDeviceGroupBindSparseInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkDeviceGroupBindSparseInfo.Buffer {
        private static final VkDeviceGroupBindSparseInfoKHR ELEMENT_FACTORY = VkDeviceGroupBindSparseInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceGroupBindSparseInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceGroupBindSparseInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceGroupBindSparseInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer resourceDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfoKHR.nresourceDeviceIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryDeviceIndex(@NativeType(value="uint32_t") int value) {
            VkDeviceGroupBindSparseInfoKHR.nmemoryDeviceIndex(this.address(), value);
            return this;
        }
    }
}

