/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExtent2D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;

    public VkExtent2D(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExtent2D.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkExtent2D.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkExtent2D.nheight(this.address());
    }

    public VkExtent2D width(@NativeType(value="uint32_t") int value) {
        VkExtent2D.nwidth(this.address(), value);
        return this;
    }

    public VkExtent2D height(@NativeType(value="uint32_t") int value) {
        VkExtent2D.nheight(this.address(), value);
        return this;
    }

    public VkExtent2D set(int width, int height) {
        this.width(width);
        this.height(height);
        return this;
    }

    public VkExtent2D set(VkExtent2D src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExtent2D malloc() {
        return (VkExtent2D)VkExtent2D.wrap(VkExtent2D.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkExtent2D calloc() {
        return (VkExtent2D)VkExtent2D.wrap(VkExtent2D.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkExtent2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkExtent2D)VkExtent2D.wrap(VkExtent2D.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkExtent2D create(long address) {
        return (VkExtent2D)VkExtent2D.wrap(VkExtent2D.class, (long)address);
    }

    @Nullable
    public static VkExtent2D createSafe(long address) {
        return address == 0L ? null : (VkExtent2D)VkExtent2D.wrap(VkExtent2D.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkExtent2D.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkExtent2D.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkExtent2D.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExtent2D.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkExtent2D.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkExtent2D.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkExtent2D.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkExtent2D mallocStack() {
        return VkExtent2D.mallocStack(MemoryStack.stackGet());
    }

    public static VkExtent2D callocStack() {
        return VkExtent2D.callocStack(MemoryStack.stackGet());
    }

    public static VkExtent2D mallocStack(MemoryStack stack) {
        return (VkExtent2D)VkExtent2D.wrap(VkExtent2D.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExtent2D callocStack(MemoryStack stack) {
        return (VkExtent2D)VkExtent2D.wrap(VkExtent2D.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkExtent2D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkExtent2D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExtent2D.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkExtent2D.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = VkExtent2D.__struct((Struct.Member[])new Struct.Member[]{VkExtent2D.__member((int)4), VkExtent2D.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkExtent2D, Buffer>
    implements NativeResource {
        private static final VkExtent2D ELEMENT_FACTORY = VkExtent2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkExtent2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkExtent2D.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkExtent2D.nheight(this.address());
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkExtent2D.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkExtent2D.nheight(this.address(), value);
            return this;
        }
    }
}

