/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageCopy
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCSUBRESOURCE;
    public static final int SRCOFFSET;
    public static final int DSTSUBRESOURCE;
    public static final int DSTOFFSET;
    public static final int EXTENT;

    public VkImageCopy(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageCopy.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkImageSubresourceLayers srcSubresource() {
        return VkImageCopy.nsrcSubresource(this.address());
    }

    public VkImageCopy srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.srcSubresource());
        return this;
    }

    public VkOffset3D srcOffset() {
        return VkImageCopy.nsrcOffset(this.address());
    }

    public VkImageCopy srcOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.srcOffset());
        return this;
    }

    public VkImageSubresourceLayers dstSubresource() {
        return VkImageCopy.ndstSubresource(this.address());
    }

    public VkImageCopy dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.dstSubresource());
        return this;
    }

    public VkOffset3D dstOffset() {
        return VkImageCopy.ndstOffset(this.address());
    }

    public VkImageCopy dstOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.dstOffset());
        return this;
    }

    public VkExtent3D extent() {
        return VkImageCopy.nextent(this.address());
    }

    public VkImageCopy extent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkImageCopy srcSubresource(VkImageSubresourceLayers value) {
        VkImageCopy.nsrcSubresource(this.address(), value);
        return this;
    }

    public VkImageCopy srcOffset(VkOffset3D value) {
        VkImageCopy.nsrcOffset(this.address(), value);
        return this;
    }

    public VkImageCopy dstSubresource(VkImageSubresourceLayers value) {
        VkImageCopy.ndstSubresource(this.address(), value);
        return this;
    }

    public VkImageCopy dstOffset(VkOffset3D value) {
        VkImageCopy.ndstOffset(this.address(), value);
        return this;
    }

    public VkImageCopy extent(VkExtent3D value) {
        VkImageCopy.nextent(this.address(), value);
        return this;
    }

    public VkImageCopy set(VkImageSubresourceLayers srcSubresource, VkOffset3D srcOffset, VkImageSubresourceLayers dstSubresource, VkOffset3D dstOffset, VkExtent3D extent) {
        this.srcSubresource(srcSubresource);
        this.srcOffset(srcOffset);
        this.dstSubresource(dstSubresource);
        this.dstOffset(dstOffset);
        this.extent(extent);
        return this;
    }

    public VkImageCopy set(VkImageCopy src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageCopy malloc() {
        return (VkImageCopy)VkImageCopy.wrap(VkImageCopy.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageCopy calloc() {
        return (VkImageCopy)VkImageCopy.wrap(VkImageCopy.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageCopy create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageCopy)VkImageCopy.wrap(VkImageCopy.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageCopy create(long address) {
        return (VkImageCopy)VkImageCopy.wrap(VkImageCopy.class, (long)address);
    }

    @Nullable
    public static VkImageCopy createSafe(long address) {
        return address == 0L ? null : (VkImageCopy)VkImageCopy.wrap(VkImageCopy.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageCopy.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageCopy.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageCopy.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageCopy.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageCopy.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageCopy.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageCopy.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageCopy mallocStack() {
        return VkImageCopy.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageCopy callocStack() {
        return VkImageCopy.callocStack(MemoryStack.stackGet());
    }

    public static VkImageCopy mallocStack(MemoryStack stack) {
        return (VkImageCopy)VkImageCopy.wrap(VkImageCopy.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageCopy callocStack(MemoryStack stack) {
        return (VkImageCopy)VkImageCopy.wrap(VkImageCopy.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageCopy.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageCopy.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageCopy.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageCopy.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkImageSubresourceLayers nsrcSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)SRCSUBRESOURCE);
    }

    public static VkOffset3D nsrcOffset(long struct) {
        return VkOffset3D.create(struct + (long)SRCOFFSET);
    }

    public static VkImageSubresourceLayers ndstSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)DSTSUBRESOURCE);
    }

    public static VkOffset3D ndstOffset(long struct) {
        return VkOffset3D.create(struct + (long)DSTOFFSET);
    }

    public static VkExtent3D nextent(long struct) {
        return VkExtent3D.create(struct + (long)EXTENT);
    }

    public static void nsrcSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRCSUBRESOURCE), (long)VkImageSubresourceLayers.SIZEOF);
    }

    public static void nsrcOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SRCOFFSET), (long)VkOffset3D.SIZEOF);
    }

    public static void ndstSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DSTSUBRESOURCE), (long)VkImageSubresourceLayers.SIZEOF);
    }

    public static void ndstOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DSTOFFSET), (long)VkOffset3D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageCopy.__struct((Struct.Member[])new Struct.Member[]{VkImageCopy.__member((int)VkImageSubresourceLayers.SIZEOF, (int)VkImageSubresourceLayers.ALIGNOF), VkImageCopy.__member((int)VkOffset3D.SIZEOF, (int)VkOffset3D.ALIGNOF), VkImageCopy.__member((int)VkImageSubresourceLayers.SIZEOF, (int)VkImageSubresourceLayers.ALIGNOF), VkImageCopy.__member((int)VkOffset3D.SIZEOF, (int)VkOffset3D.ALIGNOF), VkImageCopy.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCSUBRESOURCE = layout.offsetof(0);
        SRCOFFSET = layout.offsetof(1);
        DSTSUBRESOURCE = layout.offsetof(2);
        DSTOFFSET = layout.offsetof(3);
        EXTENT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageCopy, Buffer>
    implements NativeResource {
        private static final VkImageCopy ELEMENT_FACTORY = VkImageCopy.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageCopy getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkImageSubresourceLayers srcSubresource() {
            return VkImageCopy.nsrcSubresource(this.address());
        }

        public Buffer srcSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.srcSubresource());
            return this;
        }

        public VkOffset3D srcOffset() {
            return VkImageCopy.nsrcOffset(this.address());
        }

        public Buffer srcOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.srcOffset());
            return this;
        }

        public VkImageSubresourceLayers dstSubresource() {
            return VkImageCopy.ndstSubresource(this.address());
        }

        public Buffer dstSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.dstSubresource());
            return this;
        }

        public VkOffset3D dstOffset() {
            return VkImageCopy.ndstOffset(this.address());
        }

        public Buffer dstOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.dstOffset());
            return this;
        }

        public VkExtent3D extent() {
            return VkImageCopy.nextent(this.address());
        }

        public Buffer extent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        public Buffer srcSubresource(VkImageSubresourceLayers value) {
            VkImageCopy.nsrcSubresource(this.address(), value);
            return this;
        }

        public Buffer srcOffset(VkOffset3D value) {
            VkImageCopy.nsrcOffset(this.address(), value);
            return this;
        }

        public Buffer dstSubresource(VkImageSubresourceLayers value) {
            VkImageCopy.ndstSubresource(this.address(), value);
            return this;
        }

        public Buffer dstOffset(VkOffset3D value) {
            VkImageCopy.ndstOffset(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent3D value) {
            VkImageCopy.nextent(this.address(), value);
            return this;
        }
    }
}

