/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageSubresourceRange;

public class VkImageMemoryBarrier
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCACCESSMASK;
    public static final int DSTACCESSMASK;
    public static final int OLDLAYOUT;
    public static final int NEWLAYOUT;
    public static final int SRCQUEUEFAMILYINDEX;
    public static final int DSTQUEUEFAMILYINDEX;
    public static final int IMAGE;
    public static final int SUBRESOURCERANGE;

    public VkImageMemoryBarrier(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageMemoryBarrier.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageMemoryBarrier.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageMemoryBarrier.npNext(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int srcAccessMask() {
        return VkImageMemoryBarrier.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkAccessFlags")
    public int dstAccessMask() {
        return VkImageMemoryBarrier.ndstAccessMask(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int oldLayout() {
        return VkImageMemoryBarrier.noldLayout(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int newLayout() {
        return VkImageMemoryBarrier.nnewLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int srcQueueFamilyIndex() {
        return VkImageMemoryBarrier.nsrcQueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstQueueFamilyIndex() {
        return VkImageMemoryBarrier.ndstQueueFamilyIndex(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkImageMemoryBarrier.nimage(this.address());
    }

    public VkImageSubresourceRange subresourceRange() {
        return VkImageMemoryBarrier.nsubresourceRange(this.address());
    }

    public VkImageMemoryBarrier subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
        consumer.accept(this.subresourceRange());
        return this;
    }

    public VkImageMemoryBarrier sType(@NativeType(value="VkStructureType") int value) {
        VkImageMemoryBarrier.nsType(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier pNext(@NativeType(value="void const *") long value) {
        VkImageMemoryBarrier.npNext(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkImageMemoryBarrier.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
        VkImageMemoryBarrier.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier oldLayout(@NativeType(value="VkImageLayout") int value) {
        VkImageMemoryBarrier.noldLayout(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier newLayout(@NativeType(value="VkImageLayout") int value) {
        VkImageMemoryBarrier.nnewLayout(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkImageMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkImageMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier image(@NativeType(value="VkImage") long value) {
        VkImageMemoryBarrier.nimage(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier subresourceRange(VkImageSubresourceRange value) {
        VkImageMemoryBarrier.nsubresourceRange(this.address(), value);
        return this;
    }

    public VkImageMemoryBarrier set(int sType, long pNext, int srcAccessMask, int dstAccessMask, int oldLayout, int newLayout, int srcQueueFamilyIndex, int dstQueueFamilyIndex, long image, VkImageSubresourceRange subresourceRange) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcAccessMask(srcAccessMask);
        this.dstAccessMask(dstAccessMask);
        this.oldLayout(oldLayout);
        this.newLayout(newLayout);
        this.srcQueueFamilyIndex(srcQueueFamilyIndex);
        this.dstQueueFamilyIndex(dstQueueFamilyIndex);
        this.image(image);
        this.subresourceRange(subresourceRange);
        return this;
    }

    public VkImageMemoryBarrier set(VkImageMemoryBarrier src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageMemoryBarrier malloc() {
        return (VkImageMemoryBarrier)VkImageMemoryBarrier.wrap(VkImageMemoryBarrier.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageMemoryBarrier calloc() {
        return (VkImageMemoryBarrier)VkImageMemoryBarrier.wrap(VkImageMemoryBarrier.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageMemoryBarrier create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageMemoryBarrier)VkImageMemoryBarrier.wrap(VkImageMemoryBarrier.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageMemoryBarrier create(long address) {
        return (VkImageMemoryBarrier)VkImageMemoryBarrier.wrap(VkImageMemoryBarrier.class, (long)address);
    }

    @Nullable
    public static VkImageMemoryBarrier createSafe(long address) {
        return address == 0L ? null : (VkImageMemoryBarrier)VkImageMemoryBarrier.wrap(VkImageMemoryBarrier.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageMemoryBarrier.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageMemoryBarrier.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageMemoryBarrier.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageMemoryBarrier.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageMemoryBarrier.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageMemoryBarrier mallocStack() {
        return VkImageMemoryBarrier.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryBarrier callocStack() {
        return VkImageMemoryBarrier.callocStack(MemoryStack.stackGet());
    }

    public static VkImageMemoryBarrier mallocStack(MemoryStack stack) {
        return (VkImageMemoryBarrier)VkImageMemoryBarrier.wrap(VkImageMemoryBarrier.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageMemoryBarrier callocStack(MemoryStack stack) {
        return (VkImageMemoryBarrier)VkImageMemoryBarrier.wrap(VkImageMemoryBarrier.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageMemoryBarrier.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageMemoryBarrier.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageMemoryBarrier.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageMemoryBarrier.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nsrcAccessMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCACCESSMASK);
    }

    public static int ndstAccessMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTACCESSMASK);
    }

    public static int noldLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)OLDLAYOUT);
    }

    public static int nnewLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)NEWLAYOUT);
    }

    public static int nsrcQueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCQUEUEFAMILYINDEX);
    }

    public static int ndstQueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTQUEUEFAMILYINDEX);
    }

    public static long nimage(long struct) {
        return UNSAFE.getLong(null, struct + (long)IMAGE);
    }

    public static VkImageSubresourceRange nsubresourceRange(long struct) {
        return VkImageSubresourceRange.create(struct + (long)SUBRESOURCERANGE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcAccessMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstAccessMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTACCESSMASK, value);
    }

    public static void noldLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OLDLAYOUT, value);
    }

    public static void nnewLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NEWLAYOUT, value);
    }

    public static void nsrcQueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCQUEUEFAMILYINDEX, value);
    }

    public static void ndstQueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTQUEUEFAMILYINDEX, value);
    }

    public static void nimage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)IMAGE, value);
    }

    public static void nsubresourceRange(long struct, VkImageSubresourceRange value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SUBRESOURCERANGE), (long)VkImageSubresourceRange.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageMemoryBarrier.__struct((Struct.Member[])new Struct.Member[]{VkImageMemoryBarrier.__member((int)4), VkImageMemoryBarrier.__member((int)POINTER_SIZE), VkImageMemoryBarrier.__member((int)4), VkImageMemoryBarrier.__member((int)4), VkImageMemoryBarrier.__member((int)4), VkImageMemoryBarrier.__member((int)4), VkImageMemoryBarrier.__member((int)4), VkImageMemoryBarrier.__member((int)4), VkImageMemoryBarrier.__member((int)8), VkImageMemoryBarrier.__member((int)VkImageSubresourceRange.SIZEOF, (int)VkImageSubresourceRange.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCACCESSMASK = layout.offsetof(2);
        DSTACCESSMASK = layout.offsetof(3);
        OLDLAYOUT = layout.offsetof(4);
        NEWLAYOUT = layout.offsetof(5);
        SRCQUEUEFAMILYINDEX = layout.offsetof(6);
        DSTQUEUEFAMILYINDEX = layout.offsetof(7);
        IMAGE = layout.offsetof(8);
        SUBRESOURCERANGE = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkImageMemoryBarrier, Buffer>
    implements NativeResource {
        private static final VkImageMemoryBarrier ELEMENT_FACTORY = VkImageMemoryBarrier.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageMemoryBarrier getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageMemoryBarrier.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageMemoryBarrier.npNext(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int srcAccessMask() {
            return VkImageMemoryBarrier.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkAccessFlags")
        public int dstAccessMask() {
            return VkImageMemoryBarrier.ndstAccessMask(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int oldLayout() {
            return VkImageMemoryBarrier.noldLayout(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int newLayout() {
            return VkImageMemoryBarrier.nnewLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int srcQueueFamilyIndex() {
            return VkImageMemoryBarrier.nsrcQueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstQueueFamilyIndex() {
            return VkImageMemoryBarrier.ndstQueueFamilyIndex(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkImageMemoryBarrier.nimage(this.address());
        }

        public VkImageSubresourceRange subresourceRange() {
            return VkImageMemoryBarrier.nsubresourceRange(this.address());
        }

        public Buffer subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
            consumer.accept(this.subresourceRange());
            return this;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageMemoryBarrier.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageMemoryBarrier.npNext(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkImageMemoryBarrier.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags") int value) {
            VkImageMemoryBarrier.ndstAccessMask(this.address(), value);
            return this;
        }

        public Buffer oldLayout(@NativeType(value="VkImageLayout") int value) {
            VkImageMemoryBarrier.noldLayout(this.address(), value);
            return this;
        }

        public Buffer newLayout(@NativeType(value="VkImageLayout") int value) {
            VkImageMemoryBarrier.nnewLayout(this.address(), value);
            return this;
        }

        public Buffer srcQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkImageMemoryBarrier.nsrcQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer dstQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkImageMemoryBarrier.ndstQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkImageMemoryBarrier.nimage(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(VkImageSubresourceRange value) {
            VkImageMemoryBarrier.nsubresourceRange(this.address(), value);
            return this;
        }
    }
}

