/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkImageViewUsageCreateInfo;

public class VkImageViewUsageCreateInfoKHR
extends VkImageViewUsageCreateInfo {
    public VkImageViewUsageCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkImageViewUsageCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkImageViewUsageCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkImageViewUsageCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR usage(@NativeType(value="VkImageUsageFlags") int value) {
        VkImageViewUsageCreateInfoKHR.nusage(this.address(), value);
        return this;
    }

    @Override
    public VkImageViewUsageCreateInfoKHR set(int sType, long pNext, int usage) {
        this.sType(sType);
        this.pNext(pNext);
        this.usage(usage);
        return this;
    }

    public VkImageViewUsageCreateInfoKHR set(VkImageViewUsageCreateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageViewUsageCreateInfoKHR malloc() {
        return (VkImageViewUsageCreateInfoKHR)VkImageViewUsageCreateInfoKHR.wrap(VkImageViewUsageCreateInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageViewUsageCreateInfoKHR calloc() {
        return (VkImageViewUsageCreateInfoKHR)VkImageViewUsageCreateInfoKHR.wrap(VkImageViewUsageCreateInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageViewUsageCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageViewUsageCreateInfoKHR)VkImageViewUsageCreateInfoKHR.wrap(VkImageViewUsageCreateInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageViewUsageCreateInfoKHR create(long address) {
        return (VkImageViewUsageCreateInfoKHR)VkImageViewUsageCreateInfoKHR.wrap(VkImageViewUsageCreateInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkImageViewUsageCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkImageViewUsageCreateInfoKHR)VkImageViewUsageCreateInfoKHR.wrap(VkImageViewUsageCreateInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageViewUsageCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageViewUsageCreateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageViewUsageCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageViewUsageCreateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageViewUsageCreateInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageViewUsageCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageViewUsageCreateInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageViewUsageCreateInfoKHR mallocStack() {
        return VkImageViewUsageCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageViewUsageCreateInfoKHR callocStack() {
        return VkImageViewUsageCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkImageViewUsageCreateInfoKHR mallocStack(MemoryStack stack) {
        return (VkImageViewUsageCreateInfoKHR)VkImageViewUsageCreateInfoKHR.wrap(VkImageViewUsageCreateInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageViewUsageCreateInfoKHR callocStack(MemoryStack stack) {
        return (VkImageViewUsageCreateInfoKHR)VkImageViewUsageCreateInfoKHR.wrap(VkImageViewUsageCreateInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageViewUsageCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageViewUsageCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageViewUsageCreateInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageViewUsageCreateInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkImageViewUsageCreateInfo.Buffer {
        private static final VkImageViewUsageCreateInfoKHR ELEMENT_FACTORY = VkImageViewUsageCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageViewUsageCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageViewUsageCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageViewUsageCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer usage(@NativeType(value="VkImageUsageFlags") int value) {
            VkImageViewUsageCreateInfoKHR.nusage(this.address(), value);
            return this;
        }
    }
}

