/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryAllocateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ALLOCATIONSIZE;
    public static final int MEMORYTYPEINDEX;

    public VkMemoryAllocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryAllocateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryAllocateInfo.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationSize() {
        return VkMemoryAllocateInfo.nallocationSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryTypeIndex() {
        return VkMemoryAllocateInfo.nmemoryTypeIndex(this.address());
    }

    public VkMemoryAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo allocationSize(@NativeType(value="VkDeviceSize") long value) {
        VkMemoryAllocateInfo.nallocationSize(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo memoryTypeIndex(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateInfo.nmemoryTypeIndex(this.address(), value);
        return this;
    }

    public VkMemoryAllocateInfo set(int sType, long pNext, long allocationSize, int memoryTypeIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.allocationSize(allocationSize);
        this.memoryTypeIndex(memoryTypeIndex);
        return this;
    }

    public VkMemoryAllocateInfo set(VkMemoryAllocateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryAllocateInfo malloc() {
        return (VkMemoryAllocateInfo)VkMemoryAllocateInfo.wrap(VkMemoryAllocateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMemoryAllocateInfo calloc() {
        return (VkMemoryAllocateInfo)VkMemoryAllocateInfo.wrap(VkMemoryAllocateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMemoryAllocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMemoryAllocateInfo)VkMemoryAllocateInfo.wrap(VkMemoryAllocateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMemoryAllocateInfo create(long address) {
        return (VkMemoryAllocateInfo)VkMemoryAllocateInfo.wrap(VkMemoryAllocateInfo.class, (long)address);
    }

    @Nullable
    public static VkMemoryAllocateInfo createSafe(long address) {
        return address == 0L ? null : (VkMemoryAllocateInfo)VkMemoryAllocateInfo.wrap(VkMemoryAllocateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMemoryAllocateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMemoryAllocateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMemoryAllocateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryAllocateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMemoryAllocateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMemoryAllocateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMemoryAllocateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkMemoryAllocateInfo mallocStack() {
        return VkMemoryAllocateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateInfo callocStack() {
        return VkMemoryAllocateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkMemoryAllocateInfo mallocStack(MemoryStack stack) {
        return (VkMemoryAllocateInfo)VkMemoryAllocateInfo.wrap(VkMemoryAllocateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryAllocateInfo callocStack(MemoryStack stack) {
        return (VkMemoryAllocateInfo)VkMemoryAllocateInfo.wrap(VkMemoryAllocateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryAllocateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryAllocateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nallocationSize(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALLOCATIONSIZE);
    }

    public static int nmemoryTypeIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPEINDEX);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nallocationSize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ALLOCATIONSIZE, value);
    }

    public static void nmemoryTypeIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYTYPEINDEX, value);
    }

    static {
        Struct.Layout layout = VkMemoryAllocateInfo.__struct((Struct.Member[])new Struct.Member[]{VkMemoryAllocateInfo.__member((int)4), VkMemoryAllocateInfo.__member((int)POINTER_SIZE), VkMemoryAllocateInfo.__member((int)8), VkMemoryAllocateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ALLOCATIONSIZE = layout.offsetof(2);
        MEMORYTYPEINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryAllocateInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryAllocateInfo ELEMENT_FACTORY = VkMemoryAllocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryAllocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryAllocateInfo.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationSize() {
            return VkMemoryAllocateInfo.nallocationSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryTypeIndex() {
            return VkMemoryAllocateInfo.nmemoryTypeIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer allocationSize(@NativeType(value="VkDeviceSize") long value) {
            VkMemoryAllocateInfo.nallocationSize(this.address(), value);
            return this;
        }

        public Buffer memoryTypeIndex(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateInfo.nmemoryTypeIndex(this.address(), value);
            return this;
        }
    }
}

