/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceMemoryBudgetPropertiesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HEAPBUDGET;
    public static final int HEAPUSAGE;

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
    public LongBuffer heapBudget() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long heapBudget(int index) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address(), index);
    }

    @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
    public LongBuffer heapUsage() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long heapUsage(int index) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address(), index);
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT set(VkPhysicalDeviceMemoryBudgetPropertiesEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT malloc() {
        return (VkPhysicalDeviceMemoryBudgetPropertiesEXT)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT calloc() {
        return (VkPhysicalDeviceMemoryBudgetPropertiesEXT)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceMemoryBudgetPropertiesEXT)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT create(long address) {
        return (VkPhysicalDeviceMemoryBudgetPropertiesEXT)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceMemoryBudgetPropertiesEXT)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceMemoryBudgetPropertiesEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceMemoryBudgetPropertiesEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT mallocStack() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT callocStack() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceMemoryBudgetPropertiesEXT)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceMemoryBudgetPropertiesEXT)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static LongBuffer nheapBudget(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)HEAPBUDGET), (int)16);
    }

    public static long nheapBudget(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)HEAPBUDGET + Checks.check((int)index, (int)16) * 8L);
    }

    public static LongBuffer nheapUsage(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)HEAPUSAGE), (int)16);
    }

    public static long nheapUsage(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)HEAPUSAGE + Checks.check((int)index, (int)16) * 8L);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceMemoryBudgetPropertiesEXT.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceMemoryBudgetPropertiesEXT.__member((int)4), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__member((int)POINTER_SIZE), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__array((int)8, (int)16), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__array((int)8, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HEAPBUDGET = layout.offsetof(2);
        HEAPUSAGE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceMemoryBudgetPropertiesEXT, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceMemoryBudgetPropertiesEXT ELEMENT_FACTORY = VkPhysicalDeviceMemoryBudgetPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceMemoryBudgetPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
        public LongBuffer heapBudget() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long heapBudget(int index) {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address(), index);
        }

        @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
        public LongBuffer heapUsage() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long heapUsage(int index) {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address(), value);
            return this;
        }
    }
}

