/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkStencilOpState;

public class VkPipelineDepthStencilStateCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DEPTHTESTENABLE;
    public static final int DEPTHWRITEENABLE;
    public static final int DEPTHCOMPAREOP;
    public static final int DEPTHBOUNDSTESTENABLE;
    public static final int STENCILTESTENABLE;
    public static final int FRONT;
    public static final int BACK;
    public static final int MINDEPTHBOUNDS;
    public static final int MAXDEPTHBOUNDS;

    public VkPipelineDepthStencilStateCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineDepthStencilStateCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineDepthStencilStateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineDepthStencilStateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineDepthStencilStateCreateFlags")
    public int flags() {
        return VkPipelineDepthStencilStateCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean depthTestEnable() {
        return VkPipelineDepthStencilStateCreateInfo.ndepthTestEnable(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean depthWriteEnable() {
        return VkPipelineDepthStencilStateCreateInfo.ndepthWriteEnable(this.address()) != 0;
    }

    @NativeType(value="VkCompareOp")
    public int depthCompareOp() {
        return VkPipelineDepthStencilStateCreateInfo.ndepthCompareOp(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean depthBoundsTestEnable() {
        return VkPipelineDepthStencilStateCreateInfo.ndepthBoundsTestEnable(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean stencilTestEnable() {
        return VkPipelineDepthStencilStateCreateInfo.nstencilTestEnable(this.address()) != 0;
    }

    public VkStencilOpState front() {
        return VkPipelineDepthStencilStateCreateInfo.nfront(this.address());
    }

    public VkPipelineDepthStencilStateCreateInfo front(Consumer<VkStencilOpState> consumer) {
        consumer.accept(this.front());
        return this;
    }

    public VkStencilOpState back() {
        return VkPipelineDepthStencilStateCreateInfo.nback(this.address());
    }

    public VkPipelineDepthStencilStateCreateInfo back(Consumer<VkStencilOpState> consumer) {
        consumer.accept(this.back());
        return this;
    }

    public float minDepthBounds() {
        return VkPipelineDepthStencilStateCreateInfo.nminDepthBounds(this.address());
    }

    public float maxDepthBounds() {
        return VkPipelineDepthStencilStateCreateInfo.nmaxDepthBounds(this.address());
    }

    public VkPipelineDepthStencilStateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineDepthStencilStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineDepthStencilStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo flags(@NativeType(value="VkPipelineDepthStencilStateCreateFlags") int value) {
        VkPipelineDepthStencilStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo depthTestEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineDepthStencilStateCreateInfo.ndepthTestEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo depthWriteEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineDepthStencilStateCreateInfo.ndepthWriteEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo depthCompareOp(@NativeType(value="VkCompareOp") int value) {
        VkPipelineDepthStencilStateCreateInfo.ndepthCompareOp(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo depthBoundsTestEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineDepthStencilStateCreateInfo.ndepthBoundsTestEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo stencilTestEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineDepthStencilStateCreateInfo.nstencilTestEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo front(VkStencilOpState value) {
        VkPipelineDepthStencilStateCreateInfo.nfront(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo back(VkStencilOpState value) {
        VkPipelineDepthStencilStateCreateInfo.nback(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo minDepthBounds(float value) {
        VkPipelineDepthStencilStateCreateInfo.nminDepthBounds(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo maxDepthBounds(float value) {
        VkPipelineDepthStencilStateCreateInfo.nmaxDepthBounds(this.address(), value);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo set(int sType, long pNext, int flags, boolean depthTestEnable, boolean depthWriteEnable, int depthCompareOp, boolean depthBoundsTestEnable, boolean stencilTestEnable, VkStencilOpState front, VkStencilOpState back, float minDepthBounds, float maxDepthBounds) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.depthTestEnable(depthTestEnable);
        this.depthWriteEnable(depthWriteEnable);
        this.depthCompareOp(depthCompareOp);
        this.depthBoundsTestEnable(depthBoundsTestEnable);
        this.stencilTestEnable(stencilTestEnable);
        this.front(front);
        this.back(back);
        this.minDepthBounds(minDepthBounds);
        this.maxDepthBounds(maxDepthBounds);
        return this;
    }

    public VkPipelineDepthStencilStateCreateInfo set(VkPipelineDepthStencilStateCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineDepthStencilStateCreateInfo malloc() {
        return (VkPipelineDepthStencilStateCreateInfo)VkPipelineDepthStencilStateCreateInfo.wrap(VkPipelineDepthStencilStateCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPipelineDepthStencilStateCreateInfo calloc() {
        return (VkPipelineDepthStencilStateCreateInfo)VkPipelineDepthStencilStateCreateInfo.wrap(VkPipelineDepthStencilStateCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPipelineDepthStencilStateCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPipelineDepthStencilStateCreateInfo)VkPipelineDepthStencilStateCreateInfo.wrap(VkPipelineDepthStencilStateCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPipelineDepthStencilStateCreateInfo create(long address) {
        return (VkPipelineDepthStencilStateCreateInfo)VkPipelineDepthStencilStateCreateInfo.wrap(VkPipelineDepthStencilStateCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkPipelineDepthStencilStateCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkPipelineDepthStencilStateCreateInfo)VkPipelineDepthStencilStateCreateInfo.wrap(VkPipelineDepthStencilStateCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPipelineDepthStencilStateCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPipelineDepthStencilStateCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPipelineDepthStencilStateCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineDepthStencilStateCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPipelineDepthStencilStateCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPipelineDepthStencilStateCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPipelineDepthStencilStateCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPipelineDepthStencilStateCreateInfo mallocStack() {
        return VkPipelineDepthStencilStateCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkPipelineDepthStencilStateCreateInfo callocStack() {
        return VkPipelineDepthStencilStateCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkPipelineDepthStencilStateCreateInfo mallocStack(MemoryStack stack) {
        return (VkPipelineDepthStencilStateCreateInfo)VkPipelineDepthStencilStateCreateInfo.wrap(VkPipelineDepthStencilStateCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPipelineDepthStencilStateCreateInfo callocStack(MemoryStack stack) {
        return (VkPipelineDepthStencilStateCreateInfo)VkPipelineDepthStencilStateCreateInfo.wrap(VkPipelineDepthStencilStateCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPipelineDepthStencilStateCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPipelineDepthStencilStateCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPipelineDepthStencilStateCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPipelineDepthStencilStateCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ndepthTestEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHTESTENABLE);
    }

    public static int ndepthWriteEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHWRITEENABLE);
    }

    public static int ndepthCompareOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHCOMPAREOP);
    }

    public static int ndepthBoundsTestEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHBOUNDSTESTENABLE);
    }

    public static int nstencilTestEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)STENCILTESTENABLE);
    }

    public static VkStencilOpState nfront(long struct) {
        return VkStencilOpState.create(struct + (long)FRONT);
    }

    public static VkStencilOpState nback(long struct) {
        return VkStencilOpState.create(struct + (long)BACK);
    }

    public static float nminDepthBounds(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINDEPTHBOUNDS);
    }

    public static float nmaxDepthBounds(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXDEPTHBOUNDS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndepthTestEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHTESTENABLE, value);
    }

    public static void ndepthWriteEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHWRITEENABLE, value);
    }

    public static void ndepthCompareOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHCOMPAREOP, value);
    }

    public static void ndepthBoundsTestEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHBOUNDSTESTENABLE, value);
    }

    public static void nstencilTestEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STENCILTESTENABLE, value);
    }

    public static void nfront(long struct, VkStencilOpState value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FRONT), (long)VkStencilOpState.SIZEOF);
    }

    public static void nback(long struct, VkStencilOpState value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BACK), (long)VkStencilOpState.SIZEOF);
    }

    public static void nminDepthBounds(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINDEPTHBOUNDS, value);
    }

    public static void nmaxDepthBounds(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXDEPTHBOUNDS, value);
    }

    static {
        Struct.Layout layout = VkPipelineDepthStencilStateCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkPipelineDepthStencilStateCreateInfo.__member((int)4), VkPipelineDepthStencilStateCreateInfo.__member((int)POINTER_SIZE), VkPipelineDepthStencilStateCreateInfo.__member((int)4), VkPipelineDepthStencilStateCreateInfo.__member((int)4), VkPipelineDepthStencilStateCreateInfo.__member((int)4), VkPipelineDepthStencilStateCreateInfo.__member((int)4), VkPipelineDepthStencilStateCreateInfo.__member((int)4), VkPipelineDepthStencilStateCreateInfo.__member((int)4), VkPipelineDepthStencilStateCreateInfo.__member((int)VkStencilOpState.SIZEOF, (int)VkStencilOpState.ALIGNOF), VkPipelineDepthStencilStateCreateInfo.__member((int)VkStencilOpState.SIZEOF, (int)VkStencilOpState.ALIGNOF), VkPipelineDepthStencilStateCreateInfo.__member((int)4), VkPipelineDepthStencilStateCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DEPTHTESTENABLE = layout.offsetof(3);
        DEPTHWRITEENABLE = layout.offsetof(4);
        DEPTHCOMPAREOP = layout.offsetof(5);
        DEPTHBOUNDSTESTENABLE = layout.offsetof(6);
        STENCILTESTENABLE = layout.offsetof(7);
        FRONT = layout.offsetof(8);
        BACK = layout.offsetof(9);
        MINDEPTHBOUNDS = layout.offsetof(10);
        MAXDEPTHBOUNDS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineDepthStencilStateCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineDepthStencilStateCreateInfo ELEMENT_FACTORY = VkPipelineDepthStencilStateCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPipelineDepthStencilStateCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineDepthStencilStateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineDepthStencilStateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineDepthStencilStateCreateFlags")
        public int flags() {
            return VkPipelineDepthStencilStateCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean depthTestEnable() {
            return VkPipelineDepthStencilStateCreateInfo.ndepthTestEnable(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean depthWriteEnable() {
            return VkPipelineDepthStencilStateCreateInfo.ndepthWriteEnable(this.address()) != 0;
        }

        @NativeType(value="VkCompareOp")
        public int depthCompareOp() {
            return VkPipelineDepthStencilStateCreateInfo.ndepthCompareOp(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean depthBoundsTestEnable() {
            return VkPipelineDepthStencilStateCreateInfo.ndepthBoundsTestEnable(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean stencilTestEnable() {
            return VkPipelineDepthStencilStateCreateInfo.nstencilTestEnable(this.address()) != 0;
        }

        public VkStencilOpState front() {
            return VkPipelineDepthStencilStateCreateInfo.nfront(this.address());
        }

        public Buffer front(Consumer<VkStencilOpState> consumer) {
            consumer.accept(this.front());
            return this;
        }

        public VkStencilOpState back() {
            return VkPipelineDepthStencilStateCreateInfo.nback(this.address());
        }

        public Buffer back(Consumer<VkStencilOpState> consumer) {
            consumer.accept(this.back());
            return this;
        }

        public float minDepthBounds() {
            return VkPipelineDepthStencilStateCreateInfo.nminDepthBounds(this.address());
        }

        public float maxDepthBounds() {
            return VkPipelineDepthStencilStateCreateInfo.nmaxDepthBounds(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineDepthStencilStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineDepthStencilStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineDepthStencilStateCreateFlags") int value) {
            VkPipelineDepthStencilStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer depthTestEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineDepthStencilStateCreateInfo.ndepthTestEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer depthWriteEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineDepthStencilStateCreateInfo.ndepthWriteEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer depthCompareOp(@NativeType(value="VkCompareOp") int value) {
            VkPipelineDepthStencilStateCreateInfo.ndepthCompareOp(this.address(), value);
            return this;
        }

        public Buffer depthBoundsTestEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineDepthStencilStateCreateInfo.ndepthBoundsTestEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer stencilTestEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineDepthStencilStateCreateInfo.nstencilTestEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer front(VkStencilOpState value) {
            VkPipelineDepthStencilStateCreateInfo.nfront(this.address(), value);
            return this;
        }

        public Buffer back(VkStencilOpState value) {
            VkPipelineDepthStencilStateCreateInfo.nback(this.address(), value);
            return this;
        }

        public Buffer minDepthBounds(float value) {
            VkPipelineDepthStencilStateCreateInfo.nminDepthBounds(this.address(), value);
            return this;
        }

        public Buffer maxDepthBounds(float value) {
            VkPipelineDepthStencilStateCreateInfo.nmaxDepthBounds(this.address(), value);
            return this;
        }
    }
}

