/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkOffset2D;

public class VkRect2D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    public VkRect2D(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRect2D.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public VkOffset2D offset() {
        return VkRect2D.noffset(this.address());
    }

    public VkRect2D offset(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public VkExtent2D extent() {
        return VkRect2D.nextent(this.address());
    }

    public VkRect2D extent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkRect2D offset(VkOffset2D value) {
        VkRect2D.noffset(this.address(), value);
        return this;
    }

    public VkRect2D extent(VkExtent2D value) {
        VkRect2D.nextent(this.address(), value);
        return this;
    }

    public VkRect2D set(VkOffset2D offset, VkExtent2D extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public VkRect2D set(VkRect2D src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRect2D malloc() {
        return (VkRect2D)VkRect2D.wrap(VkRect2D.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkRect2D calloc() {
        return (VkRect2D)VkRect2D.wrap(VkRect2D.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkRect2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkRect2D)VkRect2D.wrap(VkRect2D.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkRect2D create(long address) {
        return (VkRect2D)VkRect2D.wrap(VkRect2D.class, (long)address);
    }

    @Nullable
    public static VkRect2D createSafe(long address) {
        return address == 0L ? null : (VkRect2D)VkRect2D.wrap(VkRect2D.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkRect2D.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkRect2D.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkRect2D.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRect2D.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkRect2D.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkRect2D.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkRect2D.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkRect2D mallocStack() {
        return VkRect2D.mallocStack(MemoryStack.stackGet());
    }

    public static VkRect2D callocStack() {
        return VkRect2D.callocStack(MemoryStack.stackGet());
    }

    public static VkRect2D mallocStack(MemoryStack stack) {
        return (VkRect2D)VkRect2D.wrap(VkRect2D.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRect2D callocStack(MemoryStack stack) {
        return (VkRect2D)VkRect2D.wrap(VkRect2D.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRect2D.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRect2D.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRect2D.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRect2D.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static VkOffset2D noffset(long struct) {
        return VkOffset2D.create(struct + (long)OFFSET);
    }

    public static VkExtent2D nextent(long struct) {
        return VkExtent2D.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, VkOffset2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)OFFSET), (long)VkOffset2D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENT), (long)VkExtent2D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkRect2D.__struct((Struct.Member[])new Struct.Member[]{VkRect2D.__member((int)VkOffset2D.SIZEOF, (int)VkOffset2D.ALIGNOF), VkRect2D.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkRect2D, Buffer>
    implements NativeResource {
        private static final VkRect2D ELEMENT_FACTORY = VkRect2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkRect2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkOffset2D offset() {
            return VkRect2D.noffset(this.address());
        }

        public Buffer offset(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public VkExtent2D extent() {
            return VkRect2D.nextent(this.address());
        }

        public Buffer extent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        public Buffer offset(VkOffset2D value) {
            VkRect2D.noffset(this.address(), value);
            return this;
        }

        public Buffer extent(VkExtent2D value) {
            VkRect2D.nextent(this.address(), value);
            return this;
        }
    }
}

