/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubpassBeginInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int CONTENTS;

    public VkSubpassBeginInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubpassBeginInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubpassBeginInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSubpassBeginInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkSubpassContents")
    public int contents() {
        return VkSubpassBeginInfoKHR.ncontents(this.address());
    }

    public VkSubpassBeginInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassBeginInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassBeginInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfoKHR contents(@NativeType(value="VkSubpassContents") int value) {
        VkSubpassBeginInfoKHR.ncontents(this.address(), value);
        return this;
    }

    public VkSubpassBeginInfoKHR set(int sType, long pNext, int contents) {
        this.sType(sType);
        this.pNext(pNext);
        this.contents(contents);
        return this;
    }

    public VkSubpassBeginInfoKHR set(VkSubpassBeginInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubpassBeginInfoKHR malloc() {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSubpassBeginInfoKHR calloc() {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSubpassBeginInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSubpassBeginInfoKHR create(long address) {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkSubpassBeginInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSubpassBeginInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassBeginInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSubpassBeginInfoKHR mallocStack() {
        return VkSubpassBeginInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassBeginInfoKHR callocStack() {
        return VkSubpassBeginInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassBeginInfoKHR mallocStack(MemoryStack stack) {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassBeginInfoKHR callocStack(MemoryStack stack) {
        return (VkSubpassBeginInfoKHR)VkSubpassBeginInfoKHR.wrap(VkSubpassBeginInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassBeginInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassBeginInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassBeginInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ncontents(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONTENTS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ncontents(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONTENTS, value);
    }

    static {
        Struct.Layout layout = VkSubpassBeginInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkSubpassBeginInfoKHR.__member((int)4), VkSubpassBeginInfoKHR.__member((int)POINTER_SIZE), VkSubpassBeginInfoKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        CONTENTS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassBeginInfoKHR, Buffer>
    implements NativeResource {
        private static final VkSubpassBeginInfoKHR ELEMENT_FACTORY = VkSubpassBeginInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSubpassBeginInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubpassBeginInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSubpassBeginInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkSubpassContents")
        public int contents() {
            return VkSubpassBeginInfoKHR.ncontents(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassBeginInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassBeginInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer contents(@NativeType(value="VkSubpassContents") int value) {
            VkSubpassBeginInfoKHR.ncontents(this.address(), value);
            return this;
        }
    }
}

