/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentReference;

public class VkSubpassDescription
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PIPELINEBINDPOINT;
    public static final int INPUTATTACHMENTCOUNT;
    public static final int PINPUTATTACHMENTS;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTS;
    public static final int PRESOLVEATTACHMENTS;
    public static final int PDEPTHSTENCILATTACHMENT;
    public static final int PRESERVEATTACHMENTCOUNT;
    public static final int PPRESERVEATTACHMENTS;

    public VkSubpassDescription(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSubpassDescription.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkSubpassDescriptionFlags")
    public int flags() {
        return VkSubpassDescription.nflags(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkSubpassDescription.npipelineBindPoint(this.address());
    }

    @NativeType(value="uint32_t")
    public int inputAttachmentCount() {
        return VkSubpassDescription.ninputAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference const *")
    public VkAttachmentReference.Buffer pInputAttachments() {
        return VkSubpassDescription.npInputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkSubpassDescription.ncolorAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference const *")
    public VkAttachmentReference.Buffer pColorAttachments() {
        return VkSubpassDescription.npColorAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference const *")
    public VkAttachmentReference.Buffer pResolveAttachments() {
        return VkSubpassDescription.npResolveAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkAttachmentReference const *")
    public VkAttachmentReference pDepthStencilAttachment() {
        return VkSubpassDescription.npDepthStencilAttachment(this.address());
    }

    @NativeType(value="uint32_t")
    public int preserveAttachmentCount() {
        return VkSubpassDescription.npreserveAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer pPreserveAttachments() {
        return VkSubpassDescription.npPreserveAttachments(this.address());
    }

    public VkSubpassDescription flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
        VkSubpassDescription.nflags(this.address(), value);
        return this;
    }

    public VkSubpassDescription pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkSubpassDescription.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkSubpassDescription pInputAttachments(@Nullable @NativeType(value="VkAttachmentReference const *") VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npInputAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkSubpassDescription.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkSubpassDescription pColorAttachments(@Nullable @NativeType(value="VkAttachmentReference const *") VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npColorAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription pResolveAttachments(@Nullable @NativeType(value="VkAttachmentReference const *") VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npResolveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription pDepthStencilAttachment(@Nullable @NativeType(value="VkAttachmentReference const *") VkAttachmentReference value) {
        VkSubpassDescription.npDepthStencilAttachment(this.address(), value);
        return this;
    }

    public VkSubpassDescription pPreserveAttachments(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        VkSubpassDescription.npPreserveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription set(int flags, int pipelineBindPoint, @Nullable VkAttachmentReference.Buffer pInputAttachments, int colorAttachmentCount, @Nullable VkAttachmentReference.Buffer pColorAttachments, @Nullable VkAttachmentReference.Buffer pResolveAttachments, @Nullable VkAttachmentReference pDepthStencilAttachment, @Nullable IntBuffer pPreserveAttachments) {
        this.flags(flags);
        this.pipelineBindPoint(pipelineBindPoint);
        this.pInputAttachments(pInputAttachments);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachments(pColorAttachments);
        this.pResolveAttachments(pResolveAttachments);
        this.pDepthStencilAttachment(pDepthStencilAttachment);
        this.pPreserveAttachments(pPreserveAttachments);
        return this;
    }

    public VkSubpassDescription set(VkSubpassDescription src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkSubpassDescription malloc() {
        return (VkSubpassDescription)VkSubpassDescription.wrap(VkSubpassDescription.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSubpassDescription calloc() {
        return (VkSubpassDescription)VkSubpassDescription.wrap(VkSubpassDescription.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSubpassDescription create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSubpassDescription)VkSubpassDescription.wrap(VkSubpassDescription.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSubpassDescription create(long address) {
        return (VkSubpassDescription)VkSubpassDescription.wrap(VkSubpassDescription.class, (long)address);
    }

    @Nullable
    public static VkSubpassDescription createSafe(long address) {
        return address == 0L ? null : (VkSubpassDescription)VkSubpassDescription.wrap(VkSubpassDescription.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSubpassDescription.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSubpassDescription.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSubpassDescription.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassDescription.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSubpassDescription.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSubpassDescription.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSubpassDescription.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSubpassDescription mallocStack() {
        return VkSubpassDescription.mallocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDescription callocStack() {
        return VkSubpassDescription.callocStack(MemoryStack.stackGet());
    }

    public static VkSubpassDescription mallocStack(MemoryStack stack) {
        return (VkSubpassDescription)VkSubpassDescription.wrap(VkSubpassDescription.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubpassDescription callocStack(MemoryStack stack) {
        return (VkSubpassDescription)VkSubpassDescription.wrap(VkSubpassDescription.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSubpassDescription.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSubpassDescription.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassDescription.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSubpassDescription.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int npipelineBindPoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINEBINDPOINT);
    }

    public static int ninputAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)INPUTATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentReference.Buffer npInputAttachments(long struct) {
        return VkAttachmentReference.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PINPUTATTACHMENTS)), VkSubpassDescription.ninputAttachmentCount(struct));
    }

    public static int ncolorAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORATTACHMENTCOUNT);
    }

    @Nullable
    public static VkAttachmentReference.Buffer npColorAttachments(long struct) {
        return VkAttachmentReference.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PCOLORATTACHMENTS)), VkSubpassDescription.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkAttachmentReference.Buffer npResolveAttachments(long struct) {
        return VkAttachmentReference.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PRESOLVEATTACHMENTS)), VkSubpassDescription.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkAttachmentReference npDepthStencilAttachment(long struct) {
        return VkAttachmentReference.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PDEPTHSTENCILATTACHMENT)));
    }

    public static int npreserveAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRESERVEATTACHMENTCOUNT);
    }

    @Nullable
    public static IntBuffer npPreserveAttachments(long struct) {
        return MemoryUtil.memIntBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPRESERVEATTACHMENTS)), (int)VkSubpassDescription.npreserveAttachmentCount(struct));
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void ninputAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INPUTATTACHMENTCOUNT, value);
    }

    public static void npInputAttachments(long struct, @Nullable VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PINPUTATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkSubpassDescription.ninputAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachments(long struct, @Nullable VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOLORATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npResolveAttachments(long struct, @Nullable VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRESOLVEATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npDepthStencilAttachment(long struct, @Nullable VkAttachmentReference value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PDEPTHSTENCILATTACHMENT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npreserveAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRESERVEATTACHMENTCOUNT, value);
    }

    public static void npPreserveAttachments(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPRESERVEATTACHMENTS), (long)MemoryUtil.memAddressSafe((IntBuffer)value));
        VkSubpassDescription.npreserveAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubpassDescription.ninputAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PINPUTATTACHMENTS)));
        }
        if (VkSubpassDescription.ncolorAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCOLORATTACHMENTS)));
        }
        if (VkSubpassDescription.npreserveAttachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPRESERVEATTACHMENTS)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSubpassDescription.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkSubpassDescription.__struct((Struct.Member[])new Struct.Member[]{VkSubpassDescription.__member((int)4), VkSubpassDescription.__member((int)4), VkSubpassDescription.__member((int)4), VkSubpassDescription.__member((int)POINTER_SIZE), VkSubpassDescription.__member((int)4), VkSubpassDescription.__member((int)POINTER_SIZE), VkSubpassDescription.__member((int)POINTER_SIZE), VkSubpassDescription.__member((int)POINTER_SIZE), VkSubpassDescription.__member((int)4), VkSubpassDescription.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PIPELINEBINDPOINT = layout.offsetof(1);
        INPUTATTACHMENTCOUNT = layout.offsetof(2);
        PINPUTATTACHMENTS = layout.offsetof(3);
        COLORATTACHMENTCOUNT = layout.offsetof(4);
        PCOLORATTACHMENTS = layout.offsetof(5);
        PRESOLVEATTACHMENTS = layout.offsetof(6);
        PDEPTHSTENCILATTACHMENT = layout.offsetof(7);
        PRESERVEATTACHMENTCOUNT = layout.offsetof(8);
        PPRESERVEATTACHMENTS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassDescription, Buffer>
    implements NativeResource {
        private static final VkSubpassDescription ELEMENT_FACTORY = VkSubpassDescription.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSubpassDescription getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkSubpassDescriptionFlags")
        public int flags() {
            return VkSubpassDescription.nflags(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkSubpassDescription.npipelineBindPoint(this.address());
        }

        @NativeType(value="uint32_t")
        public int inputAttachmentCount() {
            return VkSubpassDescription.ninputAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference const *")
        public VkAttachmentReference.Buffer pInputAttachments() {
            return VkSubpassDescription.npInputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkSubpassDescription.ncolorAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference const *")
        public VkAttachmentReference.Buffer pColorAttachments() {
            return VkSubpassDescription.npColorAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference const *")
        public VkAttachmentReference.Buffer pResolveAttachments() {
            return VkSubpassDescription.npResolveAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkAttachmentReference const *")
        public VkAttachmentReference pDepthStencilAttachment() {
            return VkSubpassDescription.npDepthStencilAttachment(this.address());
        }

        @NativeType(value="uint32_t")
        public int preserveAttachmentCount() {
            return VkSubpassDescription.npreserveAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer pPreserveAttachments() {
            return VkSubpassDescription.npPreserveAttachments(this.address());
        }

        public Buffer flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
            VkSubpassDescription.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkSubpassDescription.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer pInputAttachments(@Nullable @NativeType(value="VkAttachmentReference const *") VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npInputAttachments(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkSubpassDescription.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachments(@Nullable @NativeType(value="VkAttachmentReference const *") VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npColorAttachments(this.address(), value);
            return this;
        }

        public Buffer pResolveAttachments(@Nullable @NativeType(value="VkAttachmentReference const *") VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npResolveAttachments(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilAttachment(@Nullable @NativeType(value="VkAttachmentReference const *") VkAttachmentReference value) {
            VkSubpassDescription.npDepthStencilAttachment(this.address(), value);
            return this;
        }

        public Buffer pPreserveAttachments(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            VkSubpassDescription.npPreserveAttachments(this.address(), value);
            return this;
        }
    }
}

