/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkSurfaceCapabilitiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MINIMAGECOUNT;
    public static final int MAXIMAGECOUNT;
    public static final int CURRENTEXTENT;
    public static final int MINIMAGEEXTENT;
    public static final int MAXIMAGEEXTENT;
    public static final int MAXIMAGEARRAYLAYERS;
    public static final int SUPPORTEDTRANSFORMS;
    public static final int CURRENTTRANSFORM;
    public static final int SUPPORTEDCOMPOSITEALPHA;
    public static final int SUPPORTEDUSAGEFLAGS;

    public VkSurfaceCapabilitiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkSurfaceCapabilitiesKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int minImageCount() {
        return VkSurfaceCapabilitiesKHR.nminImageCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageCount() {
        return VkSurfaceCapabilitiesKHR.nmaxImageCount(this.address());
    }

    public VkExtent2D currentExtent() {
        return VkSurfaceCapabilitiesKHR.ncurrentExtent(this.address());
    }

    public VkSurfaceCapabilitiesKHR currentExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.currentExtent());
        return this;
    }

    public VkExtent2D minImageExtent() {
        return VkSurfaceCapabilitiesKHR.nminImageExtent(this.address());
    }

    public VkSurfaceCapabilitiesKHR minImageExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.minImageExtent());
        return this;
    }

    public VkExtent2D maxImageExtent() {
        return VkSurfaceCapabilitiesKHR.nmaxImageExtent(this.address());
    }

    public VkSurfaceCapabilitiesKHR maxImageExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.maxImageExtent());
        return this;
    }

    @NativeType(value="uint32_t")
    public int maxImageArrayLayers() {
        return VkSurfaceCapabilitiesKHR.nmaxImageArrayLayers(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagsKHR")
    public int supportedTransforms() {
        return VkSurfaceCapabilitiesKHR.nsupportedTransforms(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagBitsKHR")
    public int currentTransform() {
        return VkSurfaceCapabilitiesKHR.ncurrentTransform(this.address());
    }

    @NativeType(value="VkCompositeAlphaFlagsKHR")
    public int supportedCompositeAlpha() {
        return VkSurfaceCapabilitiesKHR.nsupportedCompositeAlpha(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int supportedUsageFlags() {
        return VkSurfaceCapabilitiesKHR.nsupportedUsageFlags(this.address());
    }

    public static VkSurfaceCapabilitiesKHR malloc() {
        return (VkSurfaceCapabilitiesKHR)VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR calloc() {
        return (VkSurfaceCapabilitiesKHR)VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkSurfaceCapabilitiesKHR)VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkSurfaceCapabilitiesKHR create(long address) {
        return (VkSurfaceCapabilitiesKHR)VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, (long)address);
    }

    @Nullable
    public static VkSurfaceCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : (VkSurfaceCapabilitiesKHR)VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkSurfaceCapabilitiesKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkSurfaceCapabilitiesKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkSurfaceCapabilitiesKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSurfaceCapabilitiesKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkSurfaceCapabilitiesKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkSurfaceCapabilitiesKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkSurfaceCapabilitiesKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkSurfaceCapabilitiesKHR mallocStack() {
        return VkSurfaceCapabilitiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceCapabilitiesKHR callocStack() {
        return VkSurfaceCapabilitiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSurfaceCapabilitiesKHR mallocStack(MemoryStack stack) {
        return (VkSurfaceCapabilitiesKHR)VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR callocStack(MemoryStack stack) {
        return (VkSurfaceCapabilitiesKHR)VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSurfaceCapabilitiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSurfaceCapabilitiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSurfaceCapabilitiesKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkSurfaceCapabilitiesKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nminImageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINIMAGECOUNT);
    }

    public static int nmaxImageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMAGECOUNT);
    }

    public static VkExtent2D ncurrentExtent(long struct) {
        return VkExtent2D.create(struct + (long)CURRENTEXTENT);
    }

    public static VkExtent2D nminImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINIMAGEEXTENT);
    }

    public static VkExtent2D nmaxImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXIMAGEEXTENT);
    }

    public static int nmaxImageArrayLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMAGEARRAYLAYERS);
    }

    public static int nsupportedTransforms(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDTRANSFORMS);
    }

    public static int ncurrentTransform(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENTTRANSFORM);
    }

    public static int nsupportedCompositeAlpha(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDCOMPOSITEALPHA);
    }

    public static int nsupportedUsageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDUSAGEFLAGS);
    }

    static {
        Struct.Layout layout = VkSurfaceCapabilitiesKHR.__struct((Struct.Member[])new Struct.Member[]{VkSurfaceCapabilitiesKHR.__member((int)4), VkSurfaceCapabilitiesKHR.__member((int)4), VkSurfaceCapabilitiesKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member((int)4), VkSurfaceCapabilitiesKHR.__member((int)4), VkSurfaceCapabilitiesKHR.__member((int)4), VkSurfaceCapabilitiesKHR.__member((int)4), VkSurfaceCapabilitiesKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MINIMAGECOUNT = layout.offsetof(0);
        MAXIMAGECOUNT = layout.offsetof(1);
        CURRENTEXTENT = layout.offsetof(2);
        MINIMAGEEXTENT = layout.offsetof(3);
        MAXIMAGEEXTENT = layout.offsetof(4);
        MAXIMAGEARRAYLAYERS = layout.offsetof(5);
        SUPPORTEDTRANSFORMS = layout.offsetof(6);
        CURRENTTRANSFORM = layout.offsetof(7);
        SUPPORTEDCOMPOSITEALPHA = layout.offsetof(8);
        SUPPORTEDUSAGEFLAGS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceCapabilitiesKHR, Buffer>
    implements NativeResource {
        private static final VkSurfaceCapabilitiesKHR ELEMENT_FACTORY = VkSurfaceCapabilitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkSurfaceCapabilitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int minImageCount() {
            return VkSurfaceCapabilitiesKHR.nminImageCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageCount() {
            return VkSurfaceCapabilitiesKHR.nmaxImageCount(this.address());
        }

        public VkExtent2D currentExtent() {
            return VkSurfaceCapabilitiesKHR.ncurrentExtent(this.address());
        }

        public Buffer currentExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.currentExtent());
            return this;
        }

        public VkExtent2D minImageExtent() {
            return VkSurfaceCapabilitiesKHR.nminImageExtent(this.address());
        }

        public Buffer minImageExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.minImageExtent());
            return this;
        }

        public VkExtent2D maxImageExtent() {
            return VkSurfaceCapabilitiesKHR.nmaxImageExtent(this.address());
        }

        public Buffer maxImageExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.maxImageExtent());
            return this;
        }

        @NativeType(value="uint32_t")
        public int maxImageArrayLayers() {
            return VkSurfaceCapabilitiesKHR.nmaxImageArrayLayers(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagsKHR")
        public int supportedTransforms() {
            return VkSurfaceCapabilitiesKHR.nsupportedTransforms(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagBitsKHR")
        public int currentTransform() {
            return VkSurfaceCapabilitiesKHR.ncurrentTransform(this.address());
        }

        @NativeType(value="VkCompositeAlphaFlagsKHR")
        public int supportedCompositeAlpha() {
            return VkSurfaceCapabilitiesKHR.nsupportedCompositeAlpha(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int supportedUsageFlags() {
            return VkSurfaceCapabilitiesKHR.nsupportedUsageFlags(this.address());
        }
    }
}

